/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICMultiResourceDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICTargetPlatformSetting;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.utils.ui.controls.TabFolderLayout;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class BinaryParsTab
extends AbstractCPropertyTab {
    private static final int DEFAULT_HEIGHT = 160;
    private static final String ATTR_FILTER = "filter";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_NAME_VISIBILITY = "visibility";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_VALUE_PRIVATE = "private";
    protected Map<String, BinaryParserConfiguration> configMap;
    protected Map<String, BinaryParserPageConfiguration> fParserPageMap = null;
    protected Table table;
    protected CheckboxTableViewer tv;
    protected Composite parserGroup;
    protected SashForm sashForm;
    private ICTargetPlatformSetting tps;

    protected String getParserId() {
        return "BinaryParser";
    }

    @Override
    public void createControls(Composite parent) {
        super.createControls(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.usercomp, "org.eclipse.cdt.ui.newproj_parser_binary");
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        this.sashForm = new SashForm(this.usercomp, 0);
        this.sashForm.setBackground(this.sashForm.getDisplay().getSystemColor(15));
        this.sashForm.setOrientation(512);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 5;
        this.sashForm.setLayout((Layout)layout);
        Composite c1 = new Composite((Composite)this.sashForm, 0);
        c1.setLayout((Layout)new GridLayout(2, false));
        this.setupLabel(c1, Messages.BinaryParsTab_0, 2, 768);
        this.table = new Table(c1, 2084);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BinaryParsTab.this.handleBinaryParserChanged();
                BinaryParsTab.this.updateButtons();
            }
        });
        this.tv = new CheckboxTableViewer(this.table);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String txt;
                String string = txt = element != null ? element.toString() : "";
                if (element instanceof BinaryParserConfiguration) {
                    txt = ((BinaryParserConfiguration)element).getName();
                }
                return txt;
            }
        });
        this.tv.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                BinaryParsTab.this.saveChecked();
            }
        });
        Composite c = new Composite(c1, 0);
        c.setLayoutData((Object)new GridData(3));
        this.initButtons(c, new String[]{MOVEUP_STR, MOVEDOWN_STR});
        this.parserGroup = new Composite((Composite)this.sashForm, 0);
        GridData gd = new GridData();
        this.parserGroup.setLayout((Layout)new TabFolderLayout());
        PixelConverter converter = new PixelConverter((Control)parent);
        gd.heightHint = converter.convertHorizontalDLUsToPixels(160);
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.parserGroup.setLayoutData((Object)gd);
        this.sashForm.setWeights(new int[]{100, 100});
        this.initializeParserList();
        this.initializeParserPageMap();
        this.handleBinaryParserChanged();
    }

    @Override
    public void setVisible(boolean _visible) {
        super.setVisible(_visible);
        this.page.enableConfigSelection(!_visible);
    }

    @Override
    public void updateData(ICResourceDescription cfgd) {
        LinkedHashSet<String> selectedIds = new LinkedHashSet<String>();
        if (this.page.isForPrefs()) {
            if (cfgd != null && cfgd.getConfiguration() != null) {
                String[] binaryParserIds;
                this.tps = cfgd.getConfiguration().getTargetPlatformSetting();
                if (this.tps != null && (binaryParserIds = this.tps.getBinaryParserIds()) != null) {
                    selectedIds.addAll(Arrays.asList(binaryParserIds));
                }
            }
        } else {
            ICConfigurationDescription[] cfgs = this.page.getCfgsEditable();
            String[] binaryParserIds = CoreModelUtil.getBinaryParserIds((ICConfigurationDescription[])cfgs);
            if (binaryParserIds != null) {
                selectedIds.addAll(Arrays.asList(binaryParserIds));
            }
        }
        List<BinaryParserConfiguration> selectedBinaryParsers = selectedIds.stream().map(this.configMap::get).filter(Objects::nonNull).toList();
        List<BinaryParserConfiguration> notSelectedBinaryParsers = this.configMap.entrySet().stream().filter(e -> !selectedIds.contains(e.getKey())).map(Map.Entry::getValue).toList();
        ArrayList<BinaryParserConfiguration> allBinaryParsers = new ArrayList<BinaryParserConfiguration>();
        allBinaryParsers.addAll(selectedBinaryParsers);
        allBinaryParsers.addAll(notSelectedBinaryParsers);
        this.tv.setInput((Object)allBinaryParsers.toArray());
        this.tv.setAllChecked(false);
        selectedBinaryParsers.forEach(e -> {
            boolean bl = this.tv.setChecked(e, true);
        });
        this.updateButtons();
    }

    private void initializeParserList() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "BinaryParser");
        if (point != null) {
            IExtension[] exts = point.getExtensions();
            this.configMap = new HashMap<String, BinaryParserConfiguration>(exts.length);
            IExtension[] iExtensionArray = exts;
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                if (this.isExtensionVisible(ext)) {
                    this.configMap.put(ext.getUniqueIdentifier(), new BinaryParserConfiguration(ext));
                }
                ++n2;
            }
        }
    }

    private void initializeParserPageMap() {
        IConfigurationElement[] infos;
        this.fParserPageMap = new HashMap<String, BinaryParserPageConfiguration>(5);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui", "BinaryParserPage");
        IConfigurationElement[] iConfigurationElementArray = infos = extensionPoint.getConfigurationElements();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement info = iConfigurationElementArray[n2];
            if (info.getName().equals("parserPage")) {
                String id = info.getAttribute("parserID");
                this.fParserPageMap.put(id, new BinaryParserPageConfiguration(info));
            }
            ++n2;
        }
    }

    private boolean isExtensionVisible(IExtension ext) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
        if (elements.length != 0) {
            IConfigurationElement[] children;
            IConfigurationElement element = iConfigurationElementArray[0];
            IConfigurationElement[] iConfigurationElementArray2 = children = element.getChildren(ATTR_FILTER);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String value;
                IConfigurationElement element2 = iConfigurationElementArray2[n2];
                String name = element2.getAttribute(ATTR_NAME);
                if (name != null && name.equals(ATTR_NAME_VISIBILITY) && (value = element2.getAttribute(ATTR_VALUE)) != null && value.equals(ATTR_VALUE_PRIVATE)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    @Override
    public void updateButtons() {
        int cnt = this.table.getItemCount();
        int pos = this.table.getSelectionIndex();
        this.buttonSetEnabled(0, pos > 0);
        this.buttonSetEnabled(1, pos != -1 && pos < cnt - 1);
    }

    protected void handleBinaryParserChanged() {
        ICOptionPage dynamicPage;
        String[] enabled;
        String[] stringArray = enabled = this.getBinaryParserIDs();
        int n = enabled.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            dynamicPage = this.getBinaryParserPage(element);
            if (dynamicPage != null) {
                if (dynamicPage.getControl() == null) {
                    dynamicPage.setContainer(this.page);
                    dynamicPage.createControl(this.parserGroup);
                }
                dynamicPage.setVisible(false);
            }
            ++n2;
        }
        String parserID = this.getCurrentBinaryParserID();
        dynamicPage = this.getBinaryParserPage(parserID);
        if (dynamicPage != null) {
            dynamicPage.setVisible(true);
        }
    }

    protected String[] getBinaryParserIDs() {
        return this.configMap.keySet().toArray(new String[this.configMap.keySet().size()]);
    }

    protected ICOptionPage getBinaryParserPage(String parserID) {
        BinaryParserPageConfiguration configElement = this.fParserPageMap.get(parserID);
        if (configElement != null) {
            try {
                return configElement.getPage();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    protected String getCurrentBinaryParserID() {
        int x = this.table.getSelectionIndex();
        if (x < 0) {
            return null;
        }
        return ((BinaryParserConfiguration)this.table.getItem(x).getData()).getID();
    }

    @Override
    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        if (this.page.isMultiCfg()) {
            src = ((ICResourceDescription[])((ICMultiResourceDescription)src).getItems())[0];
            dst = ((ICResourceDescription[])((ICMultiResourceDescription)dst).getItems())[0];
        }
        ICTargetPlatformSetting tps1 = src.getConfiguration().getTargetPlatformSetting();
        ICTargetPlatformSetting tps2 = dst.getConfiguration().getTargetPlatformSetting();
        if (tps1 != null && tps2 != null) {
            tps2.setBinaryParserIds(tps1.getBinaryParserIds());
        }
    }

    @Override
    protected void performDefaults() {
        if (this.page.isForProject()) {
            CoreModelUtil.setBinaryParserIds((ICConfigurationDescription[])this.page.getCfgsEditable(), null);
        } else if (this.tps != null) {
            this.tps.setBinaryParserIds(null);
        }
        this.informPages(false);
        this.updateData(this.getResDesc());
    }

    private void informPages(boolean apply) {
        NullProgressMonitor mon = new NullProgressMonitor();
        Iterator<BinaryParserPageConfiguration> it = this.fParserPageMap.values().iterator();
        while (it.hasNext()) {
            try {
                ICOptionPage dynamicPage = it.next().getPage();
                if (!dynamicPage.isValid() || dynamicPage.getControl() == null) continue;
                if (apply) {
                    dynamicPage.performApply((IProgressMonitor)mon);
                    continue;
                }
                dynamicPage.performDefaults();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    @Override
    public void buttonPressed(int i) {
        switch (i) {
            case 0: {
                this.moveItem(true);
                break;
            }
            case 1: {
                this.moveItem(false);
                break;
            }
        }
    }

    private void moveItem(boolean up) {
        int n = this.table.getSelectionIndex();
        if (n < 0 || up && n == 0 || !up && n + 1 == this.table.getItemCount()) {
            return;
        }
        Object d = this.tv.getElementAt(n);
        boolean checked = this.tv.getChecked(d);
        this.tv.remove(d);
        n = up ? n - 1 : n + 1;
        this.tv.insert(d, n);
        this.tv.setChecked(d, checked);
        this.table.setSelection(n);
        this.saveChecked();
        this.updateButtons();
    }

    private void saveChecked() {
        Object[] objs = this.tv.getCheckedElements();
        String[] ids = null;
        if (objs != null) {
            ids = new String[objs.length];
            int i = 0;
            while (i < objs.length) {
                ids[i] = ((BinaryParserConfiguration)objs[i]).getID();
                ++i;
            }
        }
        if (this.page.isForPrefs()) {
            if (this.tps != null) {
                this.tps.setBinaryParserIds(ids);
            }
        } else {
            CoreModelUtil.setBinaryParserIds((ICConfigurationDescription[])this.page.getCfgsEditable(), (String[])ids);
        }
    }

    @Override
    public boolean canBeVisible() {
        return this.page.isForProject() || this.page.isForPrefs();
    }

    protected class BinaryParserConfiguration {
        IExtension fExtension;

        public BinaryParserConfiguration(IExtension extension) {
            this.fExtension = extension;
        }

        public String getID() {
            return this.fExtension.getUniqueIdentifier();
        }

        public String getName() {
            return this.fExtension.getLabel();
        }

        public String toString() {
            return this.fExtension.getUniqueIdentifier();
        }

        public boolean equals(Object obj) {
            if (obj instanceof BinaryParserConfiguration) {
                return this.getID().equals(((BinaryParserConfiguration)obj).getID());
            }
            return super.equals(obj);
        }
    }

    protected class BinaryParserPageConfiguration {
        ICOptionPage dynamicPage;
        IConfigurationElement fElement;

        public BinaryParserPageConfiguration(IConfigurationElement element) {
            this.fElement = element;
        }

        public ICOptionPage getPage() throws CoreException {
            if (this.dynamicPage == null) {
                this.dynamicPage = (ICOptionPage)this.fElement.createExecutableExtension("class");
            }
            return this.dynamicPage;
        }
    }
}

