/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.actions;

import java.util.HashSet;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.ui.newui.AbstractPage;
import org.eclipse.cdt.ui.newui.CDTPropertyManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;

public class ChangeConfigAction
extends Action {
    private String fConfigName = null;
    protected HashSet<IProject> fProjects = null;

    public ChangeConfigAction(HashSet<IProject> projects, String configName, String displayName, int accel) {
        super("&" + accel + " " + displayName);
        this.fProjects = projects;
        this.fConfigName = configName;
    }

    public void run() {
        for (IProject prj : this.fProjects) {
            ICProjectDescription prjd = CDTPropertyManager.getProjectDescription(prj);
            boolean changed = false;
            ICConfigurationDescription[] configs = prjd.getConfigurations();
            if (configs != null && configs.length > 0) {
                ICConfigurationDescription[] iCConfigurationDescriptionArray = configs;
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    ICConfigurationDescription config = iCConfigurationDescriptionArray[n2];
                    if (config.getName().equals(this.fConfigName)) {
                        config.setActive();
                        CDTPropertyManager.performOk(null);
                        AbstractPage.updateViews((IResource)prj);
                        changed = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (changed) continue;
            CDTPropertyManager.performCancel(null);
        }
    }
}

