/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.remote.launching;

import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.internal.launch.remote.Messages;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.cdt.launch.remote.RemoteHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;

public class RemoteRunLaunchDelegate
extends AbstractCLaunchDelegate {
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block8: {
            IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
            ICProject project = CDebugUtils.verifyCProject((ILaunchConfiguration)config);
            if (exePath != null) {
                this.verifyBinary(project, exePath);
                String arguments = this.getProgramArguments(config);
                String remoteExePath = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, "");
                String prelaunchCmd = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_PRERUN_COMMANDS, "");
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                if (mode.equals("run")) {
                    monitor.beginTask(Messages.RemoteRunLaunchDelegate_0, 100);
                    Process remoteProcess = null;
                    try {
                        monitor.setTaskName(Messages.RemoteRunLaunchDelegate_2);
                        RemoteHelper.remoteFileDownload(config, launch, exePath.toString(), remoteExePath, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
                        monitor.setTaskName(Messages.RemoteRunLaunchDelegate_12);
                        remoteProcess = RemoteHelper.remoteShellExec(config, prelaunchCmd, remoteExePath, arguments, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                        DebugPlugin.newProcess((ILaunch)launch, (Process)remoteProcess, (String)this.renderProcessLabel(exePath.toOSString()));
                        break block8;
                    }
                    finally {
                        monitor.done();
                    }
                }
                Status status = new Status(4, this.getPluginID(), 0, NLS.bind((String)Messages.RemoteRunLaunchDelegate_1, (Object)mode), null);
                throw new CoreException((IStatus)status);
            }
        }
    }

    protected String getPluginID() {
        return "org.eclipse.cdt.launch.remote";
    }
}

