/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.TreeSet;

class TypedCodeGenerator
extends CodeGenerator {
    private final TypeIRegistry registry;

    TypedCodeGenerator(CodeConsumer consumer, CompilerOptions options, TypeIRegistry registry) {
        super(consumer, options);
        Preconditions.checkNotNull((Object)registry);
        this.registry = registry;
    }

    @Override
    void add(Node n, CodeGenerator.Context context) {
        Node parent = n.getParent();
        if (parent != null && (parent.isBlock() || parent.isScript())) {
            if (n.isFunction()) {
                this.add(this.getFunctionAnnotation(n));
            } else if (n.isExprResult() && n.getFirstChild().isAssign()) {
                Node rhs = n.getFirstChild().getLastChild();
                this.add(this.getTypeAnnotation(rhs));
            } else if (n.isVar() && n.getFirstFirstChild() != null) {
                this.add(this.getTypeAnnotation(n.getFirstFirstChild()));
            }
        }
        super.add(n, context);
    }

    private String getTypeAnnotation(Node node) {
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(node);
        if (jsdoc == null && !node.isFunction()) {
            return "";
        }
        JSType type = node.getJSType();
        if (type == null) {
            return "";
        }
        if (type.isFunctionType()) {
            return this.getFunctionAnnotation(node);
        }
        if (type.isEnumType()) {
            return "/** @enum {" + type.toMaybeEnumType().getElementsType().toAnnotationString() + "} */\n";
        }
        if (!(type.isUnknownType() || type.isEmptyType() || type.isVoidType() || type.isFunctionPrototypeType())) {
            return "/** @type {" + node.getJSType().toAnnotationString() + "} */\n";
        }
        return "";
    }

    private String getFunctionAnnotation(Node fnNode) {
        JSType type = fnNode.getJSType();
        Preconditions.checkState((fnNode.isFunction() || type.isFunctionType() ? 1 : 0) != 0);
        if (type == null || type.isUnknownType()) {
            return "";
        }
        FunctionType funType = type.toMaybeFunctionType();
        if (JSType.isEquivalent(type, (JSType)this.registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE))) {
            return "/** @type {!Function} */\n";
        }
        StringBuilder sb = new StringBuilder("/**\n");
        Node paramNode = null;
        if (fnNode != null && fnNode.isFunction()) {
            paramNode = NodeUtil.getFunctionParameters(fnNode).getFirstChild();
        }
        int i = 0;
        for (Node n : funType.getParameters()) {
            sb.append(" * ");
            TypedCodeGenerator.appendAnnotation(sb, "param", this.getParameterNodeJSDocType(n));
            sb.append(" ").append(paramNode == null ? "p" + i : paramNode.getString()).append("\n");
            if (paramNode != null) {
                paramNode = paramNode.getNext();
                continue;
            }
            ++i;
        }
        JSType retType = funType.getReturnType();
        if (!(retType == null || retType.isEmptyType() || funType.isInterface() || funType.isConstructor() && retType.isVoidType())) {
            sb.append(" * ");
            TypedCodeGenerator.appendAnnotation(sb, "return", retType.toNonNullAnnotationString());
            sb.append("\n");
        }
        if (funType.isConstructor() || funType.isInterface()) {
            Object superInstance;
            FunctionType superConstructor = funType.getSuperClassConstructor();
            if (superConstructor != null && !((JSType)(superInstance = funType.getSuperClassConstructor().getInstanceType())).toString().equals("Object")) {
                sb.append(" * ");
                TypedCodeGenerator.appendAnnotation(sb, "extends", ((JSType)superInstance).toAnnotationString());
                sb.append("\n");
            }
            if (funType.isInterface()) {
                for (ObjectType interfaceType : funType.getExtendedInterfaces()) {
                    sb.append(" * ");
                    TypedCodeGenerator.appendAnnotation(sb, "extends", interfaceType.toAnnotationString());
                    sb.append("\n");
                }
            }
            TreeSet<String> interfaces = new TreeSet<String>();
            for (ObjectType objectType : funType.getImplementedInterfaces()) {
                interfaces.add(objectType.toAnnotationString());
            }
            for (String string : interfaces) {
                sb.append(" * ");
                TypedCodeGenerator.appendAnnotation(sb, "implements", string);
                sb.append("\n");
            }
            if (funType.isConstructor()) {
                sb.append(" * @constructor\n");
            } else if (funType.isInterface()) {
                sb.append(" * @interface\n");
            }
        }
        if (!funType.getTemplateTypeMap().getTemplateKeys().isEmpty()) {
            sb.append(" * @template ");
            Joiner.on((String)",").appendTo(sb, funType.getTemplateTypeMap().getTemplateKeys());
            sb.append("\n");
        }
        sb.append(" */\n");
        return sb.toString();
    }

    private static void appendAnnotation(StringBuilder sb, String name, String type) {
        sb.append("@").append(name).append(" {").append(type).append("}");
    }

    private String getParameterNodeJSDocType(Node parameterNode) {
        JSType parameterType = parameterNode.getJSType();
        String typeString = parameterNode.isOptionalArg() ? this.restrictByUndefined(parameterType).toNonNullAnnotationString() + "=" : (parameterNode.isVarArgs() ? "..." + this.restrictByUndefined(parameterType).toNonNullAnnotationString() : parameterType.toNonNullAnnotationString());
        return typeString;
    }

    private JSType restrictByUndefined(JSType type) {
        if (type.isUnionType()) {
            return type.toMaybeUnionType().getRestrictedUnion((JSType)this.registry.getNativeType(JSTypeNative.VOID_TYPE));
        }
        return type;
    }
}

