/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.bundle.pure.direct;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;
import org.eclipse.wb.internal.core.nls.bundle.AbstractBundleSource;
import org.eclipse.wb.internal.core.nls.bundle.pure.AbstractPureBundleSource;
import org.eclipse.wb.internal.core.nls.bundle.pure.direct.SourceParameters;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.nls.model.IKeyGeneratorStrategy;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;

public final class DirectSource
extends AbstractPureBundleSource {
    private static final String BUNDLE_COMMENT = "Direct ResourceBundle";

    @Override
    protected String getBundleComment() {
        return BUNDLE_COMMENT;
    }

    public static List<AbstractSource> getPossibleSources(JavaInfo root, IPackageFragment pkg) throws Exception {
        ArrayList<AbstractSource> sources = new ArrayList<AbstractSource>();
        Object[] nonJavaResources = pkg.getNonJavaResources();
        int i = 0;
        while (i < nonJavaResources.length) {
            InputStream is;
            String firstLine;
            IFile file;
            String fileName;
            Object o = nonJavaResources[i];
            if (o instanceof IFile && (fileName = (file = (IFile)o).getName()).endsWith(".properties") && fileName.indexOf(95) == -1 && (firstLine = IOUtils2.readFirstLine((InputStream)(is = file.getContents(true)))) != null && firstLine.startsWith("#Direct ResourceBundle")) {
                try {
                    String bundleName = pkg.getElementName() + "." + StringUtils.substring((String)fileName, (int)0, (int)(-".properties".length()));
                    DirectSource source = new DirectSource(root, bundleName);
                    sources.add(source);
                }
                catch (Throwable e) {
                    DesignerPlugin.log((Throwable)e);
                }
            }
            ++i;
        }
        return sources;
    }

    public static AbstractSource get(JavaInfo component, GenericProperty property, Expression expression, List<AbstractSource> sources) throws Exception {
        ExpressionInfo expressionInfo = DirectSource.getExpressionInfo(component, expression);
        if (expressionInfo != null) {
            String bundleName = expressionInfo.m_bundleName;
            DirectSource source = DirectSource.getNewOrExistingSource(component, bundleName, sources);
            source.onKeyAdd(component, expressionInfo.m_key);
            return source;
        }
        return null;
    }

    private static DirectSource getNewOrExistingSource(JavaInfo component, String bundleName, List<AbstractSource> sources) throws Exception {
        for (AbstractSource abstractSource : sources) {
            if (!(abstractSource instanceof DirectSource)) continue;
            DirectSource source = (DirectSource)abstractSource;
            if (!source.m_bundleName.equals(bundleName)) continue;
            return source;
        }
        return new DirectSource(component.getRootJava(), bundleName);
    }

    private static ExpressionInfo getExpressionInfo(JavaInfo component, Expression expression) {
        if (expression instanceof MethodInvocation) {
            boolean is_getBundle;
            boolean is_getString;
            MethodInvocation getString_invocation = (MethodInvocation)expression;
            boolean bl = is_getString = getString_invocation.getName().getIdentifier().equals("getString") && getString_invocation.arguments().size() == 1 && getString_invocation.arguments().get(0) instanceof StringLiteral;
            if (!is_getString) {
                return null;
            }
            if (!(getString_invocation.getExpression() instanceof MethodInvocation)) {
                return null;
            }
            MethodInvocation getBundle_invocation = (MethodInvocation)getString_invocation.getExpression();
            boolean bl2 = is_getBundle = getBundle_invocation.getName().getIdentifier().equals("getBundle") && getBundle_invocation.arguments().size() == 1 && getBundle_invocation.arguments().get(0) instanceof StringLiteral;
            if (!is_getBundle) {
                return null;
            }
            Expression possible_ResourceBundle = getBundle_invocation.getExpression();
            String typeName = AstNodeUtils.getFullyQualifiedName(possible_ResourceBundle, false);
            if (!typeName.equals("java.util.ResourceBundle")) {
                return null;
            }
            StringLiteral bundleNameLiteral = (StringLiteral)getBundle_invocation.arguments().get(0);
            String bundleName = bundleNameLiteral.getLiteralValue();
            StringLiteral keyLiteral = (StringLiteral)getString_invocation.arguments().get(0);
            String key = keyLiteral.getLiteralValue();
            ExpressionInfo expressionInfo = new ExpressionInfo(expression, bundleNameLiteral, bundleName, keyLiteral, key);
            expression.setProperty("NLS_EXPRESSION_INFO", (Object)expressionInfo);
            return expressionInfo;
        }
        return null;
    }

    public DirectSource(JavaInfo root, String bundleName) throws Exception {
        super(root, bundleName);
    }

    @Override
    public String getTypeTitle() throws Exception {
        return "Direct ResourceBundle usage";
    }

    @Override
    protected IKeyGeneratorStrategy getKeyGeneratorStrategy() {
        return KEY_GENERATOR;
    }

    @Override
    protected Expression apply_renameKey_replaceKeyExpression(AstEditor editor, Expression keyExpression, String newKey) throws Exception {
        String newSource = StringConverter.INSTANCE.toJavaSource(this.m_root, newKey);
        return editor.replaceExpression(keyExpression, newSource);
    }

    @Override
    protected AbstractBundleSource.BasicExpressionInfo apply_externalize_replaceExpression(GenericProperty property, String key) throws Exception {
        String code = "java.util.ResourceBundle.getBundle(" + StringConverter.INSTANCE.toJavaSource(this.m_root, this.m_bundleName) + ").getString(" + StringConverter.INSTANCE.toJavaSource(this.m_root, key) + ")";
        Expression expression = property.getExpression();
        ExpressionInfo expressionInfo = (ExpressionInfo)this.replaceExpression_getInfo(expression, code);
        this.addNonNLSComment((Expression)expressionInfo.m_bundleNameExpression);
        this.addNonNLSComment(expressionInfo.m_keyExpression);
        return expressionInfo;
    }

    @Override
    protected void apply_removeNonNLSComments(AbstractBundleSource.BasicExpressionInfo basicExpressionInfo) throws Exception {
        ExpressionInfo expressionInfo = (ExpressionInfo)basicExpressionInfo;
        this.removeNonNLSComment((StringLiteral)expressionInfo.m_keyExpression);
        this.removeNonNLSComment(expressionInfo.m_bundleNameExpression);
    }

    public static DirectSource apply_create(IEditableSource editable, JavaInfo root, Object o) throws Exception {
        SourceParameters parameters = (SourceParameters)o;
        DirectSource.createPropertyBundleFile(parameters.m_propertyPackage, parameters.m_propertyFileName, null);
        return new DirectSource(root, parameters.m_propertyBundleName);
    }

    protected static class ExpressionInfo
    extends AbstractBundleSource.BasicExpressionInfo {
        private final StringLiteral m_bundleNameExpression;
        private final String m_bundleName;

        public ExpressionInfo(Expression expression, StringLiteral bundleNameExpression, String bundleName, StringLiteral keyExpression, String key) {
            super(expression, (Expression)keyExpression, key);
            this.m_bundleNameExpression = bundleNameExpression;
            this.m_bundleName = bundleName;
        }
    }
}

