/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.handlers.HandlerUtil;

class CopyTableSelectionHandler
extends AbstractHandler {
    CopyTableSelectionHandler() {
    }

    public Object execute(ExecutionEvent event) {
        Object control = HandlerUtil.getVariable(event, "activeFocusControl");
        if (control instanceof Table) {
            this.copySelection((Table)control);
        }
        return null;
    }

    public void copySelection(Table table) {
        String text = CopyTableSelectionHandler.selectionToString(table);
        if (text.isEmpty()) {
            return;
        }
        Clipboard clipboard = new Clipboard(table.getDisplay());
        clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }

    private static String selectionToString(Table table) {
        StringBuilder builder = new StringBuilder();
        TableItem[] tableItemArray = table.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            if (builder.length() > 0) {
                builder.append(System.lineSeparator());
            }
            int column = 0;
            while (column < table.getColumnCount()) {
                if (column > 0) {
                    builder.append('\t');
                }
                builder.append(tableItem.getText(column));
                ++column;
            }
            ++n2;
        }
        return builder.toString();
    }
}

