/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.views.scriptpad.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.tcf.te.tcf.ui.views.scriptpad.ScriptPad;

public class PasteAction
extends Action {
    private final ScriptPad view;

    public PasteAction(ScriptPad view) {
        Assert.isNotNull((Object)((Object)view));
        this.view = view;
    }

    public void run() {
        if (this.view.getStyledText() == null || this.view.getStyledText().isDisposed()) {
            return;
        }
        this.view.getStyledText().paste();
        this.view.updateActionEnablements();
    }

    public void updateEnabledState() {
        boolean canPaste = false;
        if (this.view.getStyledText() != null && this.view.getStyledText().getEditable()) {
            Clipboard clipboard = new Clipboard(this.view.getStyledText().getDisplay());
            TransferData[] td = clipboard.getAvailableTypes();
            int i = 0;
            while (i < td.length) {
                if (TextTransfer.getInstance().isSupportedType(td[i])) {
                    canPaste = true;
                    break;
                }
                ++i;
            }
            clipboard.dispose();
        }
        this.setEnabled(canPaste);
    }
}

