/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.log.core.internal.listener;

import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.core.AbstractChannel;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.tcf.log.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.log.core.events.MonitorEvent;
import org.eclipse.tcf.te.tcf.log.core.internal.listener.ChannelTraceListener;
import org.eclipse.tcf.te.tcf.log.core.internal.nls.Messages;
import org.eclipse.tcf.te.tcf.log.core.manager.LogManager;

public final class ChannelTraceListenerManager {
    public final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final Map<IChannel, AbstractChannel.TraceListener> listeners = new HashMap<IChannel, AbstractChannel.TraceListener>();
    final Map<IChannel, List<String>> queued = new HashMap<IChannel, List<String>>();

    public static ChannelTraceListenerManager getInstance() {
        return LazyInstanceHolder.instance;
    }

    ChannelTraceListenerManager() {
    }

    public void onChannelOpened(final String logname, final IChannel channel, final String message) {
        Assert.isNotNull((Object)channel);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelTraceListener")) {
            CoreBundleActivator.getTraceHandler().trace("TraceListener.onChannelOpened ( " + channel + ", \"" + message + "\" )", "trace/channelTraceListener", (Object)this);
        }
        if (!(channel instanceof AbstractChannel)) {
            return;
        }
        final IPeer peer = channel.getRemotePeer();
        if (peer == null) {
            return;
        }
        boolean loggingEnabled = CoreBundleActivator.getScopedPreferences().getBoolean("te.tcf.log.core.enabled");
        if (!loggingEnabled) {
            return;
        }
        AbstractChannel.TraceListener traceListener = this.listeners.remove(channel);
        if (traceListener != null) {
            ((AbstractChannel)channel).removeTraceListener(traceListener);
        }
        traceListener = new ChannelTraceListener(logname, channel);
        ((AbstractChannel)channel).addTraceListener(traceListener);
        this.listeners.put(channel, traceListener);
        final String date = this.DATE_FORMAT.format(new Date(System.currentTimeMillis()));
        ExecutorsUtil.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                String fullMessage = NLS.bind((String)Messages.ChannelTraceListener_channelOpened_message, (Object[])new Object[]{date, Integer.toHexString(channel.hashCode()), message != null ? "(" + message.trim() + ")" : ""});
                FileWriter writer = LogManager.getInstance().getWriter(logname, peer);
                if (writer != null) {
                    try {
                        writer.write("\n\n\n");
                        List<String> queue = ChannelTraceListenerManager.this.queued.remove(channel);
                        if (queue != null) {
                            for (String m : queue) {
                                writer.write(m);
                                writer.write("\n");
                            }
                        }
                        writer.write(fullMessage);
                        writer.write("\n");
                        writer.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                LogManager.getInstance().monitor(peer, MonitorEvent.Type.OPEN, new MonitorEvent.Message('F', fullMessage));
            }
        });
    }

    public void onChannelOpening(String logname, final IChannel channel, final String message) {
        boolean loggingEnabled;
        Assert.isNotNull((Object)channel);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelTraceListener")) {
            CoreBundleActivator.getTraceHandler().trace("TraceListener.onChannelOpening ( " + channel + ", \"" + message + "\" )", "trace/channelTraceListener", (Object)this);
        }
        if (!(loggingEnabled = CoreBundleActivator.getScopedPreferences().getBoolean("te.tcf.log.core.enabled"))) {
            return;
        }
        final String date = this.DATE_FORMAT.format(new Date(System.currentTimeMillis()));
        ExecutorsUtil.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                String fullMessage = NLS.bind((String)Messages.ChannelTraceListener_channelOpening_message, (Object[])new Object[]{date, Integer.toHexString(channel.hashCode()), message != null ? "(" + message.trim() + ")" : ""});
                List<String> queue = ChannelTraceListenerManager.this.queued.get(channel);
                if (queue == null) {
                    queue = new ArrayList<String>();
                    ChannelTraceListenerManager.this.queued.put(channel, queue);
                }
                queue.add(fullMessage);
            }
        });
    }

    public void onChannelRedirected(String logname, final IChannel channel, final String message) {
        boolean loggingEnabled;
        Assert.isNotNull((Object)channel);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelTraceListener")) {
            CoreBundleActivator.getTraceHandler().trace("TraceListener.onChannelRedirected ( " + channel + ", \"" + message + "\" )", "trace/channelTraceListener", (Object)this);
        }
        if (!(loggingEnabled = CoreBundleActivator.getScopedPreferences().getBoolean("te.tcf.log.core.enabled"))) {
            return;
        }
        final String date = this.DATE_FORMAT.format(new Date(System.currentTimeMillis()));
        ExecutorsUtil.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                String fullMessage = NLS.bind((String)Messages.ChannelTraceListener_channelRedirected_message, (Object[])new Object[]{date, Integer.toHexString(channel.hashCode()), message != null ? "(" + message.trim() + ")" : ""});
                List<String> queue = ChannelTraceListenerManager.this.queued.get(channel);
                if (queue == null) {
                    queue = new ArrayList<String>();
                    ChannelTraceListenerManager.this.queued.put(channel, queue);
                }
                queue.add(fullMessage);
            }
        });
    }

    public void onChannelServices(String logname, final IChannel channel, final String message) {
        boolean loggingEnabled;
        Assert.isNotNull((Object)channel);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelTraceListener")) {
            CoreBundleActivator.getTraceHandler().trace("TraceListener.onChannelServices ( " + channel + ", \"" + message + "\" )", "trace/channelTraceListener", (Object)this);
        }
        if (!(loggingEnabled = CoreBundleActivator.getScopedPreferences().getBoolean("te.tcf.log.core.enabled"))) {
            return;
        }
        final String date = this.DATE_FORMAT.format(new Date(System.currentTimeMillis()));
        ExecutorsUtil.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                String fullMessage = NLS.bind((String)Messages.ChannelTraceListener_channelServices_message, (Object[])new Object[]{date, Integer.toHexString(channel.hashCode()), message != null ? "(" + message.trim() + ")" : ""});
                List<String> queue = ChannelTraceListenerManager.this.queued.get(channel);
                if (queue == null) {
                    queue = new ArrayList<String>();
                    ChannelTraceListenerManager.this.queued.put(channel, queue);
                }
                queue.add(fullMessage);
            }
        });
    }

    public void onMark(final String logname, final IChannel channel, final String message) {
        IPeer peer;
        Assert.isNotNull((Object)channel);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelTraceListener")) {
            CoreBundleActivator.getTraceHandler().trace("TraceListener.onMark ( " + channel + ", \"" + message + "\" )", "trace/channelTraceListener", (Object)this);
        }
        if ((peer = channel.getRemotePeer()) == null) {
            return;
        }
        boolean loggingEnabled = CoreBundleActivator.getScopedPreferences().getBoolean("te.tcf.log.core.enabled");
        if (!loggingEnabled) {
            return;
        }
        final String date = this.DATE_FORMAT.format(new Date(System.currentTimeMillis()));
        ExecutorsUtil.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                String fullMessage = NLS.bind((String)Messages.ChannelTraceListener_channelMark_message, (Object[])new Object[]{date, Integer.toHexString(channel.hashCode()), message != null ? "(" + message.trim() + ")" : ""});
                FileWriter writer = LogManager.getInstance().getWriter(logname, peer);
                if (writer != null) {
                    try {
                        writer.write(fullMessage);
                        writer.write("\n");
                        writer.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void onChannelClosed(String logname, final IChannel channel) {
        Assert.isNotNull((Object)channel);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        ExecutorsUtil.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ChannelTraceListenerManager.this.queued.remove(channel);
            }
        });
        if (!(channel instanceof AbstractChannel)) {
            return;
        }
        final AbstractChannel.TraceListener traceListener = this.listeners.remove(channel);
        if (traceListener != null) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((AbstractChannel)channel).removeTraceListener(traceListener);
                }
            });
        }
    }

    private static class LazyInstanceHolder {
        public static ChannelTraceListenerManager instance = new ChannelTraceListenerManager();

        private LazyInstanceHolder() {
        }
    }
}

