/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.core.concurrent.TCFOperationMonitor;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IResultOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.AbstractOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public abstract class OpCreate
extends AbstractOperation
implements IResultOperation<IFSTreeNode> {
    protected final FSTreeNode fDestination;
    protected final String fName;
    protected FSTreeNode fResult;

    public OpCreate(FSTreeNode folder, String name) {
        Assert.isNotNull((Object)folder);
        Assert.isNotNull((Object)name);
        this.fDestination = folder;
        this.fName = name;
    }

    @Override
    protected IStatus doRun(IProgressMonitor monitor) {
        IStatus status;
        if (this.fDestination.getChildren() == null && !(status = this.fDestination.operationRefresh(false).run((IProgressMonitor)new SubProgressMonitor(monitor, 0))).isOK()) {
            return status;
        }
        FSTreeNode existing = this.fDestination.findChild(this.fName);
        if (existing != null) {
            return StatusHelper.createStatus(MessageFormat.format(Messages.OpCreate_error_existingFile, existing.getLocation()), null);
        }
        final TCFOperationMonitor result = new TCFOperationMonitor();
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                OpCreate.this.tcfCreate(OpCreate.this.fDestination, OpCreate.this.fName, (TCFOperationMonitor<FSTreeNode>)result);
            }
        });
        IStatus status2 = result.waitDone(monitor);
        this.fResult = (FSTreeNode)result.getValue();
        return status2;
    }

    protected abstract void tcfCreate(FSTreeNode var1, String var2, TCFOperationMonitor<FSTreeNode> var3);

    @Override
    public String getName() {
        return NLS.bind((String)Messages.OpCreate_TaskName, (Object)this.fName);
    }

    @Override
    public FSTreeNode getResult() {
        return this.fResult;
    }
}

