/*******************************************************************************
 * Copyright (c) 2012 Red Hat Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Rastislav Wagner (Red Hat)
 *******************************************************************************/
package org.eclipse.swtbot.generator.jdt.editor.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swtbot.generator.framework.AnnotationRule;
import org.eclipse.swtbot.generator.ui.BotGeneratorEventDispatcher;
import org.eclipse.swtbot.generator.jdt.editor.document.ClassDocument;

public class ClassAnnotationSelectionListener extends AbstractAnnotationSelectionListener {

	public ClassAnnotationSelectionListener(ToolItem dropdown, BotGeneratorEventDispatcher recorder, Map<CTabItem, SourceViewer> tabViewer, CTabFolder classTabFolder) {
		super(dropdown,recorder,tabViewer,classTabFolder);
	}

	@Override
	protected List<AnnotationRule> filterRules(List<AnnotationRule> items) {
		List<AnnotationRule> classAnnotations = new ArrayList<AnnotationRule>();
		for(AnnotationRule item: items){
			if(item.isClassAnnotation()){
				classAnnotations.add(item);
			}
		}
		return classAnnotations;
	}

	@Override
	protected SelectionAdapter getSelectionAdapter(final MenuItem menuItem) {
		return new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent event) {
				MenuItem selected = (MenuItem) event.widget;
				SourceViewer viewer = tabViewer.get(classTabFolder.getSelection());
				ClassDocument doc = (ClassDocument) viewer.getDocument();
				if (selected.getSelection()) {
					doc.addClassAnnotation((AnnotationRule) menuItem.getData());
				} else {
					doc.removeClassAnnotation((AnnotationRule) menuItem.getData());
				}
				update();
			}
		};
	}
	@Override
	protected boolean checkDocAnnotation(ClassDocument doc, MenuItem i) {
		return doc.getClassAnnotations().contains(i.getData());
	}
}
