/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.internal.importexport.RemoteImportExportPlugin;
import org.eclipse.rse.internal.importexport.RemoteImportExportResources;
import org.eclipse.rse.internal.importexport.RemoteImportExportUtil;
import org.eclipse.rse.internal.importexport.SystemImportExportResources;
import org.eclipse.rse.internal.importexport.files.IImportStructureProvider;
import org.eclipse.rse.internal.importexport.files.IRemoteFileImportDescriptionWriter;
import org.eclipse.rse.internal.importexport.files.RemoteFileImportData;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class RemoteFileImportOperation
extends WorkspaceModifyOperation {
    private static final int POLICY_DEFAULT = 0;
    private static final int POLICY_SKIP_CHILDREN = 1;
    private static final int POLICY_FORCE_OVERWRITE = 2;
    private Object source;
    private IPath destinationPath;
    private IContainer destinationContainer;
    private List selectedFiles;
    private IImportStructureProvider provider;
    private IProgressMonitor monitor;
    protected IOverwriteQuery overwriteCallback;
    private List errorTable = new ArrayList();
    private boolean createContainerStructure = true;
    private RemoteFileImportData importData;
    private boolean saveSettings;
    private String descriptionFilePath;
    private static final int OVERWRITE_NOT_SET = 0;
    private static final int OVERWRITE_NONE = 1;
    private static final int OVERWRITE_ALL = 2;
    private int overwriteState = 0;
    private boolean reviewSynchronize = true;

    public RemoteFileImportOperation(IPath containerPath, Object source, IImportStructureProvider provider, IOverwriteQuery overwriteImplementor) {
        this.destinationPath = containerPath;
        this.source = source;
        this.provider = provider;
        this.overwriteCallback = overwriteImplementor;
    }

    public RemoteFileImportOperation(IPath containerPath, Object source, IImportStructureProvider provider, IOverwriteQuery overwriteImplementor, List filesToImport) {
        this(containerPath, source, provider, overwriteImplementor);
        this.setFilesToImport(filesToImport);
    }

    public RemoteFileImportOperation(RemoteFileImportData data, IImportStructureProvider provider, IOverwriteQuery overwriteImplementor) {
        this(data.getContainerPath(), data.getSource(), provider, overwriteImplementor);
        this.setFilesToImport(data.getElements());
        this.setOverwriteResources(data.isOverWriteExistingFiles());
        this.setReviewSynchronize(data.isReviewSynchronize());
        this.setCreateContainerStructure(data.isCreateDirectoryStructure());
        this.importData = data;
        this.saveSettings = data.isSaveSettings();
        this.descriptionFilePath = data.getDescriptionFilePath();
    }

    public RemoteFileImportOperation(IPath containerPath, IImportStructureProvider provider, IOverwriteQuery overwriteImplementor, List filesToImport) {
        this(containerPath, null, provider, overwriteImplementor);
        this.setFilesToImport(filesToImport);
    }

    IContainer createContainersFor(IPath path) throws CoreException {
        IContainer currentFolder = this.destinationContainer;
        int segmentCount = path.segmentCount();
        if (segmentCount == 0) {
            return currentFolder;
        }
        if (currentFolder.getType() == 8) {
            return this.createFromRoot(path);
        }
        int i = 0;
        while (i < segmentCount) {
            if (!(currentFolder = currentFolder.getFolder((IPath)new Path(path.segment(i)))).exists()) {
                ((IFolder)currentFolder).create(false, true, null);
            }
            ++i;
        }
        return currentFolder;
    }

    private IContainer createFromRoot(IPath path) throws CoreException {
        int segmentCount = path.segmentCount();
        IProject currentFolder = ((IWorkspaceRoot)this.destinationContainer).getProject(path.segment(0));
        int i = 1;
        while (i < segmentCount) {
            if (!(currentFolder = currentFolder.getFolder((IPath)new Path(path.segment(i)))).exists()) {
                ((IFolder)currentFolder).create(false, true, null);
            }
            ++i;
        }
        return currentFolder;
    }

    void deleteResource(IResource resource) {
        try {
            resource.delete(2, null);
        }
        catch (CoreException e) {
            this.errorTable.add(e.getStatus());
        }
    }

    boolean ensureTargetDoesNotExist(IResource targetResource, int policy) {
        if (targetResource.exists()) {
            if (policy != 2) {
                if (this.overwriteState == 0 && !this.queryOverwrite(targetResource.getFullPath())) {
                    return false;
                }
                if (this.overwriteState == 1) {
                    return false;
                }
            }
            this.deleteResource(targetResource);
        }
        return true;
    }

    protected void execute(IProgressMonitor progressMonitor) {
        block10: {
            this.monitor = progressMonitor;
            try {
                try {
                    if (this.selectedFiles == null) {
                        String taskMsg = SystemImportExportResources.RESID_FILEIMPORT_IMPORTING;
                        this.monitor.beginTask(taskMsg, 1000);
                        ContainerGenerator generator = new ContainerGenerator(this.destinationPath);
                        this.monitor.worked(50);
                        this.destinationContainer = generator.generateContainer((IProgressMonitor)new SubProgressMonitor(this.monitor, 50));
                        this.importRecursivelyFrom(this.source, 0);
                        this.monitor.worked(90);
                    } else {
                        int creationCount = this.selectedFiles.size();
                        String taskMsg = SystemImportExportResources.RESID_FILEIMPORT_IMPORTING;
                        this.monitor.beginTask(taskMsg, creationCount + 100);
                        ContainerGenerator generator = new ContainerGenerator(this.destinationPath);
                        this.monitor.worked(50);
                        this.destinationContainer = generator.generateContainer((IProgressMonitor)new SubProgressMonitor(this.monitor, 50));
                        this.importFileSystemObjects(this.selectedFiles);
                    }
                    if (!this.saveSettings) break block10;
                    try {
                        this.saveDescription();
                    }
                    catch (CoreException e) {
                        SystemBasePlugin.logError((String)("Error occured trying to save description " + this.descriptionFilePath), (Throwable)e);
                        this.errorTable.add(e.getStatus());
                    }
                    catch (IOException e) {
                        SystemBasePlugin.logError((String)("Error occured trying to save description " + this.descriptionFilePath), (Throwable)e);
                        this.errorTable.add(new Status(4, RemoteImportExportPlugin.getDefault().getSymbolicName(), 0, e.getLocalizedMessage(), (Throwable)e));
                    }
                }
                catch (CoreException e) {
                    this.errorTable.add(e.getStatus());
                    this.monitor.done();
                }
            }
            finally {
                this.monitor.done();
            }
        }
    }

    protected void saveDescription() throws CoreException, IOException {
        ByteArrayOutputStream objectStreamOutput = new ByteArrayOutputStream();
        IRemoteFileImportDescriptionWriter writer = this.importData.createImportDescriptionWriter(objectStreamOutput);
        ByteArrayInputStream fileInput = null;
        try {
            writer.write(this.importData);
            fileInput = new ByteArrayInputStream(objectStreamOutput.toByteArray());
            IFile descriptionFile = this.importData.getDescriptionFile();
            if (descriptionFile.isAccessible()) {
                descriptionFile.setContents((InputStream)fileInput, true, true, null);
            } else {
                IResource variant = RemoteImportExportUtil.getInstance().findExistingResourceVariant(descriptionFile.getFullPath());
                if (variant == null) {
                    IContainer parent = descriptionFile.getParent();
                    if (parent != null) {
                        IResource parentVariant = RemoteImportExportUtil.getInstance().findExistingResourceVariant(parent.getFullPath());
                        if (parentVariant == null) {
                            descriptionFile.create((InputStream)fileInput, true, null);
                        } else {
                            IPath newPath = parentVariant.getFullPath().append(descriptionFile.getName());
                            IFile newDescriptionFile = SystemBasePlugin.getWorkspace().getRoot().getFile(newPath);
                            newDescriptionFile.create((InputStream)fileInput, true, null);
                        }
                    }
                } else if (variant instanceof IFile) {
                    ((IFile)variant).setContents((InputStream)fileInput, true, true, null);
                }
            }
        }
        finally {
            if (fileInput != null) {
                fileInput.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    IContainer getDestinationContainerFor(Object fileSystemObject) throws CoreException {
        Path pathname = new Path(this.provider.getFullPath(fileSystemObject));
        if (this.createContainerStructure) {
            return this.createContainersFor(pathname.removeLastSegments(1));
        }
        if (this.source == fileSystemObject) {
            return null;
        }
        Path sourcePath = new Path(this.provider.getFullPath(this.source));
        IPath destContainerPath = pathname.removeLastSegments(1);
        IPath relativePath = destContainerPath.removeFirstSegments(sourcePath.segmentCount()).setDevice(null);
        return this.createContainersFor(relativePath);
    }

    public IStatus getStatus() {
        IStatus[] errors = new IStatus[this.errorTable.size()];
        this.errorTable.toArray(errors);
        String msg = RemoteImportExportResources.FILEMSG_IMPORT_PROBLEMS;
        return new MultiStatus(RemoteImportExportPlugin.getDefault().getBundle().getSymbolicName(), 0, errors, msg, null);
    }

    private IFile existingFileInDifferentCase(IFile file) throws CoreException {
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("win");
        if (!isWindows) {
            return null;
        }
        String newName = file.getName();
        IContainer parent = file.getParent();
        IResource[] members = parent.members();
        int i = 0;
        while (i < members.length) {
            String memberName;
            IResource member = members[i];
            if (member instanceof IFile && newName.equalsIgnoreCase(memberName = member.getName())) {
                return (IFile)member;
            }
            ++i;
        }
        return null;
    }

    void importFile(Object fileObject, int policy) {
        IContainer containerResource;
        try {
            containerResource = this.getDestinationContainerFor(fileObject);
        }
        catch (CoreException e) {
            IStatus coreStatus = e.getStatus();
            String newMessage = NLS.bind((String)RemoteImportExportResources.FILEMSG_IMPORT_ERROR, (Object)fileObject, (Object)coreStatus.getMessage());
            Status status = new Status(coreStatus.getSeverity(), coreStatus.getPlugin(), coreStatus.getCode(), newMessage, null);
            this.errorTable.add(status);
            return;
        }
        String fileObjectPath = this.provider.getFullPath(fileObject);
        this.monitor.subTask(fileObjectPath);
        IFile targetResource = containerResource.getFile((IPath)new Path(this.provider.getLabel(fileObject)));
        this.monitor.worked(1);
        IPath targetPath = targetResource.getLocation();
        if (targetPath != null && targetPath.toFile().equals(new File(fileObjectPath))) {
            String msg = NLS.bind((String)RemoteImportExportResources.FILEMSG_IMPORT_SELF, (Object)fileObjectPath);
            this.errorTable.add(new Status(4, RemoteImportExportPlugin.getDefault().getBundle().getSymbolicName(), 0, msg, null));
            return;
        }
        if (!this.ensureTargetDoesNotExist((IResource)targetResource, policy)) {
            return;
        }
        try {
            IFile existingFile;
            IRemoteFileSubSystem rfss = RemoteFileUtility.getFileSubSystem((IHost)((UniFilePlus)fileObject).remoteFile.getHost());
            String encoding = ((UniFilePlus)fileObject).remoteFile.getEncoding();
            if (encoding.startsWith("CP")) {
                encoding = "Cp" + encoding.substring(2);
            }
            if ((existingFile = this.existingFileInDifferentCase(targetResource)) != null) {
                String msgDetails = NLS.bind((String)FileResources.FILEMSG_CREATE_FILE_FAILED_EXIST_DETAILS, (Object)existingFile.getFullPath());
                this.errorTable.add(new Status(4, RemoteImportExportPlugin.getDefault().getBundle().getSymbolicName(), msgDetails));
                return;
            }
            if (targetResource.getLocation() == null) {
                String remoteFileName = ((UniFilePlus)fileObject).remoteFile.getName();
                String remoteParentPath = ((UniFilePlus)fileObject).remoteFile.getParentPath();
                InputStream instream = rfss.getInputStream(remoteParentPath, remoteFileName, true, this.monitor);
                if (!targetResource.exists()) {
                    targetResource.create(instream, 1, this.monitor);
                } else {
                    targetResource.setContents(instream, 1, this.monitor);
                }
            } else {
                rfss.download(((UniFilePlus)fileObject).remoteFile, targetResource.getLocation().makeAbsolute().toOSString(), encoding, null);
            }
            try {
                targetResource.refreshLocal(0, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1, 2));
            }
            catch (CoreException e) {
                this.errorTable.add(e.getStatus());
            }
        }
        catch (RemoteFileIOException e) {
            String msg = NLS.bind((String)RemoteImportExportResources.FILEMSG_IMPORT_ERROR, (Object)fileObjectPath, (Object)e.getRemoteException().getLocalizedMessage());
            this.errorTable.add(new Status(4, RemoteImportExportPlugin.getDefault().getBundle().getSymbolicName(), 0, msg, (Throwable)e));
            return;
        }
        catch (RemoteFileSecurityException e) {
            String msg = NLS.bind((String)RemoteImportExportResources.FILEMSG_IMPORT_ERROR, (Object)fileObjectPath, (Object)e.getRemoteException().getLocalizedMessage());
            this.errorTable.add(new Status(4, RemoteImportExportPlugin.getDefault().getBundle().getSymbolicName(), 0, msg, (Throwable)e));
            return;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)RemoteImportExportResources.FILEMSG_IMPORT_ERROR, (Object)fileObjectPath, (Object)(e.getMessage() == null ? e.toString() : e.getMessage()));
            this.errorTable.add(new Status(4, RemoteImportExportPlugin.getDefault().getBundle().getSymbolicName(), 0, msg, (Throwable)e));
            return;
        }
    }

    void importFileSystemObjects(List filesToImport) {
        for (Object fileSystemObject : filesToImport) {
            if (this.source == null) {
                IPath sourcePath = new Path(this.provider.getFullPath(fileSystemObject)).removeLastSegments(1);
                if (this.provider.isFolder(fileSystemObject) && sourcePath.isEmpty()) {
                    String msg = RemoteImportExportResources.FILEMSG_COPY_ROOT;
                    this.errorTable.add(new Status(1, RemoteImportExportPlugin.getDefault().getBundle().getSymbolicName(), 0, msg, null));
                    continue;
                }
                this.source = sourcePath.toFile();
            }
            this.importRecursivelyFrom(fileSystemObject, 0);
        }
    }

    int importFolder(Object folderObject, int policy) {
        IContainer containerResource;
        try {
            containerResource = this.getDestinationContainerFor(folderObject);
        }
        catch (CoreException e) {
            this.errorTable.add(e.getStatus());
            return policy;
        }
        if (containerResource == null) {
            return policy;
        }
        this.monitor.subTask(this.provider.getFullPath(folderObject));
        IWorkspace workspace = this.destinationContainer.getWorkspace();
        IPath containerPath = containerResource.getFullPath();
        IPath resourcePath = containerPath.append(this.provider.getLabel(folderObject));
        if (resourcePath.equals((Object)containerPath)) {
            return policy;
        }
        if (workspace.getRoot().exists(resourcePath)) {
            if (!(policy == 2 || this.overwriteState != 1 && this.queryOverwrite(resourcePath))) {
                return 1;
            }
            return 2;
        }
        try {
            workspace.getRoot().getFolder(resourcePath).create(false, true, null);
        }
        catch (CoreException e) {
            this.errorTable.add(e.getStatus());
        }
        return policy;
    }

    void importRecursivelyFrom(Object fileSystemObject, int policy) {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!this.provider.isFolder(fileSystemObject)) {
            this.importFile(fileSystemObject, policy);
            return;
        }
        int childPolicy = this.importFolder(fileSystemObject, policy);
        if (childPolicy != 1) {
            Iterator children = this.provider.getChildren(fileSystemObject).iterator();
            while (children.hasNext()) {
                this.importRecursivelyFrom(children.next(), childPolicy);
            }
        }
    }

    boolean queryOverwrite(IPath resourcePath) throws OperationCanceledException {
        String overwriteAnswer = this.overwriteCallback.queryOverwrite(resourcePath.makeRelative().toString());
        if (overwriteAnswer.equals("CANCEL")) {
            throw new OperationCanceledException("");
        }
        if (overwriteAnswer.equals("NO")) {
            return false;
        }
        if (overwriteAnswer.equals("NOALL")) {
            this.overwriteState = 1;
            return false;
        }
        if (overwriteAnswer.equals("ALL")) {
            this.overwriteState = 2;
        }
        return true;
    }

    public void setCreateContainerStructure(boolean value) {
        this.createContainerStructure = value;
    }

    public void setFilesToImport(List filesToImport) {
        this.selectedFiles = filesToImport;
    }

    public void setOverwriteResources(boolean value) {
        if (value) {
            this.overwriteState = 2;
        }
    }

    public void setReviewSynchronize(boolean value) {
        this.reviewSynchronize = value;
    }
}

