/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Severity implements Enumerator
{
    UNKNOWN(0, "UNKNOWN", "UNKNOWN"),
    OK(1, "OK", "OK"),
    INFO(2, "INFO", "INFO"),
    WARNING(3, "WARNING", "WARNING"),
    ERROR(4, "ERROR", "ERROR"),
    FATAL(5, "FATAL", "FATAL");

    public static final int UNKNOWN_VALUE = 0;
    public static final int OK_VALUE = 1;
    public static final int INFO_VALUE = 2;
    public static final int WARNING_VALUE = 3;
    public static final int ERROR_VALUE = 4;
    public static final int FATAL_VALUE = 5;
    private static final Severity[] VALUES_ARRAY;
    public static final List<Severity> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Severity[]{UNKNOWN, OK, INFO, WARNING, ERROR, FATAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Severity get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Severity result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Severity getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Severity result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Severity get(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return OK;
            }
            case 2: {
                return INFO;
            }
            case 3: {
                return WARNING;
            }
            case 4: {
                return ERROR;
            }
            case 5: {
                return FATAL;
            }
        }
        return null;
    }

    private Severity(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

