/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal;

import java.util.Locale;
import org.eclipse.nebula.widgets.grid.AbstractRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;

public class ToggleRenderer
extends AbstractRenderer {
    private static final boolean IS_MAC;

    static {
        String osName;
        String osProperty = System.getProperty("os.name");
        IS_MAC = osProperty != null ? (osName = osProperty.toUpperCase(Locale.getDefault())).indexOf("MAC") > -1 : false;
    }

    public ToggleRenderer() {
        if (IS_MAC) {
            this.setSize(new Point(10, 10));
        } else {
            this.setSize(9, 9);
        }
    }

    @Override
    public void paint(GC gc, Object value) {
        if (IS_MAC) {
            this.paintMacTwistie(gc);
        } else {
            this.paintPlusMinus(gc);
        }
    }

    private void paintMacTwistie(GC gc) {
        Transform transform = new Transform(gc.getDevice());
        transform.translate((float)this.getBounds().x, (float)this.getBounds().y);
        gc.setTransform(transform);
        Color back = gc.getBackground();
        Color fore = gc.getForeground();
        if (!this.isHover()) {
            gc.setForeground(gc.getDevice().getSystemColor(18));
        } else {
            gc.setForeground(gc.getDevice().getSystemColor(26));
        }
        gc.setBackground(gc.getForeground());
        if (this.isExpanded()) {
            gc.drawPolygon(new int[]{1, 3, 4, 6, 5, 6, 8, 3});
            gc.fillPolygon(new int[]{1, 3, 4, 6, 5, 6, 8, 3});
        } else {
            gc.drawPolygon(new int[]{3, 1, 6, 4, 6, 5, 3, 8});
            gc.fillPolygon(new int[]{3, 1, 6, 4, 6, 5, 3, 8});
        }
        if (this.isFocus()) {
            gc.setBackground(back);
            gc.setForeground(fore);
            gc.drawFocus(-1, -1, 12, 12);
        }
        gc.setTransform(null);
        transform.dispose();
    }

    private void paintPlusMinus(GC gc) {
        gc.setBackground(this.getDisplay().getSystemColor(25));
        gc.fillRectangle(this.getBounds());
        gc.setForeground(this.getDisplay().getSystemColor(18));
        gc.drawRectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width - 1, this.getBounds().height - 1);
        gc.setForeground(this.getDisplay().getSystemColor(21));
        gc.drawLine(this.getBounds().x + 2, this.getBounds().y + 4, this.getBounds().x + 6, this.getBounds().y + 4);
        if (!this.isExpanded()) {
            gc.drawLine(this.getBounds().x + 4, this.getBounds().y + 2, this.getBounds().x + 4, this.getBounds().y + 6);
        }
    }

    @Override
    public Point computeSize(GC gc, int wHint, int hHint, Object value) {
        return IS_MAC ? new Point(10, 10) : new Point(9, 9);
    }
}

