/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.util.emf.core.subclasses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.modisco.util.emf.core.internal.subclasses.SubClassesAdapter;

public final class SubClassesUtils {
    private static boolean initialized = false;

    private SubClassesUtils() {
    }

    public static List<EClass> getSubClasses(EClass eClass) {
        SubClassesUtils.initAdapters();
        SubClassesAdapter subClassesAdapter = SubClassesUtils.getAdapterFor(eClass);
        if (subClassesAdapter == null) {
            subClassesAdapter = SubClassesUtils.getAdapterFor(eClass);
        }
        Set<EClass> subclasses = subClassesAdapter.getSubclasses();
        return Collections.unmodifiableList(new ArrayList<EClass>(subclasses));
    }

    private static void initAdapters() {
        if (!initialized) {
            for (Object object : EPackage.Registry.INSTANCE.values()) {
                if (!(object instanceof EPackage)) continue;
                EPackage ePackage = (EPackage)object;
                SubClassesUtils.initAdapters(ePackage);
            }
            initialized = true;
        }
    }

    public static void initAdapters(EPackage ePackage) {
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            SubClassesUtils.initAdapters(eClass);
        }
        for (EPackage subPackage : ePackage.getESubpackages()) {
            SubClassesUtils.initAdapters(subPackage);
        }
    }

    private static void initAdapters(EClass eClass) {
        SubClassesUtils.getAdapterFor(eClass);
        for (EClass superClass : eClass.getESuperTypes()) {
            SubClassesAdapter superAdapter = SubClassesUtils.getAdapterFor(superClass);
            superAdapter.add(eClass);
        }
    }

    private static SubClassesAdapter getAdapterFor(EClass eClass) {
        SubClassesAdapter subClassesAdapter = null;
        for (Adapter adapter : eClass.eAdapters()) {
            if (!(adapter instanceof SubClassesAdapter)) continue;
            subClassesAdapter = (SubClassesAdapter)adapter;
            break;
        }
        if (subClassesAdapter == null) {
            subClassesAdapter = new SubClassesAdapter();
            eClass.eAdapters().add((Object)subClassesAdapter);
        }
        return subClassesAdapter;
    }
}

