/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.plugin.WebPlugin;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.wst.common.componentcore.internal.util.FacetedProjectUtilities;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public abstract class NewWebClassDataModelProvider
extends NewJavaClassDataModelProvider {
    private static final String DEFAULT_SUPERCLASS = "";
    protected List<String> interfaceList;
    protected List<String> jakartaInterfaceList;
    private String classNameCache = "";
    private String existingClassNameCache = "";
    private static boolean useAnnotations = false;

    public boolean isPropertyEnabled(String propertyName) {
        if ("IAnnotationsDataModel.useAnnotations".equals(propertyName)) {
            return !this.getBooleanProperty("NewServletClassDataModel.USE_EXISTING_CLASS") && this.isAnnotationsSupported();
        }
        if ("NewJavaClassDataModel.MODIFIER_PUBLIC".equals(propertyName)) {
            return false;
        }
        if ("NewJavaClassDataModel.MODIFIER_ABSTRACT".equals(propertyName)) {
            return false;
        }
        if ("NewJavaClassDataModel.CONSTRUCTOR".equals(propertyName)) {
            return this.hasSuperClass();
        }
        return super.isPropertyEnabled(propertyName);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("NewServletClassDataModel.REGISTER_IN_WEB_XML");
        propertyNames.add("NewServletClassDataModel.DISPLAY_NAME");
        propertyNames.add("NewServletClassDataModel.DESCRIPTION");
        propertyNames.add("NewServletClassDataModel.USE_EXISTING_CLASS");
        propertyNames.add("IAnnotationsDataModel.useAnnotations");
        propertyNames.add("NewServletClassDataModel.JAVA_EE_VERSION");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("NewServletClassDataModel.DISPLAY_NAME")) {
            return Signature.getSimpleName((String)this.getStringProperty("NewJavaClassDataModel.CLASS_NAME"));
        }
        if (propertyName.equals("IAnnotationsDataModel.useAnnotations")) {
            return NewWebClassDataModelProvider.shouldDefaultAnnotations();
        }
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS")) {
            return DEFAULT_SUPERCLASS;
        }
        if (propertyName.equals("NewServletClassDataModel.USE_EXISTING_CLASS")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("NewJavaClassDataModel.CONSTRUCTOR")) {
            return this.hasSuperClass();
        }
        if (propertyName.equals("NewServletClassDataModel.REGISTER_IN_WEB_XML")) {
            return !this.isAnnotationSupportingWebProject();
        }
        if ("NewServletClassDataModel.JAVA_EE_VERSION".equals(propertyName)) {
            return this.getJavaEEVersion();
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean isAnnotationSupportingWebProject() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
        if (project != null && project.isAccessible()) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                return facetedProject.hasProjectFacet(WebFacetUtils.WEB_FACET) && Float.parseFloat(facetedProject.getInstalledVersion(WebFacetUtils.WEB_FACET).getVersionString()) >= 3.0f || facetedProject.hasProjectFacet(WebFacetUtils.WEBFRAGMENT_FACET) && Float.parseFloat(facetedProject.getInstalledVersion(WebFacetUtils.WEBFRAGMENT_FACET).getVersionString()) >= 3.0f;
            }
            catch (NumberFormatException | CoreException e) {
                WebPlugin.log((Exception)e);
            }
        }
        return false;
    }

    protected boolean projectUsesJakartaPackages() {
        IProject project;
        try {
            String facetVersion = this.getJavaEEVersion();
            if (facetVersion != null && facetVersion.length() > 0) {
                float f = Float.parseFloat(facetVersion);
                return f >= 5.0f;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException e) {
            WTPCommonPlugin.logError((Throwable)e);
        }
        String projectName = this.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (projectName != null && projectName.length() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && project.isAccessible()) {
            try {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                if (javaProject != null && javaProject.exists() && javaProject.findType("jakarta.servlet.GenericServlet") != null) {
                    return true;
                }
            }
            catch (CoreException e) {
                WTPCommonPlugin.logError((CoreException)e);
            }
            try {
                if (FacetedProjectFramework.hasProjectFacet((IProject)project, (String)WebFacetUtils.WEB_FACET.getId(), (String)WebFacetUtils.WEB_50.getVersionString())) {
                    return true;
                }
            }
            catch (CoreException e) {
                WebPlugin.log((Exception)((Object)e));
            }
        }
        return false;
    }

    public String getJavaEEVersion() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
        String id = null;
        id = JavaEEProjectUtilities.isDynamicWebProject((IProject)project) ? WebFacetUtils.WEB_FACET.getId() : WebFacetUtils.WEBFRAGMENT_FACET.getId();
        return FacetedProjectUtilities.getProjectFacetVersion((IProject)project, (String)id).getVersionString();
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IAnnotationsDataModel.useAnnotations")) {
            useAnnotations = (Boolean)propertyValue;
            if (useAnnotations && !this.isAnnotationsSupported()) {
                return true;
            }
            this.model.notifyPropertyChange("IAnnotationsDataModel.useAnnotations", 3);
        }
        if (propertyName.equals("NewJavaClassDataModel.SOURCE_FOLDER")) {
            String sourceFolder = (String)propertyValue;
            int index = sourceFolder.indexOf(File.separator);
            String projectName = sourceFolder;
            if (index == 0) {
                projectName = sourceFolder.substring(1);
            }
            if ((index = projectName.indexOf(File.separator)) != -1) {
                projectName = projectName.substring(0, index);
                this.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", projectName);
            }
        }
        boolean result = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("NewJavaClassDataModel.CLASS_NAME") && !this.model.isPropertySet("NewServletClassDataModel.DISPLAY_NAME")) {
            this.model.notifyPropertyChange("NewServletClassDataModel.DISPLAY_NAME", 2);
        }
        if (propertyName.equals("IArtifactEditOperationDataModelProperties.COMPONENT_NAME")) {
            this.model.notifyPropertyChange("IAnnotationsDataModel.useAnnotations", 3);
        }
        if (this.getBooleanProperty("IAnnotationsDataModel.useAnnotations") && !this.isAnnotationsSupported()) {
            this.setBooleanProperty("IAnnotationsDataModel.useAnnotations", false);
        }
        if (propertyName.equals("NewServletClassDataModel.USE_EXISTING_CLASS")) {
            this.model.notifyPropertyChange("IAnnotationsDataModel.useAnnotations", 3);
            if (((Boolean)propertyValue).booleanValue()) {
                this.classNameCache = this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
                this.setProperty("NewJavaClassDataModel.CLASS_NAME", this.existingClassNameCache);
            } else {
                this.existingClassNameCache = this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
                this.setProperty("NewJavaClassDataModel.CLASS_NAME", this.classNameCache);
            }
        }
        if ("NewJavaClassDataModel.SUPERCLASS".equals(propertyName)) {
            this.model.notifyPropertyChange("NewJavaClassDataModel.CONSTRUCTOR", 3);
            if (!this.hasSuperClass()) {
                this.model.setProperty("NewJavaClassDataModel.CONSTRUCTOR", null);
            }
            this.model.notifyPropertyChange("NewJavaClassDataModel.CONSTRUCTOR", 2);
        }
        return result;
    }

    protected boolean isAnnotationsSupported() {
        if (!this.model.isPropertySet("IArtifactEditOperationDataModelProperties.PROJECT_NAME")) {
            return true;
        }
        if (this.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME").equals(DEFAULT_SUPERCLASS)) {
            return true;
        }
        IProject project = ProjectUtilities.getProject((String)this.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
        String moduleName = this.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME");
        if (project == null || moduleName == null || moduleName.equals(DEFAULT_SUPERCLASS)) {
            return true;
        }
        int j2eeVersion = J2EEVersionUtil.convertVersionStringToInt((String)J2EEProjectUtilities.getJ2EEProjectVersion((IProject)project));
        return j2eeVersion > 12;
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS") && this.getStringProperty(propertyName).equals(DEFAULT_SUPERCLASS)) {
            return WTPCommonPlugin.OK_STATUS;
        }
        if (propertyName.equals("NewJavaClassDataModel.CLASS_NAME") && this.getStringProperty(propertyName).length() != 0 && this.getBooleanProperty("NewServletClassDataModel.USE_EXISTING_CLASS")) {
            return WTPCommonPlugin.OK_STATUS;
        }
        return super.validate(propertyName);
    }

    protected boolean hasDuplicatesInStringArrayList(List input) {
        if (input == null) {
            return false;
        }
        int n = input.size();
        boolean dup = false;
        int i = 0;
        while (i < n) {
            String[] sArray1 = (String[])input.get(i);
            int j = i + 1;
            while (j < n) {
                String[] sArray2 = (String[])input.get(j);
                if (this.isTwoStringArraysEqual(sArray1, sArray2)) {
                    dup = true;
                    break;
                }
                ++j;
            }
            if (dup) break;
            ++i;
        }
        return dup;
    }

    protected boolean isTwoStringArraysEqual(String[] sArray1, String[] sArray2) {
        if (sArray1 == null || sArray2 == null) {
            return false;
        }
        int n1 = sArray1.length;
        int n2 = sArray1.length;
        if (n1 == 0 || n2 == 0) {
            return false;
        }
        if (n1 != n2) {
            return false;
        }
        return sArray1[0].equals(sArray2[0]);
    }

    protected boolean hasSuperClass() {
        String superClass = this.model.getStringProperty("NewJavaClassDataModel.SUPERCLASS");
        return superClass == null ? false : superClass.trim().length() > 0;
    }

    private static Boolean shouldDefaultAnnotations() {
        if (useAnnotations) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

