/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.archive;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.jee.archive.AbstractArchiveAdapter;
import org.eclipse.jst.jee.archive.ArchiveModelLoadException;
import org.eclipse.jst.jee.archive.ArchiveOptions;
import org.eclipse.jst.jee.archive.ArchiveSaveFailureException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveFactory;
import org.eclipse.jst.jee.archive.IArchiveLoadAdapter;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.archive.internal.ArchiveResourceImpl;
import org.eclipse.jst.jee.archive.internal.ZipStreamArchiveSaveAdapterImpl;

public abstract class AbstractArchiveLoadAdapter
extends AbstractArchiveAdapter
implements IArchiveLoadAdapter {
    @Override
    public void close() {
    }

    protected IArchiveResource createDirectory(IPath archiveRelativePath) {
        AbstractArchiveLoadAdapter.verifyRelative(archiveRelativePath);
        ArchiveResourceImpl aFile = null;
        aFile = new ArchiveResourceImpl();
        aFile.setPath(archiveRelativePath);
        aFile.setType(1);
        aFile.setArchive(this.getArchive());
        return aFile;
    }

    protected IArchiveResource createFile(IPath archiveRelativePath) {
        AbstractArchiveLoadAdapter.verifyRelative(archiveRelativePath);
        ArchiveResourceImpl aFile = null;
        aFile = new ArchiveResourceImpl();
        aFile.setPath(archiveRelativePath);
        aFile.setType(0);
        aFile.setArchive(this.getArchive());
        return aFile;
    }

    protected IArchiveResource createManifest(IPath manifestPath) {
        AbstractArchiveLoadAdapter.verifyRelative(manifestPath);
        ArchiveResourceImpl manifest = null;
        manifest = new ArchiveResourceImpl(){

            @Override
            public InputStream getInputStream() throws FileNotFoundException, IOException {
                String manifestContents = "Manifest-Version: 1.0\r\n\r\n";
                return new BufferedInputStream(new ByteArrayInputStream(manifestContents.getBytes()));
            }
        };
        manifest.setPath(manifestPath);
        manifest.setType(0);
        manifest.setArchive(this.getArchive());
        return manifest;
    }

    public static void verifyRelative(IPath archiveRelativePath) {
        if (archiveRelativePath.isAbsolute() && !archiveRelativePath.equals((Object)IArchive.EMPTY_MODEL_PATH)) {
            throw new RuntimeException(archiveRelativePath + " must be relative.");
        }
    }

    @Override
    public InputStream getInputStream(IArchiveResource archiveResource) throws IOException, FileNotFoundException {
        if (archiveResource.getType() == 2) {
            IArchive thisArchive = (IArchive)archiveResource;
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ZipStreamArchiveSaveAdapterImpl saveAdapter = new ZipStreamArchiveSaveAdapterImpl(byteOut);
            ArchiveOptions archiveOptions = new ArchiveOptions();
            archiveOptions.setOption("SAVE_ADAPTER", saveAdapter);
            try {
                IArchiveFactory.INSTANCE.saveArchive(thisArchive, archiveOptions, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ArchiveSaveFailureException e) {
                throw new IOException("Unable to save nested Archive " + archiveResource.getPath() + " nested exception = " + e.getMessage());
            }
            return new ByteArrayInputStream(byteOut.toByteArray());
        }
        return null;
    }

    @Override
    public boolean containsArchiveResource(IPath resourcePath) {
        return false;
    }

    @Override
    public boolean containsModelObject(IPath modelObjectPath) {
        return false;
    }

    @Override
    public IArchiveResource getArchiveResource(IPath resourcePath) throws FileNotFoundException {
        return null;
    }

    @Override
    public List<IArchiveResource> getArchiveResources() {
        return null;
    }

    @Override
    public Object getModelObject(IPath modelObjectPath) throws ArchiveModelLoadException {
        return null;
    }
}

