/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.manipulation.internal.javadoc;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.manipulation.internal.javadoc.JavaDocMessages;
import org.eclipse.text.html.HTMLBuilder;
import org.eclipse.text.readers.SubstitutionReader;

public class CoreJavaDoc2HTMLTextReader
extends SubstitutionReader {
    private List<String> fParameters;
    private String fReturn;
    private List<String> fExceptions;
    private List<String> fAuthors;
    private List<String> fSees;
    private List<String> fSince;
    private List<Pair> fRest;

    public CoreJavaDoc2HTMLTextReader(Reader reader) {
        super(reader);
        this.setSkipWhitespace(false);
    }

    private int getTag(StringBuilder buffer) throws IOException {
        int c = this.nextChar();
        while (c == 46 || c != -1 && Character.isLetter((char)c)) {
            buffer.append((char)c);
            c = this.nextChar();
        }
        return c;
    }

    private int getContent(StringBuilder buffer, char stopChar) throws IOException {
        int c = this.nextChar();
        while (c != -1 && c != stopChar) {
            buffer.append((char)c);
            c = this.nextChar();
        }
        return c;
    }

    private int getContentUntilNextTag(StringBuilder buffer) throws IOException {
        int c = this.nextChar();
        boolean blockStartRead = false;
        while (c != -1) {
            if (c == 64) {
                int index = buffer.length();
                while (--index >= 0 && Character.isWhitespace(buffer.charAt(index))) {
                    switch (buffer.charAt(index)) {
                        case '\n': 
                        case '\r': {
                            return c;
                        }
                    }
                    if (index > 0) continue;
                    return c;
                }
            }
            if (blockStartRead) {
                buffer.append(this.processBlockTag());
                blockStartRead = false;
            } else {
                buffer.append((char)c);
            }
            c = this.nextChar();
            boolean bl = blockStartRead = c == 123;
        }
        return c;
    }

    private String substituteQualification(String qualification) {
        Object result;
        if (!qualification.contains("<a")) {
            result = qualification.replace('#', '.');
        } else {
            int length = qualification.length();
            result = qualification;
            boolean insideTag = false;
            int i = 0;
            while (i < length) {
                char charAt = ((String)result).charAt(i);
                if (charAt == '<' && ((String)result).charAt(i + 1) == 'a') {
                    insideTag = true;
                }
                if (charAt == '>') {
                    insideTag = false;
                }
                if (charAt == '#' && !insideTag) {
                    result = ((String)result).substring(0, i) + "." + ((String)result).substring(i + 1);
                }
                ++i;
            }
        }
        if (((String)result).startsWith(".")) {
            result = ((String)result).substring(1);
        }
        return result;
    }

    protected void printDefinitions(StringBuilder buffer, List<String> list, boolean firstword) {
        Iterator<String> e = list.iterator();
        String startTags = this.getPrintSingleDefinitionStartTags();
        String endTags = this.getPrintSingleDefinitionEndTags();
        while (e.hasNext()) {
            String s = e.next();
            buffer.append(startTags);
            if (!firstword) {
                buffer.append(s);
            } else {
                buffer.append("<b>");
                int i = this.getParamEndOffset(s);
                if (i <= s.length()) {
                    buffer.append(this.convertToHTMLContent(s.substring(0, i)));
                    buffer.append("</b>");
                    buffer.append(s.substring(i));
                } else {
                    buffer.append("</b>");
                }
            }
            buffer.append(endTags);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int getParamEndOffset(String s) {
        block5: {
            i = 0;
            length = s.length();
            while (i < length && Character.isWhitespace(s.charAt(i))) {
                ++i;
            }
            if (i >= length || s.charAt(i) != '<') ** GOTO lbl18
            while (i < length && Character.isWhitespace(s.charAt(i))) {
                ++i;
            }
            while (i < length && Character.isJavaIdentifierPart(s.charAt(i))) {
                ++i;
            }
            while (i < length && s.charAt(i) != '>') {
                ++i;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                ++i;
lbl18:
                // 2 sources

                ** while (i < length && Character.isJavaIdentifierPart((char)s.charAt((int)i)))
            }
        }
        return i;
    }

    protected String getPrintSingleDefinitionStartTags() {
        return "<dd>";
    }

    protected String getPrintSingleDefinitionEndTags() {
        return "</dd>";
    }

    protected void print(StringBuilder buffer, String tag, List<String> elements, boolean firstword) {
        if (!elements.isEmpty()) {
            buffer.append("<dt>");
            buffer.append(tag);
            buffer.append("</dt>");
            this.printDefinitions(buffer, elements, firstword);
        }
    }

    protected void print(StringBuilder buffer, String tag, String content) {
        if (content != null) {
            buffer.append("<dt>");
            buffer.append(tag);
            buffer.append("</dt>");
            buffer.append("<dd>");
            buffer.append(content);
            buffer.append("</dd>");
        }
    }

    protected void printRest(StringBuilder buffer, List<Pair> rest) {
        if (!rest.isEmpty()) {
            for (Pair p : rest) {
                buffer.append("<dt>");
                if (p.fTag != null) {
                    buffer.append(p.fTag);
                }
                buffer.append("</dt>");
                buffer.append("<dd>");
                if (p.fContent != null) {
                    buffer.append(p.fContent);
                }
                buffer.append("</dd>");
            }
        }
    }

    protected String printSimpleTag() {
        return this.printSimpleTag(this.fRest);
    }

    protected String printSimpleTag(List<Pair> rest) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<dl>");
        this.printTagAttributes(buffer);
        this.printRest(buffer, rest);
        buffer.append("</dl>");
        return buffer.toString();
    }

    protected void printTagAttributes(StringBuilder buffer) {
        this.print(buffer, JavaDocMessages.JavaDoc2HTMLTextReader_see_section, this.fSees, false);
        this.print(buffer, JavaDocMessages.JavaDoc2HTMLTextReader_parameters_section, this.fParameters, true);
        this.print(buffer, JavaDocMessages.JavaDoc2HTMLTextReader_returns_section, this.fReturn);
        this.print(buffer, JavaDocMessages.JavaDoc2HTMLTextReader_throws_section, this.fExceptions, false);
        this.print(buffer, JavaDocMessages.JavaDoc2HTMLTextReader_author_section, this.fAuthors, false);
        this.print(buffer, JavaDocMessages.JavaDoc2HTMLTextReader_since_section, this.fSince, false);
    }

    private void handleTag(String tag, String tagContent) {
        block25: {
            tagContent = tagContent.trim();
            if (tag == null) break block25;
            switch (tag) {
                case "@param": {
                    this.fParameters.add(tagContent);
                    return;
                }
                case "@return": {
                    this.fReturn = tagContent;
                    return;
                }
                case "@throws": 
                case "@exception": {
                    this.fExceptions.add(tagContent);
                    return;
                }
                case "@author": {
                    this.fAuthors.add(this.substituteQualification(tagContent));
                    return;
                }
                case "@see": {
                    this.fSees.add(this.substituteQualification(tagContent));
                    return;
                }
                case "@since": {
                    this.fSince.add(this.substituteQualification(tagContent));
                    return;
                }
            }
        }
        if (tagContent != null) {
            this.fRest.add(new Pair(tag, tagContent));
        }
    }

    private String processSimpleTag() throws IOException {
        this.fParameters = new ArrayList<String>();
        this.fExceptions = new ArrayList<String>();
        this.fAuthors = new ArrayList<String>();
        this.fSees = new ArrayList<String>();
        this.fSince = new ArrayList<String>();
        this.fRest = new ArrayList<Pair>();
        StringBuilder buffer = new StringBuilder();
        int c = 64;
        while (c != -1) {
            buffer.setLength(0);
            buffer.append((char)c);
            c = this.getTag(buffer);
            String tag = buffer.toString();
            buffer.setLength(0);
            if (c != -1) {
                c = this.getContentUntilNextTag(buffer);
            }
            this.handleTag(tag, buffer.toString());
        }
        return this.printSimpleTag();
    }

    private String printBlockTag(String tag, String tagContent) {
        block24: {
            if (tag == null) break block24;
            switch (tag) {
                case "@linkplain": 
                case "@link": {
                    char[] contentChars = tagContent.toCharArray();
                    boolean inParentheses = false;
                    int labelStart = 0;
                    int i = 0;
                    while (i < contentChars.length) {
                        char nextChar = contentChars[i];
                        if (i == 0 && Character.isWhitespace(nextChar)) {
                            labelStart = 1;
                        } else if (nextChar == '(') {
                            inParentheses = true;
                        } else if (nextChar == ')') {
                            inParentheses = false;
                        } else if (!inParentheses && Character.isWhitespace(nextChar)) {
                            labelStart = i + 1;
                            break;
                        }
                        ++i;
                    }
                    if ("@link".equals(tag)) {
                        return "<code>" + this.substituteQualification(tagContent.substring(labelStart)) + "</code>";
                    }
                    return this.substituteQualification(tagContent.substring(labelStart));
                }
                case "@literal": {
                    return this.printLiteral(tagContent);
                }
                case "@code": {
                    return "<code>" + this.printLiteral(tagContent) + "</code>";
                }
            }
        }
        return this.substituteQualification(tagContent);
    }

    protected String printLiteral(String tagContent) {
        int contentStart = 0;
        int i = 0;
        while (i < tagContent.length()) {
            if (!Character.isWhitespace(tagContent.charAt(i))) {
                contentStart = i;
                break;
            }
            ++i;
        }
        String toConvert = tagContent.substring(contentStart);
        return this.convertToHTMLContent(toConvert);
    }

    protected String convertToHTMLContent(String toConvert) {
        return HTMLBuilder.convertToHTMLContent((String)toConvert);
    }

    private String processBlockTag() throws IOException {
        int c = this.nextChar();
        if (c != 64) {
            StringBuilder buffer = new StringBuilder();
            buffer.append('{');
            buffer.append((char)c);
            return buffer.toString();
        }
        StringBuilder buffer = new StringBuilder();
        if (c != -1) {
            buffer.setLength(0);
            buffer.append((char)c);
            c = this.getTag(buffer);
            String tag = buffer.toString();
            buffer.setLength(0);
            if (c != -1 && c != 125) {
                buffer.append((char)c);
                c = this.getContent(buffer, '}');
            }
            return this.printBlockTag(tag, buffer.toString());
        }
        return null;
    }

    protected String computeSubstitution(int c) throws IOException {
        if (c == 64 && this.fWasWhiteSpace) {
            return this.processSimpleTag();
        }
        if (c == 123) {
            return this.processBlockTag();
        }
        return null;
    }

    protected record Pair(String fTag, String fContent) {
    }
}

