/**
 * Copyright (c) 2014 RCP Vision (http://www.rcp-vision.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Lorenzo Bettini - Initial contribution and API
 */
package org.eclipse.emf.parsley.dsl.ui.wizard.template;

import java.util.ArrayList;
import org.eclipse.emf.parsley.views.OnSelectionFormView;
import org.eclipse.emf.parsley.views.OnSelectionTableFormView;
import org.eclipse.emf.parsley.views.OnSelectionTableView;
import org.eclipse.emf.parsley.views.OnSelectionTreeFormView;
import org.eclipse.emf.parsley.views.OnSelectionTreeView;
import org.eclipse.emf.parsley.views.SaveableTableFormView;
import org.eclipse.emf.parsley.views.SaveableTableView;
import org.eclipse.emf.parsley.views.SaveableTreeFormView;
import org.eclipse.emf.parsley.views.SaveableTreeView;
import org.eclipse.emf.parsley.views.SaveableTreeWithColumnsView;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/**
 * @author Lorenzo Bettini - Initial contribution and API
 */
@SuppressWarnings("all")
public class TemplateWizardConfigurationsFactory {
  public static class TemplateWizardConfigurationForOnSelectionTableView extends TemplateWizardConfiguration {
    public TemplateWizardConfigurationForOnSelectionTableView(final String label, final CharSequence description, final Class<?> superClass) {
      super(label, description, superClass);
    }

    @Override
    public String getConfiguratorElements(final String projectName) {
      return this.getProjectFilesGenerator().genEClass(this.getPartClassName(projectName)).toString();
    }
  }

  public static class TemplateWizardConfigurationForSaveableView extends TemplateWizardConfiguration {
    public TemplateWizardConfigurationForSaveableView(final String label, final CharSequence description, final Class<?> superClass) {
      super(label, description, superClass);
    }

    @Override
    public String getResourceManager() {
      StringConcatenation _builder = new StringConcatenation();
      _builder.newLine();
      CharSequence _genResourceManager = this.getProjectFilesGenerator().genResourceManager(
        this.getProjectFilesGenerator().genInitializeResource());
      _builder.append(_genResourceManager);
      _builder.newLineIfNotEmpty();
      return _builder.toString();
    }
  }

  public static class TemplateWizardConfigurationForSaveableTableView extends TemplateWizardConfigurationsFactory.TemplateWizardConfigurationForSaveableView {
    public TemplateWizardConfigurationForSaveableTableView(final String label, final CharSequence description, final Class<?> superClass) {
      super(label, description, superClass);
    }

    @Override
    public String getConfiguratorElements(final String projectName) {
      String _xblockexpression = null;
      {
        final String partClassName = this.getPartClassName(projectName);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _genEClass = this.getProjectFilesGenerator().genEClass(partClassName);
        _builder.append(_genEClass);
        _builder.newLineIfNotEmpty();
        CharSequence _genResourceURI = this.getProjectFilesGenerator().genResourceURI(partClassName);
        _builder.append(_genResourceURI);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
      }
      return _xblockexpression;
    }
  }

  public static class TemplateWizardConfigurationForSaveableTreeWithColumnsView extends TemplateWizardConfigurationsFactory.TemplateWizardConfigurationForSaveableView {
    public TemplateWizardConfigurationForSaveableTreeWithColumnsView(final String label, final CharSequence description, final Class<?> superClass) {
      super(label, description, superClass);
    }

    @Override
    public String getConfiguratorElements(final String projectName) {
      String _xblockexpression = null;
      {
        final String partClassName = this.getPartClassName(projectName);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _genFeaturesEClass = this.getProjectFilesGenerator().genFeaturesEClass(partClassName);
        _builder.append(_genFeaturesEClass);
        _builder.newLineIfNotEmpty();
        CharSequence _genResourceURI = this.getProjectFilesGenerator().genResourceURI(partClassName);
        _builder.append(_genResourceURI);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
      }
      return _xblockexpression;
    }
  }

  public static class TemplateWizardConfigurationForSaveableTreeView extends TemplateWizardConfigurationsFactory.TemplateWizardConfigurationForSaveableView {
    public TemplateWizardConfigurationForSaveableTreeView(final String label, final CharSequence description, final Class<?> superClass) {
      super(label, description, superClass);
    }

    @Override
    public String getConfiguratorElements(final String projectName) {
      return this.getProjectFilesGenerator().genResourceURI(this.getPartClassName(projectName)).toString();
    }
  }

  public ArrayList<TemplateWizardConfiguration> createTemplateWizardConfigurations() {
    ArrayList<TemplateWizardConfiguration> _xblockexpression = null;
    {
      final String reactOnSelection = "The view reacts on selection from other components.";
      final String saveableView = "This view reads the content from a resource and can save changes.";
      final String noUserChange = "<p><b>No user change is needed to run the project</b></p>";
      final String theUserMustSpecify = "<p><b>The user must specify:</b></p>";
      final String resourceURI = "<li>the resource URI</li>";
      final String eclassToRepresent = "<li>the EClass of objects to be shown</li>";
      final String eclassForFeatures = "<li>the EClass with the features to be shown</li>";
      CharSequence _createDescription = this.createDescription("tree", reactOnSelection, noUserChange);
      TemplateWizardConfiguration _templateWizardConfiguration = new TemplateWizardConfiguration(
        "On selection Tree View", _createDescription, 
        OnSelectionTreeView.class);
      CharSequence _createDescription_1 = this.createDescription("form", reactOnSelection, noUserChange);
      TemplateWizardConfiguration _templateWizardConfiguration_1 = new TemplateWizardConfiguration(
        "On selection Form View", _createDescription_1, 
        OnSelectionFormView.class);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(theUserMustSpecify);
      _builder.newLineIfNotEmpty();
      _builder.append(eclassToRepresent);
      _builder.newLineIfNotEmpty();
      CharSequence _createDescription_2 = this.createDescription("table and a form", reactOnSelection, _builder);
      TemplateWizardConfigurationsFactory.TemplateWizardConfigurationForOnSelectionTableView _templateWizardConfigurationForOnSelectionTableView = new TemplateWizardConfigurationsFactory.TemplateWizardConfigurationForOnSelectionTableView(
        "On selection Table Form View", _createDescription_2, 
        OnSelectionTableFormView.class);
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append(theUserMustSpecify);
      _builder_1.newLineIfNotEmpty();
      _builder_1.append(eclassToRepresent);
      _builder_1.newLineIfNotEmpty();
      CharSequence _createDescription_3 = this.createDescription("table", reactOnSelection, _builder_1);
      TemplateWizardConfigurationsFactory.TemplateWizardConfigurationForOnSelectionTableView _templateWizardConfigurationForOnSelectionTableView_1 = new TemplateWizardConfigurationsFactory.TemplateWizardConfigurationForOnSelectionTableView(
        "On selection Table View", _createDescription_3, 
        OnSelectionTableView.class);
      CharSequence _createDescription_4 = this.createDescription("tree and a form", reactOnSelection, noUserChange);
      TemplateWizardConfiguration _templateWizardConfiguration_2 = new TemplateWizardConfiguration(
        "On selection Tree Form View", _createDescription_4, 
        OnSelectionTreeFormView.class);
      StringConcatenation _builder_2 = new StringConcatenation();
      _builder_2.append(theUserMustSpecify);
      _builder_2.newLineIfNotEmpty();
      _builder_2.append(resourceURI);
      _builder_2.newLineIfNotEmpty();
      _builder_2.append(eclassToRepresent);
      _builder_2.newLineIfNotEmpty();
      CharSequence _createDescription_5 = this.createDescription("table and a form", saveableView, _builder_2);
      TemplateWizardConfigurationsFactory.TemplateWizardConfigurationForSaveableTableView _templateWizardConfigurationForSaveableTableView = new TemplateWizardConfigurationsFactory.TemplateWizardConfigurationForSaveableTableView(
        "Saveable Table Form View", _createDescription_5, 
        SaveableTableFormView.class);
      StringConcatenation _builder_3 = new StringConcatenation();
      _builder_3.append(theUserMustSpecify);
      _builder_3.newLineIfNotEmpty();
      _builder_3.append(resourceURI);
      _builder_3.newLineIfNotEmpty();
      _builder_3.append(eclassToRepresent);
      _builder_3.newLineIfNotEmpty();
      CharSequence _createDescription_6 = this.createDescription("table", saveableView, _builder_3);
      TemplateWizardConfigurationsFactory.TemplateWizardConfigurationForSaveableTableView _templateWizardConfigurationForSaveableTableView_1 = new TemplateWizardConfigurationsFactory.TemplateWizardConfigurationForSaveableTableView(
        "Saveable Table View", _createDescription_6, 
        SaveableTableView.class);
      StringConcatenation _builder_4 = new StringConcatenation();
      _builder_4.append(theUserMustSpecify);
      _builder_4.newLineIfNotEmpty();
      _builder_4.append(resourceURI);
      _builder_4.newLineIfNotEmpty();
      CharSequence _createDescription_7 = this.createDescription("tree and a form", saveableView, _builder_4);
      TemplateWizardConfigurationsFactory.TemplateWizardConfigurationForSaveableTreeView _templateWizardConfigurationForSaveableTreeView = new TemplateWizardConfigurationsFactory.TemplateWizardConfigurationForSaveableTreeView(
        "Saveable Tree Form View", _createDescription_7, 
        SaveableTreeFormView.class);
      StringConcatenation _builder_5 = new StringConcatenation();
      _builder_5.append(theUserMustSpecify);
      _builder_5.newLineIfNotEmpty();
      _builder_5.append(resourceURI);
      _builder_5.newLineIfNotEmpty();
      CharSequence _createDescription_8 = this.createDescription("tree", saveableView, _builder_5);
      TemplateWizardConfigurationsFactory.TemplateWizardConfigurationForSaveableTreeView _templateWizardConfigurationForSaveableTreeView_1 = new TemplateWizardConfigurationsFactory.TemplateWizardConfigurationForSaveableTreeView(
        "Saveable Tree View", _createDescription_8, 
        SaveableTreeView.class);
      StringConcatenation _builder_6 = new StringConcatenation();
      _builder_6.append(theUserMustSpecify);
      _builder_6.newLineIfNotEmpty();
      _builder_6.append(resourceURI);
      _builder_6.newLineIfNotEmpty();
      _builder_6.append(eclassForFeatures);
      _builder_6.newLineIfNotEmpty();
      CharSequence _createDescription_9 = this.createDescription("tree with columns", saveableView, _builder_6);
      TemplateWizardConfigurationsFactory.TemplateWizardConfigurationForSaveableTreeWithColumnsView _templateWizardConfigurationForSaveableTreeWithColumnsView = new TemplateWizardConfigurationsFactory.TemplateWizardConfigurationForSaveableTreeWithColumnsView(
        "Saveable Tree With Columns View", _createDescription_9, 
        SaveableTreeWithColumnsView.class);
      _xblockexpression = CollectionLiterals.<TemplateWizardConfiguration>newArrayList(_templateWizardConfiguration, _templateWizardConfiguration_1, _templateWizardConfigurationForOnSelectionTableView, _templateWizardConfigurationForOnSelectionTableView_1, _templateWizardConfiguration_2, _templateWizardConfigurationForSaveableTableView, _templateWizardConfigurationForSaveableTableView_1, _templateWizardConfigurationForSaveableTreeView, _templateWizardConfigurationForSaveableTreeView_1, _templateWizardConfigurationForSaveableTreeWithColumnsView);
    }
    return _xblockexpression;
  }

  private CharSequence createDescription(final CharSequence component, final CharSequence componentDescription, final CharSequence userMustSpecify) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<p>This wizard creates a plug-in project that contains a view with a <b>");
    _builder.append(component);
    _builder.append("</b>.</p>");
    _builder.newLineIfNotEmpty();
    _builder.append("<p>");
    _builder.append(componentDescription);
    _builder.append("</p>");
    _builder.newLineIfNotEmpty();
    _builder.append(userMustSpecify);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
