/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ProblemsLabelDecorator;
import org.eclipse.dltk.ui.viewsupport.IProblemChangedListener;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class ScriptEditorErrorTickUpdater
implements IProblemChangedListener {
    private ScriptEditor fScriptEditor;
    private ScriptUILabelProvider fLabelProvider;

    public ScriptEditorErrorTickUpdater(ScriptEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fScriptEditor = editor;
        this.fLabelProvider = DLTKUILanguageManager.createLabelProvider(editor.getLanguageToolkit().getNatureId());
        this.fLabelProvider.setTextFlags(0L);
        this.fLabelProvider.setImageFlags(2);
        this.fLabelProvider.addLabelDecorator(new ProblemsLabelDecorator(null));
        DLTKUIPlugin.getDefault().getProblemMarkerManager().addListener(this);
    }

    @Override
    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        IModelElement jelement;
        if (!isMarkerChange) {
            return;
        }
        IEditorInput input = this.fScriptEditor.getEditorInput();
        if (input != null && (jelement = (IModelElement)input.getAdapter(IModelElement.class)) != null) {
            IResource resource = jelement.getResource();
            int i = 0;
            while (i < changedResources.length) {
                if (changedResources[i].equals((Object)resource)) {
                    this.updateEditorImage(jelement);
                }
                ++i;
            }
        }
    }

    public void updateEditorImage(IModelElement jelement) {
        Image titleImage = this.fScriptEditor.getTitleImage();
        if (titleImage == null) {
            return;
        }
        Image newImage = jelement instanceof ISourceModule && !jelement.getScriptProject().isOnBuildpath(jelement) ? this.fLabelProvider.getImage(jelement.getResource()) : this.fLabelProvider.getImage(jelement);
        if (titleImage != newImage) {
            this.postImageChange(newImage);
        }
    }

    private void postImageChange(Image newImage) {
        Shell shell = this.fScriptEditor.getEditorSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(() -> this.fScriptEditor.updatedTitleImage(newImage));
        }
    }

    public void dispose() {
        this.fLabelProvider.dispose();
        DLTKUIPlugin.getDefault().getProblemMarkerManager().removeListener(this);
    }
}

