/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.console.profile.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.datatools.connectivity.console.profile.nls.Messages;

public class SystemIOUtil {
    private static final String USER_CONFIRM_INPUT_CHAR = Messages.ioutil_confirmUserInputChar;
    private static final String CONFIRM_PROMPT = Messages.bind((String)" [''{0}'' {1}]", (Object)USER_CONFIRM_INPUT_CHAR, (Object)Messages.ioutil_confirmPromptInstruction);
    private static final String INPUT_PROMPT_DELIMITER = ": ";
    static final String EMPTY_STRING = "";
    private BufferedReader m_stdin;

    SystemIOUtil() {
    }

    String promptForInput(String promptMsg) {
        this.printInputPrompt(String.valueOf(promptMsg) + INPUT_PROMPT_DELIMITER);
        return this.readLn();
    }

    boolean promptYesNoResponse(String promptMsg) {
        String response = this.promptForInput(String.valueOf(promptMsg) + CONFIRM_PROMPT);
        return response != null && response.equalsIgnoreCase(USER_CONFIRM_INPUT_CHAR);
    }

    String promptForUpdateValue() {
        String newValue = null;
        if (this.promptYesNoResponse(Messages.ioutil_askUpdateValue) && (newValue = this.promptForInput(Messages.ioutil_newValuePrompt)) == null) {
            newValue = EMPTY_STRING;
        }
        return newValue;
    }

    void printException(String errorMsg, Exception ex) {
        String exceptionMsg;
        if (errorMsg != null) {
            this.println(errorMsg);
        }
        if ((exceptionMsg = ex.getLocalizedMessage()) != null) {
            this.println(Messages.bind((String)Messages.ioutil_exceptionCause, (Object)exceptionMsg));
        }
        if (this.promptYesNoResponse(Messages.ioutil_askReviewStack)) {
            ex.printStackTrace();
        }
    }

    void printNewLine(String message) {
        this.printNewLine();
        this.println(message);
    }

    void printNewLine() {
        System.out.println();
    }

    void println(String message) {
        System.out.println(message);
    }

    void printInputPrompt(String message) {
        System.out.print(message);
        System.out.flush();
    }

    String readLn() {
        if (this.m_stdin == null) {
            this.m_stdin = new BufferedReader(new InputStreamReader(System.in));
        }
        String message = null;
        try {
            message = this.m_stdin.readLine();
        }
        catch (IOException ex) {
            this.printException(Messages.ioutil_errorSystemInput, ex);
        }
        return message;
    }

    void close() {
        System.out.flush();
        if (this.m_stdin != null) {
            try {
                this.m_stdin.close();
                this.m_stdin = null;
            }
            catch (IOException iOException) {}
        }
    }
}

