/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.unittest.internal.launcher;

import org.eclipse.cdt.launch.ui.CLaunchConfigurationTab;
import org.eclipse.cdt.testsrunner.internal.TestsRunnerPlugin;
import org.eclipse.cdt.testsrunner.internal.launcher.TestsRunnerProviderInfo;
import org.eclipse.cdt.testsrunner.launcher.ITestsRunnerProviderInfo;
import org.eclipse.cdt.unittest.internal.launcher.LauncherMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CTestingTab
extends CLaunchConfigurationTab {
    private static final String TAB_ID = "org.eclipse.cdt.testsrunner.testingTab";
    private static final String TESTING_PROCESS_FACTORY_ID = "org.eclipse.cdt.unittest.testsrunner.TestingProcessFactory";
    private Combo testsRunnerProviderCombo;
    private Label testsRunnerProviderDescriptionLabel;

    public void createControl(Composite parent) {
        Composite pageComposite = new Composite(parent, 0);
        GridLayout pageCompositeLayout = new GridLayout(2, false);
        pageCompositeLayout.horizontalSpacing = 40;
        pageComposite.setLayout((Layout)pageCompositeLayout);
        new Label(pageComposite, 0).setText(LauncherMessages.CTestingTab_tests_runner_label);
        this.testsRunnerProviderCombo = new Combo(pageComposite, 12);
        this.testsRunnerProviderCombo.add(LauncherMessages.CTestingTab_tests_runner_is_not_set);
        this.testsRunnerProviderCombo.setData("0", null);
        TestsRunnerProviderInfo[] testsRunnerProviderInfoArray = TestsRunnerPlugin.getDefault().getTestsRunnerProvidersManager().getTestsRunnersProviderInfo();
        int n = testsRunnerProviderInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            TestsRunnerProviderInfo testsRunnerProviderInfo = testsRunnerProviderInfoArray[n2];
            this.testsRunnerProviderCombo.setData(Integer.toString(this.testsRunnerProviderCombo.getItemCount()), (Object)testsRunnerProviderInfo);
            this.testsRunnerProviderCombo.add(testsRunnerProviderInfo.getName());
            ++n2;
        }
        this.testsRunnerProviderCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CTestingTab.this.testsRunnerProviderDescriptionLabel.setText(CTestingTab.this.getCurrentTestsRunnerDescription());
                CTestingTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.testsRunnerProviderDescriptionLabel = new Label(pageComposite, 64);
        GridData testsRunnerProviderLabelGD = new GridData(1808);
        testsRunnerProviderLabelGD.horizontalSpan = 2;
        testsRunnerProviderLabelGD.horizontalAlignment = 4;
        this.testsRunnerProviderDescriptionLabel.setLayoutData((Object)testsRunnerProviderLabelGD);
        GridData pageCompositeGD = new GridData(1808);
        pageCompositeGD.horizontalAlignment = 4;
        pageCompositeGD.grabExcessHorizontalSpace = true;
        pageComposite.setLayoutData((Object)pageCompositeGD);
        this.setControl((Control)pageComposite);
    }

    private ITestsRunnerProviderInfo getCurrentTestsRunnerProviderInfo() {
        return this.getTestsRunnerProviderInfo(this.testsRunnerProviderCombo.getSelectionIndex());
    }

    private ITestsRunnerProviderInfo getTestsRunnerProviderInfo(int comboIndex) {
        return (ITestsRunnerProviderInfo)this.testsRunnerProviderCombo.getData(Integer.toString(comboIndex));
    }

    private String getCurrentTestsRunnerDescription() {
        ITestsRunnerProviderInfo testsRunnerProvider = this.getCurrentTestsRunnerProviderInfo();
        if (testsRunnerProvider != null) {
            return testsRunnerProvider.getDescription();
        }
        return LauncherMessages.CTestingTab_no_tests_runner_label;
    }

    public boolean isValid(ILaunchConfiguration config) {
        return this.getCurrentTestsRunnerProviderInfo() != null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.cdt.testsrunner.launch.TESTS_RUNNER", null);
        config.setAttribute("process_factory_id", TESTING_PROCESS_FACTORY_ID);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String testsRunnerId = configuration.getAttribute("org.eclipse.cdt.testsrunner.launch.TESTS_RUNNER", null);
            int comboIndex = 0;
            int i = 1;
            while (i < this.testsRunnerProviderCombo.getItemCount()) {
                if (this.getTestsRunnerProviderInfo(i).getId().equals(testsRunnerId)) {
                    comboIndex = i;
                    break;
                }
                ++i;
            }
            this.testsRunnerProviderCombo.select(comboIndex);
        }
        catch (CoreException e) {
            TestsRunnerPlugin.log((Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        ITestsRunnerProviderInfo testsRunnerProvider = this.getCurrentTestsRunnerProviderInfo();
        String testsRunnerProviderId = testsRunnerProvider != null ? testsRunnerProvider.getId() : null;
        configuration.setAttribute("org.eclipse.cdt.testsrunner.launch.TESTS_RUNNER", testsRunnerProviderId);
        configuration.setAttribute("process_factory_id", TESTING_PROCESS_FACTORY_ID);
    }

    public String getId() {
        return TAB_ID;
    }

    public String getName() {
        return LauncherMessages.CTestingTab_tab_name;
    }

    public String getErrorMessage() {
        String m = super.getErrorMessage();
        if (m == null && this.getCurrentTestsRunnerProviderInfo() == null) {
            return LauncherMessages.CTestingTab_no_tests_runner_error;
        }
        return m;
    }

    public Image getImage() {
        return TestsRunnerPlugin.createAutoImage((String)"obj16/test_notrun.gif");
    }
}

