/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text.makefile;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class FunctionReferenceRule
extends WordRule {
    private StringBuilder fBuffer = new StringBuilder();
    private String startSeq;
    private String endSeq;
    private static final String[] functions = new String[]{"subst", "patsubst", "strip", "findstring", "filter", "filter-out", "sort", "word", "words", "wordlist", "firstword", "lastword", "dir", "notdir", "suffix", "basename", "addsuffix", "addprefix", "join", "wildcard", "realpath", "abspath", "if", "or", "and", "foreach", "call", "value", "eval", "origin", "flavor", "shell", "error", "warning", "info"};

    public FunctionReferenceRule(IToken token, String startSeq, String endSeq) {
        super((IWordDetector)new TagDetector(endSeq));
        this.startSeq = startSeq;
        this.endSeq = endSeq;
        String[] stringArray = functions;
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            this.addWord(startSeq + f, token);
            this.addWord("$" + startSeq + f, token);
            ++n2;
        }
        this.addWord(endSeq, token);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        TagDetector tagDetector = (TagDetector)this.fDetector;
        int c = scanner.read();
        if (c == tagDetector.closedBracket) {
            if (tagDetector.bracketNesting > 0) {
                --tagDetector.bracketNesting;
                return (IToken)this.fWords.get(this.endSeq);
            }
            return this.fDefaultToken;
        }
        if (c != -1 && this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
            scanner.unread();
            String buffer = this.fBuffer.toString();
            IToken token = (IToken)this.fWords.get(buffer);
            if (token != null) {
                if (buffer.equals(this.startSeq + "call") || buffer.equals("$" + this.startSeq + "call")) {
                    if ((char)scanner.read() == ' ') {
                        while (((TagDetector)this.fDetector).isBracket((char)(c = scanner.read())) || this.fDetector.isWordPart((char)c)) {
                        }
                    }
                    scanner.unread();
                }
                ++((TagDetector)this.fDetector).bracketNesting;
                return token;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }

    private static class TagDetector
    implements IWordDetector {
        private char openBracket;
        private char closedBracket;
        private boolean isClosedBracket = false;
        private int bracketNesting = 0;

        public TagDetector(String endSeq) {
            if (endSeq.length() > 0 && endSeq.charAt(0) == '}') {
                this.openBracket = (char)123;
                this.closedBracket = (char)125;
            } else {
                this.openBracket = (char)40;
                this.closedBracket = (char)41;
            }
        }

        public boolean isWordStart(char c) {
            boolean bl = this.isClosedBracket = c == this.closedBracket;
            return this.isClosedBracket || c == '$';
        }

        public boolean isWordPart(char c) {
            return !this.isClosedBracket && (c == '$' || c == this.openBracket || Character.isJavaIdentifierPart(c) || c == '-');
        }

        public boolean isBracket(char c) {
            return "(){}".contains(Character.toString(c));
        }
    }
}

