/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.animation.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.xwt.animation.RepeatBehavior;
import org.eclipse.xwt.animation.Timeline;
import org.eclipse.xwt.animation.internal.ITimeline;
import org.eclipse.xwt.animation.internal.ITimelineGroup;
import org.pushingpixels.trident.TimelineScenario;
import org.pushingpixels.trident.callback.TimelineScenarioCallback;

public class ScenarioTimeline
extends TimelineScenario
implements ITimelineGroup {
    protected TimelineScenario tridentTimelineScenario;
    protected Timeline xwtTimeline;
    protected Object target;
    protected boolean done = false;
    private Collection<ITimeline> actors = new ArrayList<ITimeline>();
    private Collection<Runnable> stateChangedRunnables = new ArrayList<Runnable>();

    public ScenarioTimeline(Timeline xwtTimeline, TimelineScenario tridentTimelineScenario, Object target) {
        this.xwtTimeline = xwtTimeline;
        this.target = target;
        this.tridentTimelineScenario = tridentTimelineScenario;
        this.tridentTimelineScenario.addCallback(new TimelineScenarioCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTimelineScenarioDone() {
                ScenarioTimeline scenarioTimeline = ScenarioTimeline.this;
                synchronized (scenarioTimeline) {
                    ScenarioTimeline.this.done = true;
                    for (Runnable runnable : ScenarioTimeline.this.getStateChangedRunnables()) {
                        runnable.run();
                    }
                }
            }
        });
    }

    public Collection<Runnable> getStateChangedRunnables() {
        return this.stateChangedRunnables;
    }

    @Override
    public void addStateChangedRunnable(Runnable stateChangedRunnable) {
        if (stateChangedRunnable == null) {
            return;
        }
        if (!this.stateChangedRunnables.contains(stateChangedRunnable)) {
            this.stateChangedRunnables.add(stateChangedRunnable);
        }
    }

    @Override
    public void removeStateChangedRunnable(Runnable stateChangedRunnable) {
        this.stateChangedRunnables.remove(stateChangedRunnable);
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    public void play() {
        for (ITimeline timeline : this.actors) {
            timeline.resetDoneFlag();
            this.tridentTimelineScenario.addScenarioActor((TimelineScenario.TimelineScenarioActor)timeline);
        }
        this.tridentTimelineScenario.play();
    }

    public void playLoop(RepeatBehavior behavior) {
        this.tridentTimelineScenario.playLoop();
    }

    @Override
    public void end() {
        if (this.tridentTimelineScenario == null) {
            return;
        }
        this.tridentTimelineScenario.cancel();
        for (ITimeline timeline : this.actors) {
            timeline.end();
        }
    }

    @Override
    public void cancel() {
        if (this.tridentTimelineScenario == null) {
            return;
        }
        this.tridentTimelineScenario.cancel();
        for (ITimeline timeline : this.actors) {
            timeline.cancel();
        }
    }

    @Override
    public void abort() {
        if (this.tridentTimelineScenario == null) {
            return;
        }
        this.tridentTimelineScenario.cancel();
        for (ITimeline timeline : this.actors) {
            timeline.abort();
        }
    }

    @Override
    public void pause() {
        if (this.tridentTimelineScenario == null) {
            return;
        }
        this.tridentTimelineScenario.suspend();
    }

    @Override
    public void resume() {
        if (this.tridentTimelineScenario == null) {
            return;
        }
        this.tridentTimelineScenario.resume();
    }

    @Override
    public void playReverse() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        ScenarioTimeline scenarioTimeline = this;
        synchronized (scenarioTimeline) {
            return this.done;
        }
    }

    public void resetDoneFlag() {
        this.done = false;
    }

    public boolean supportsReplay() {
        return false;
    }

    @Override
    public void addTimeline(ITimeline timeline) {
        this.actors.add(timeline);
    }
}

