/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.forms;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.IXWTLoader;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.callback.ICreatedCallback;
import org.eclipse.xwt.forms.ToolKitUtil;
import org.eclipse.xwt.forms.metaclass.ButtonMetaclass;
import org.eclipse.xwt.forms.metaclass.CompositeMetaclass;
import org.eclipse.xwt.forms.metaclass.ExpandableCompositeMetaclass;
import org.eclipse.xwt.forms.metaclass.FormMetaclass;
import org.eclipse.xwt.forms.metaclass.FormTextMetaclass;
import org.eclipse.xwt.forms.metaclass.HyperlinkMetaclass;
import org.eclipse.xwt.forms.metaclass.ImageHyperlinkMetaclass;
import org.eclipse.xwt.forms.metaclass.LabelMetaclass;
import org.eclipse.xwt.forms.metaclass.ScrolledFormMetaclass;
import org.eclipse.xwt.forms.metaclass.ScrolledPageBookMetaclass;
import org.eclipse.xwt.forms.metaclass.SectionMetaclass;
import org.eclipse.xwt.forms.metaclass.TableMetaclass;
import org.eclipse.xwt.forms.metaclass.TextMetaclass;
import org.eclipse.xwt.internal.utils.UserData;
import org.eclipse.xwt.metadata.IMetaclass;

public class XWTForms {
    private static Object FormsProfile;
    private static ICreatedCallback CreatedAction;

    static {
        CreatedAction = new ICreatedCallback(){

            public void onCreated(Object sender) {
                Widget widget = UserData.getWidget((Object)sender);
                if (widget instanceof Control) {
                    ToolKitUtil.adapt((Control)widget);
                }
            }
        };
    }

    private static boolean applyFormsProfile() {
        if (FormsProfile == null) {
            FormsProfile = XWT.createUIProfile();
            XWT.registerMetaclass((IMetaclass)new FormMetaclass());
            XWT.registerMetaclass((IMetaclass)new ButtonMetaclass());
            XWT.registerMetaclass((IMetaclass)new LabelMetaclass());
            XWT.registerMetaclass((IMetaclass)new TextMetaclass());
            XWT.registerMetaclass((IMetaclass)new TableMetaclass());
            XWT.registerMetaclass((IMetaclass)new CompositeMetaclass());
            XWT.registerMetaclass((IMetaclass)new FormTextMetaclass());
            XWT.registerMetaclass((IMetaclass)new HyperlinkMetaclass());
            XWT.registerMetaclass((IMetaclass)new ImageHyperlinkMetaclass());
            XWT.registerMetaclass((IMetaclass)new ExpandableCompositeMetaclass());
            XWT.registerMetaclass((IMetaclass)new SectionMetaclass());
            XWT.registerMetaclass((IMetaclass)new ScrolledPageBookMetaclass());
            XWT.registerMetaclass((IMetaclass)new ScrolledFormMetaclass());
        }
        return XWT.applyProfile((Object)FormsProfile);
    }

    public static synchronized Object load(URL file) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        return XWTForms.loadWithOptions(file, options);
    }

    public static synchronized Object load(URL file, Object dataContext) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.DataContext", dataContext);
        return XWTForms.loadWithOptions(file, options);
    }

    public static synchronized Object load(Composite parent, URL file) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.Container", parent);
        return XWTForms.loadWithOptions(file, options);
    }

    public static synchronized Object load(Composite parent, URL file, Object dataContext) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.Container", parent);
        options.put("XWT.DataContext", dataContext);
        return XWTForms.loadWithOptions(file, options);
    }

    public static synchronized void open(URL url) throws Exception {
        XWTForms.open(url, new HashMap<String, Object>());
    }

    public static synchronized Object load(Composite parent, InputStream stream, URL file, Object dataContext) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.Container", parent);
        options.put("XWT.DataContext", dataContext);
        return XWTForms.loadWithOptions(stream, file, options);
    }

    public static synchronized void open(URL url, Object dataContext) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.DataContext", dataContext);
        XWTForms.open(url, options);
    }

    public static synchronized void open(Class<?> type, Object dataContext) throws Exception {
        XWTForms.open(type.getResource(String.valueOf(type.getSimpleName()) + ".xwt"), dataContext);
    }

    public static synchronized void open(URL url, Map<String, Object> options) throws Exception {
        boolean applied = XWTForms.applyFormsProfile();
        try {
            options.put(IXWTLoader.CREATED_CALLBACK, CreatedAction);
            XWT.open((URL)url, options);
        }
        finally {
            if (applied) {
                XWT.restoreProfile();
            }
        }
    }

    public static synchronized Object loadWithOptions(URL url, Map<String, Object> options) throws Exception {
        boolean applied = XWTForms.applyFormsProfile();
        try {
            options.put(IXWTLoader.CREATED_CALLBACK, CreatedAction);
            Object object = XWT.loadWithOptions((URL)url, options);
            return object;
        }
        finally {
            if (applied) {
                XWT.restoreProfile();
            }
        }
    }

    public static synchronized Object load(InputStream stream, URL url) throws Exception {
        return XWTForms.loadWithOptions(stream, url, new HashMap<String, Object>());
    }

    public static synchronized Object loadWithOptions(InputStream stream, URL url, Map<String, Object> options) throws Exception {
        boolean applied = XWTForms.applyFormsProfile();
        try {
            options.put(IXWTLoader.CREATED_CALLBACK, CreatedAction);
            Object object = XWT.loadWithOptions((InputStream)stream, (URL)url, options);
            return object;
        }
        finally {
            if (applied) {
                XWT.restoreProfile();
            }
        }
    }
}

