/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.download;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.json.internal.JSONPlugin;
import org.eclipse.wst.json.core.JSONCorePlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class HttpClientProvider {
    private static final String JSON_DOWNLOAD_FOLDER = ".jsonDownloadFolder";
    public static final String PROTOCOL_FILE = "file";
    public static final String PROTOCOL_PLATFORM = "platform";

    public static File getFile(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        if (PROTOCOL_FILE.equals(url.getProtocol()) || PROTOCOL_PLATFORM.equalsIgnoreCase(url.getProtocol())) {
            File file;
            try {
                file = new File(new URI(url.toExternalForm()));
            }
            catch (Exception exception) {
                file = new File(url.getFile());
            }
            if (!file.exists()) {
                return null;
            }
            return file;
        }
        File file = HttpClientProvider.getCachedFile(url);
        long urlLastModified = HttpClientProvider.getLastModified(url);
        if (file.exists()) {
            long lastModified = file.lastModified();
            if (urlLastModified > lastModified && (file = HttpClientProvider.download(file, url)) != null) {
                file.setLastModified(urlLastModified);
            }
        } else if ((file = HttpClientProvider.download(file, url)) != null && urlLastModified > -1L) {
            file.setLastModified(urlLastModified);
        }
        return file;
    }

    /*
     * Loose catch block
     */
    private static File download(File file, URL url) {
        File file2;
        OutputStream out;
        CloseableHttpResponse response;
        CloseableHttpClient httpclient;
        block27: {
            httpclient = HttpClients.createDefault();
            response = null;
            out = null;
            file.getParentFile().mkdirs();
            HttpHost target = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
            RequestConfig.Builder builder = RequestConfig.custom();
            HttpHost proxy = HttpClientProvider.getProxy(target);
            if (proxy != null) {
                builder = builder.setProxy(proxy);
            }
            RequestConfig config = builder.build();
            HttpGet request = new HttpGet(url.toURI());
            request.setConfig(config);
            response = httpclient.execute(target, (HttpRequest)request);
            InputStream in = response.getEntity().getContent();
            out = new BufferedOutputStream(new FileOutputStream(file));
            HttpClientProvider.copy(in, out);
            file2 = file;
            if (out == null) break block27;
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {}
        }
        try {
            httpclient.close();
        }
        catch (IOException iOException) {}
        return file2;
        catch (Exception e) {
            block28: {
                try {
                    HttpClientProvider.logWarning(e);
                    if (out == null) break block28;
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (IOException iOException) {}
                    }
                    try {
                        httpclient.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            try {
                httpclient.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        int n = 0;
        while ((n = in.read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
    }

    /*
     * Loose catch block
     */
    private static long getLastModified(URL url) {
        CloseableHttpResponse response;
        CloseableHttpClient httpclient;
        block23: {
            long l;
            block24: {
                httpclient = HttpClients.createDefault();
                response = null;
                HttpHost target = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
                RequestConfig.Builder builder = RequestConfig.custom();
                HttpHost proxy = HttpClientProvider.getProxy(target);
                if (proxy != null) {
                    builder = builder.setProxy(proxy);
                }
                RequestConfig config = builder.build();
                HttpHead request = new HttpHead(url.toURI());
                request.setConfig(config);
                response = httpclient.execute(target, (HttpRequest)request);
                Header[] s = response.getHeaders("last-modified");
                if (s == null || s.length <= 0) break block23;
                String lastModified = s[0].getValue();
                l = new Date(lastModified).getTime();
                if (response == null) break block24;
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            try {
                httpclient.close();
            }
            catch (IOException iOException) {}
            return l;
            catch (Exception e) {
                block25: {
                    try {
                        HttpClientProvider.logWarning(e);
                        if (response == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (IOException iOException) {}
                        }
                        try {
                            httpclient.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        response.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    httpclient.close();
                }
                catch (IOException iOException) {}
                return -1L;
            }
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {}
        }
        try {
            httpclient.close();
        }
        catch (IOException iOException) {}
        return -1L;
    }

    private static HttpHost getProxy(HttpHost target) {
        IProxyService proxyService = HttpClientProvider.getProxyService();
        IProxyData[] select = null;
        try {
            select = proxyService.select(new URI(target.toURI()));
        }
        catch (URISyntaxException e) {
            HttpClientProvider.logWarning(e);
            return null;
        }
        String type = target.getSchemeName();
        IProxyData[] iProxyDataArray = select;
        int n = select.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData proxyData = iProxyDataArray[n2];
            if (proxyData.getType().equals(type)) {
                return new HttpHost(proxyData.getHost(), proxyData.getPort());
            }
            ++n2;
        }
        return null;
    }

    private static void logWarning(Exception e) {
        Status status = new Status(2, "org.eclipse.wst.json.core", e.getMessage(), (Throwable)e);
        JSONCorePlugin.getDefault().getLog().log((IStatus)status);
    }

    public static IProxyService getProxyService() {
        BundleContext bc = JSONPlugin.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = bc.getServiceReference(IProxyService.class.getName());
        IProxyService service = (IProxyService)bc.getService(serviceReference);
        return service;
    }

    private static File getCachedFile(URL url) {
        IPath stateLocation = JSONCorePlugin.getDefault().getStateLocation();
        IPath downloadFolder = stateLocation.append(JSON_DOWNLOAD_FOLDER);
        String urlPath = url.getPath();
        IPath filePath = downloadFolder.append(urlPath);
        File file = filePath.toFile();
        return file;
    }
}

