/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import java.util.LinkedList;
import org.eclipse.wst.css.core.internal.document.CSSAttrImpl;
import org.eclipse.wst.css.core.internal.document.CSSCharsetRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSFontFaceRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSImportRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSMediaRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSPageRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSPrimitiveContainer;
import org.eclipse.wst.css.core.internal.document.CSSPrimitiveValueImpl;
import org.eclipse.wst.css.core.internal.document.CSSRegionContainer;
import org.eclipse.wst.css.core.internal.document.CSSStyleDeclItemImpl;
import org.eclipse.wst.css.core.internal.document.CSSStyleDeclarationImpl;
import org.eclipse.wst.css.core.internal.document.CSSStyleRuleImpl;
import org.eclipse.wst.css.core.internal.document.CounterImpl;
import org.eclipse.wst.css.core.internal.document.MediaListImpl;
import org.eclipse.wst.css.core.internal.document.RGBColorImpl;
import org.eclipse.wst.css.core.internal.document.RectImpl;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.util.AbstractCssTraverser;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.w3c.dom.DOMException;

class CSSModelUpdateContext {
    ICSSNode fLastNode = null;
    ICSSNode fDeletionTargetParent = null;
    ICSSNode fDeletionTarget = null;
    LinkedList fNodeList = null;
    private short fUpdateMode = 0;
    static final short UPDATE_IDLE = 0;
    static final short UPDATE_INSERT_FNCONTAINER = 1;
    static final short UPDATE_INSERT_RCONTAINER = 2;
    static final short UPDATE_REMOVE_FNCONTAINER = 3;
    static final short UPDATE_REMOVE_RCONTAINER = 4;
    static final short UPDATE_CHANGE_RCONTAINER = 5;

    CSSModelUpdateContext() {
    }

    void cleanupContext() {
        this.fNodeList = null;
        this.fDeletionTarget = null;
        this.fDeletionTargetParent = null;
        this.fUpdateMode = 0;
    }

    CounterImpl getCounter() {
        ICSSNode node = this.getNode();
        if (node instanceof CounterImpl) {
            return (CounterImpl)node;
        }
        CSSUtil.debugOut("CounterImpl is expected, but " + CSSUtil.getClassString(node));
        this.ungetNode();
        throw new DOMException(13, "");
    }

    CSSCharsetRuleImpl getCSSCharsetRule() {
        ICSSNode node = this.getNode();
        if (node instanceof CSSCharsetRuleImpl) {
            return (CSSCharsetRuleImpl)node;
        }
        CSSUtil.debugOut("CSSCharsetRuleImpl is expected, but " + CSSUtil.getClassString(node));
        this.ungetNode();
        throw new DOMException(13, "");
    }

    CSSFontFaceRuleImpl getCSSFontFaceRule() {
        ICSSNode node = this.getNode();
        if (node instanceof CSSFontFaceRuleImpl) {
            return (CSSFontFaceRuleImpl)node;
        }
        CSSUtil.debugOut("CSSFontFaceRuleImpl is expected, but " + CSSUtil.getClassString(node));
        this.ungetNode();
        throw new DOMException(13, "");
    }

    CSSImportRuleImpl getCSSImportRule() {
        ICSSNode node = this.getNode();
        if (node instanceof CSSImportRuleImpl) {
            return (CSSImportRuleImpl)node;
        }
        CSSUtil.debugOut("CSSImportRuleImpl is expected, but " + CSSUtil.getClassString(node));
        this.ungetNode();
        throw new DOMException(13, "");
    }

    CSSMediaRuleImpl getCSSMediaRule() {
        ICSSNode node = this.getNode();
        if (node instanceof CSSMediaRuleImpl) {
            return (CSSMediaRuleImpl)node;
        }
        CSSUtil.debugOut("CSSMediaRuleImpl is expected, but " + CSSUtil.getClassString(node));
        this.ungetNode();
        throw new DOMException(13, "");
    }

    CSSPageRuleImpl getCSSPageRule() {
        ICSSNode node = this.getNode();
        if (node instanceof CSSPageRuleImpl) {
            return (CSSPageRuleImpl)node;
        }
        CSSUtil.debugOut("CSSPageRuleImpl is expected, but " + CSSUtil.getClassString(node));
        this.ungetNode();
        throw new DOMException(13, "");
    }

    CSSPrimitiveValueImpl getCSSPrimitiveValue(short type) {
        short nodeType;
        ICSSNode node = this.getNode();
        if (!(!(node instanceof CSSPrimitiveValueImpl) || (nodeType = ((CSSPrimitiveValueImpl)node).getPrimitiveType()) != type && (nodeType != 1 && nodeType != 26 || type != 1 && type != 26))) {
            return (CSSPrimitiveValueImpl)node;
        }
        if (node instanceof CSSPrimitiveValueImpl) {
            CSSPrimitiveValueImpl value = (CSSPrimitiveValueImpl)node;
            CSSUtil.debugOut("CSSPrimitiveValueImpl [" + type + "] is expected, but type is [" + value.getPrimitiveType() + "]: \"" + value.generateSource() + "\"");
        } else {
            CSSUtil.debugOut("CSSPrimitiveValueImpl(" + type + ") is expected, but " + CSSUtil.getClassString(node));
        }
        this.ungetNode();
        throw new DOMException(13, "");
    }

    CSSPrimitiveValueImpl getCSSPrimitiveValueAny() {
        ICSSNode node = this.getNode();
        if (node instanceof CSSPrimitiveValueImpl) {
            return (CSSPrimitiveValueImpl)node;
        }
        CSSUtil.debugOut("CSSPrimitiveValueImpl is expected, but " + CSSUtil.getClassString(node));
        this.ungetNode();
        throw new DOMException(13, "");
    }

    CSSStyleDeclItemImpl getCSSStyleDeclItem(String propertyName) {
        ICSSNode node = this.getNode();
        if (node instanceof CSSStyleDeclItemImpl && ((CSSStyleDeclItemImpl)node).getPropertyName().equalsIgnoreCase(propertyName)) {
            return (CSSStyleDeclItemImpl)node;
        }
        CSSUtil.debugOut("CSSStyleDeclItemImpl(" + propertyName + ") is expected, but " + CSSUtil.getClassString(node));
        this.ungetNode();
        throw new DOMException(13, "");
    }

    CSSStyleRuleImpl getCSSStyleRule() {
        ICSSNode node = this.getNode();
        if (node instanceof CSSStyleRuleImpl) {
            return (CSSStyleRuleImpl)node;
        }
        CSSUtil.debugOut("CSSStyleRuleImpl is expected, but " + CSSUtil.getClassString(node));
        this.ungetNode();
        throw new DOMException(13, "");
    }

    ICSSNode getDeletionTarget() {
        return this.fDeletionTarget;
    }

    ICSSNode getDeletionTargetParent() {
        return this.fDeletionTargetParent;
    }

    private ICSSNode getNode() {
        ICSSNode node = null;
        if (this.fNodeList != null && this.fNodeList.size() > 0) {
            node = (ICSSNode)this.fNodeList.removeFirst();
        }
        this.fLastNode = node;
        return node;
    }

    int getNodeCount() {
        if (this.fNodeList != null) {
            return this.fNodeList.size();
        }
        return -1;
    }

    RectImpl getRect() {
        ICSSNode node = this.getNode();
        if (node instanceof RectImpl) {
            return (RectImpl)node;
        }
        CSSUtil.debugOut("RectImpl is expected, but " + CSSUtil.getClassString(node));
        this.ungetNode();
        throw new DOMException(13, "");
    }

    RGBColorImpl getRGBColor() {
        ICSSNode node = this.getNode();
        if (node instanceof RGBColorImpl) {
            return (RGBColorImpl)node;
        }
        CSSUtil.debugOut("RGBColorImpl is expected, but " + CSSUtil.getClassString(node));
        this.ungetNode();
        throw new DOMException(13, "");
    }

    short getUpdateMode() {
        return this.fUpdateMode;
    }

    boolean isActive() {
        return this.fNodeList != null;
    }

    void setupContext(short updateMode, ICSSNode parentNode, ICSSNode targetNode) {
        ICSSNode traverseRoot;
        this.fUpdateMode = updateMode;
        if (updateMode == 4 || updateMode == 2 || updateMode == 5) {
            traverseRoot = parentNode;
            while (traverseRoot instanceof CSSRegionContainer) {
                traverseRoot = traverseRoot.getParentNode();
            }
        } else {
            traverseRoot = targetNode;
        }
        if (updateMode == 4 || updateMode == 2 || updateMode == 5 || updateMode == 3) {
            this.fDeletionTarget = traverseRoot;
            this.fDeletionTargetParent = this.fDeletionTarget == targetNode ? parentNode : this.fDeletionTarget.getParentNode();
        } else {
            this.fDeletionTarget = null;
            this.fDeletionTargetParent = null;
        }
        if (updateMode == 2 || updateMode == 1 || updateMode == 4 || updateMode == 5) {
            CSSNodeUpdateTraverser traverser = new CSSNodeUpdateTraverser();
            traverser.apply(traverseRoot);
            this.fNodeList = traverser.getNodeList();
        } else {
            this.fNodeList = null;
        }
    }

    private void ungetNode() {
        if (this.fNodeList != null && this.fLastNode != null) {
            this.fNodeList.addFirst(this.fLastNode);
        }
    }

    class CSSNodeUpdateTraverser
    extends AbstractCssTraverser {
        LinkedList fTravNodeList = null;

        public CSSNodeUpdateTraverser() {
            this.setTraverseImported(false);
            this.setTraverseImportFirst(false);
        }

        public LinkedList getNodeList() {
            return this.fTravNodeList;
        }

        @Override
        protected void begin(ICSSNode node) {
            this.fTravNodeList = new LinkedList();
        }

        @Override
        protected short preNode(ICSSNode node) {
            if (!(node instanceof CSSStyleDeclarationImpl || node instanceof CSSAttrImpl || node instanceof MediaListImpl)) {
                this.fTravNodeList.add(node);
            }
            if (node instanceof CSSPrimitiveContainer) {
                return TRAV_PRUNE;
            }
            return TRAV_CONT;
        }
    }
}

