/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.application.dialogs;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.StartupPreferencePage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class IDEStartupPreferencePage
extends StartupPreferencePage
implements IWorkbenchPreferencePage {
    private Button refreshButton;
    private Button showProblemsButton;
    private Button exitPromptButton;

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.startup_preference_page_context");
        Composite composite = this.createComposite(parent);
        this.createRefreshWorkspaceOnStartupPref(composite);
        this.createProblemsViewOnStartupPref(composite);
        this.createExitPromptPref(composite);
        ((LabelFactory)LabelFactory.newLabel((int)0).layoutData((Object)new GridData())).create((Widget)composite);
        this.createEarlyStartupSelection(composite);
        return composite;
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getIDEPreferenceStore();
        this.refreshButton.setSelection(store.getDefaultBoolean("REFRESH_WORKSPACE_ON_STARTUP"));
        this.showProblemsButton.setSelection(store.getDefaultBoolean("SHOW_PROBLEMS_VIEW_DECORATIONS_ON_STARTUP"));
        this.exitPromptButton.setSelection(store.getDefaultBoolean("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW"));
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getIDEPreferenceStore();
        store.setValue("REFRESH_WORKSPACE_ON_STARTUP", this.refreshButton.getSelection());
        store.setValue("SHOW_PROBLEMS_VIEW_DECORATIONS_ON_STARTUP", this.showProblemsButton.getSelection());
        store.setValue("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW", this.exitPromptButton.getSelection());
        IDEWorkbenchPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    protected void createRefreshWorkspaceOnStartupPref(Composite composite) {
        this.refreshButton = new Button(composite, 32);
        this.refreshButton.setText(IDEWorkbenchMessages.StartupPreferencePage_refreshButton);
        this.refreshButton.setFont(composite.getFont());
        this.refreshButton.setSelection(this.getIDEPreferenceStore().getBoolean("REFRESH_WORKSPACE_ON_STARTUP"));
    }

    protected void createProblemsViewOnStartupPref(Composite composite) {
        this.showProblemsButton = new Button(composite, 32);
        this.showProblemsButton.setText(IDEWorkbenchMessages.StartupPreferencePage_showProblemsButton);
        this.showProblemsButton.setFont(composite.getFont());
        this.showProblemsButton.setSelection(this.getIDEPreferenceStore().getBoolean("SHOW_PROBLEMS_VIEW_DECORATIONS_ON_STARTUP"));
    }

    protected void createExitPromptPref(Composite composite) {
        this.exitPromptButton = new Button(composite, 32);
        this.exitPromptButton.setText(IDEWorkbenchMessages.StartupPreferencePage_exitPromptButton);
        this.exitPromptButton.setFont(composite.getFont());
        this.exitPromptButton.setSelection(this.getIDEPreferenceStore().getBoolean("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW"));
    }

    protected IPreferenceStore getIDEPreferenceStore() {
        return IDEWorkbenchPlugin.getDefault().getPreferenceStore();
    }
}

