/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.statesystem.provider;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.provider.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.ITimeElement;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class StateSystemDataProvider
extends AbstractTmfTraceDataProvider
implements ITimeGraphDataProvider<TimeGraphEntryModel> {
    public static final String ID = "org.eclipse.tracecompass.internal.tmf.core.statesystem.provider.StateSystemDataProvider";
    public static final String SUFFIX = ".dataprovider";
    private static final String HT_EXTENSION = ".ht";
    private static final AtomicLong ENTRY_ID = new AtomicLong();
    private Map<Long, Pair<ITmfStateSystem, Integer>> fIDToDisplayQuark = new HashMap<Long, Pair<ITmfStateSystem, Integer>>();
    private final Map<ITmfStateSystem, Long> fSsToId = new HashMap<ITmfStateSystem, Long>();
    private final List<ModuleEntryModel> fModuleEntryModelList = new ArrayList<ModuleEntryModel>();
    private final Map<ITmfAnalysisModuleWithStateSystems, Boolean> fModulesToStatus = new HashMap<ITmfAnalysisModuleWithStateSystems, Boolean>();
    private final Table<Long, String, EntryModelBuilder> fEntryBuilder = HashBasedTable.create();
    private final Set<ITmfAnalysisModuleWithStateSystems> fStartedAnalysis = Objects.requireNonNull(ConcurrentHashMap.newKeySet());

    public StateSystemDataProvider(ITmfTrace trace) {
        super(trace);
        for (ITmfAnalysisModuleWithStateSystems module : Objects.requireNonNull(Iterables.filter(trace.getAnalysisModules(), ITmfAnalysisModuleWithStateSystems.class))) {
            this.fModulesToStatus.put(module, false);
        }
    }

    @Override
    public @NonNull String getId() {
        return ID;
    }

    @Override
    public TmfModelResponse<List<ITimeGraphArrow>> fetchArrows(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse<Object>(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    @Override
    public TmfModelResponse<Map<String, String>> fetchTooltip(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        Map<Long, Pair<ITmfStateSystem, Integer>> entries = this.getSelectedEntries(fetchParameters);
        if (entries.size() != 1) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        Map.Entry<@NonNull Long, @NonNull Pair<ITmfStateSystem, Integer>> entry = entries.entrySet().iterator().next();
        HashMap<String, String> tooltip = new HashMap<String, String>();
        Integer quark = Objects.requireNonNull(entry.getValue()).getSecond();
        ITmfStateSystem ss = Objects.requireNonNull(entry.getValue()).getFirst();
        tooltip.put(String.valueOf(Messages.QuarkColumnLabel), Integer.toString(quark));
        tooltip.put(String.valueOf(Messages.AttributePathColumnLabel), ss.getFullAttributePath(quark.intValue()));
        tooltip.put(String.valueOf(Messages.ValueColumnLabel), StateSystemDataProvider.getQuarkValue(fetchParameters, ss, quark));
        return new TmfModelResponse<Map<String, String>>(tooltip, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, Pair<ITmfStateSystem, Integer>> getSelectedEntries(Map<String, Object> fetchParameters) {
        List<Long> selectedItems = DataProviderParameterUtils.extractSelectedItems(fetchParameters);
        if (selectedItems == null) {
            return Collections.emptyMap();
        }
        HashMap<Long, Pair<ITmfStateSystem, Integer>> idToQuark = new HashMap<Long, Pair<ITmfStateSystem, Integer>>();
        Table<Long, String, EntryModelBuilder> table = this.fEntryBuilder;
        synchronized (table) {
            for (Long id : selectedItems) {
                Pair<ITmfStateSystem, Integer> pair = this.fIDToDisplayQuark.get(id);
                if (pair == null) continue;
                idToQuark.put(id, pair);
            }
        }
        return idToQuark;
    }

    private static String getQuarkValue(Map<String, Object> fetchParameters, ITmfStateSystem ss, Integer quark) {
        String valueString = null;
        try {
            ArrayList actualList;
            Long actualTime;
            Object actualTimeObj = fetchParameters.get("requested_times");
            if (actualTimeObj instanceof ArrayList && (actualTime = (Long)(actualList = (ArrayList)actualTimeObj).get(0)) != null) {
                ITmfStateInterval interval = ss.querySingleState(actualTime.longValue(), quark.intValue());
                valueString = String.valueOf(interval.getValue());
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return NonNullUtils.nullToEmptyString(valueString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull TmfModelResponse<TmfTreeModel<TimeGraphEntryModel>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        boolean fetchTreeIsComplete;
        Table<Long, String, EntryModelBuilder> table = this.fEntryBuilder;
        synchronized (table) {
            this.fModuleEntryModelList.clear();
            fetchTreeIsComplete = this.addTrace(monitor);
            if (monitor != null && monitor.isCanceled()) {
                return new TmfModelResponse<Object>(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
            }
        }
        List<TimeGraphEntryModel> entryList = this.buildEntryList(monitor);
        ITmfResponse.Status status = fetchTreeIsComplete ? ITmfResponse.Status.COMPLETED : ITmfResponse.Status.RUNNING;
        String msg = fetchTreeIsComplete ? CommonStatusMessage.COMPLETED : CommonStatusMessage.RUNNING;
        return new TmfModelResponse<TmfTreeModel<TimeGraphEntryModel>>(new TmfTreeModel<TimeGraphEntryModel>(Collections.emptyList(), entryList), status, msg);
    }

    private boolean addTrace(@Nullable IProgressMonitor monitor) {
        TraceEntryModel.Builder traceEntry;
        boolean fetchTreeIsComplete = true;
        ITmfTrace trace = this.getTrace();
        String traceName = Objects.requireNonNull(trace.getName());
        EntryModelBuilder entry = (EntryModelBuilder)this.fEntryBuilder.get((Object)-1L, (Object)traceName);
        if (entry instanceof TraceEntryModel.Builder) {
            traceEntry = (TraceEntryModel.Builder)entry;
        } else {
            long newId = ENTRY_ID.getAndIncrement();
            traceEntry = new TraceEntryModel.Builder(newId, -1L, traceName, trace.getStartTime().toNanos(), trace);
            this.fEntryBuilder.put((Object)-1L, (Object)traceName, (Object)traceEntry);
        }
        long rootId = traceEntry.getId();
        for (Map.Entry<ITmfAnalysisModuleWithStateSystems, Boolean> moduleWithStatus : this.fModulesToStatus.entrySet()) {
            if (monitor != null && monitor.isCanceled()) {
                return false;
            }
            ITmfAnalysisModuleWithStateSystems module = Objects.requireNonNull(moduleWithStatus.getKey());
            Boolean analysisIsDone = Objects.requireNonNull(moduleWithStatus.getValue());
            if (analysisIsDone.booleanValue() && !this.fStartedAnalysis.contains(module)) continue;
            fetchTreeIsComplete &= this.addModule(monitor, module, rootId, trace.getStartTime().toNanos());
            this.fStartedAnalysis.remove(module);
        }
        long traceEnd = traceEntry.getEndTime();
        for (ModuleEntryModel moduleEntryModel : this.fModuleEntryModelList) {
            if (monitor != null && monitor.isCanceled()) {
                return false;
            }
            traceEnd = Long.max(traceEnd, moduleEntryModel.getEndTime());
        }
        traceEntry.setEndTime(traceEnd);
        return fetchTreeIsComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addModule(@Nullable IProgressMonitor monitor, ITmfAnalysisModuleWithStateSystems module, Long parentId, Long startTime) {
        ModuleEntryModel.Builder moduleEntry;
        Set<ITmfAnalysisModuleWithStateSystems> set = this.fStartedAnalysis;
        synchronized (set) {
            if (monitor != null && monitor.isCanceled()) {
                return false;
            }
        }
        this.waitForInitialization(this.getTrace(), module);
        String moduleName = Objects.requireNonNull(module.getName());
        EntryModelBuilder entry = (EntryModelBuilder)this.fEntryBuilder.get((Object)parentId, (Object)moduleName);
        if (entry instanceof ModuleEntryModel.Builder) {
            moduleEntry = (ModuleEntryModel.Builder)entry;
        } else {
            long newId = ENTRY_ID.getAndIncrement();
            moduleEntry = new ModuleEntryModel.Builder(newId, parentId, moduleName, startTime, module);
            this.fEntryBuilder.put((Object)parentId, (Object)moduleName, (Object)moduleEntry);
        }
        long moduleId = moduleEntry.getId();
        boolean fetchTreeIsComplete = true;
        Long moduleEnd = startTime;
        boolean hasChildren = false;
        for (ITmfStateSystem ss : module.getStateSystems()) {
            if (monitor != null && monitor.isCanceled()) {
                return false;
            }
            fetchTreeIsComplete &= ss.waitUntilBuilt(0L);
            if (!ss.isCancelled()) {
                this.addStateSystem(monitor, ss, moduleId);
                moduleEnd = Long.max(moduleEnd, ss.getCurrentEndTime());
                hasChildren = true;
                continue;
            }
            EntryModelBuilder ssEntry = (EntryModelBuilder)this.fEntryBuilder.get((Object)moduleId, (Object)ss.getSSID());
            if (ssEntry == null) continue;
            this.deleteElementFromBuildEntryList(ssEntry.getId());
        }
        moduleEntry.setEndTime(moduleEnd);
        this.fEntryBuilder.put((Object)parentId, (Object)moduleName, (Object)moduleEntry);
        ModuleEntryModel finalModuleEntry = moduleEntry.build();
        this.fModuleEntryModelList.add(finalModuleEntry);
        if (fetchTreeIsComplete && hasChildren) {
            this.fModulesToStatus.put(module, true);
        }
        return fetchTreeIsComplete;
    }

    private void addStateSystem(@Nullable IProgressMonitor monitor, ITmfStateSystem ss, long parentId) {
        StateSystemEntryModel.Builder stateSystemEntryModel;
        String ssName = ss.getSSID();
        EntryModelBuilder entry = (EntryModelBuilder)this.fEntryBuilder.get((Object)parentId, (Object)ssName);
        Long startTime = ss.getStartTime();
        Long endTime = ss.getCurrentEndTime();
        if (entry instanceof StateSystemEntryModel.Builder) {
            stateSystemEntryModel = (StateSystemEntryModel.Builder)entry;
        } else {
            long id = ENTRY_ID.getAndIncrement();
            stateSystemEntryModel = new StateSystemEntryModel.Builder(id, parentId, ssName, startTime, endTime, ss);
            this.fEntryBuilder.put((Object)parentId, (Object)ssName, (Object)stateSystemEntryModel);
        }
        long ssId = stateSystemEntryModel.getId();
        stateSystemEntryModel.setEndTime(endTime);
        this.fEntryBuilder.put((Object)parentId, (Object)ssName, (Object)stateSystemEntryModel);
        this.fSsToId.put(ss, ssId);
        for (Integer attrib : ss.getSubAttributes(-1, false)) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            this.addSubAttributes(monitor, ssId, startTime, endTime, ss, attrib);
        }
    }

    private void addSubAttributes(@Nullable IProgressMonitor monitor, Long parentId, Long startTime, Long endTime, ITmfStateSystem ss, Integer attrib) {
        AttributeEntryModel.Builder attributeEntry;
        String name = ss.getAttributeName(attrib.intValue());
        EntryModelBuilder entry = (EntryModelBuilder)this.fEntryBuilder.get((Object)parentId, (Object)name);
        if (entry instanceof AttributeEntryModel.Builder) {
            attributeEntry = (AttributeEntryModel.Builder)entry;
        } else {
            Long id = ENTRY_ID.getAndIncrement();
            attributeEntry = new AttributeEntryModel.Builder(id, parentId, name, startTime, endTime, attrib);
            this.fEntryBuilder.put((Object)parentId, (Object)name, (Object)attributeEntry);
        }
        long id = attributeEntry.getId();
        Pair<ITmfStateSystem, Integer> displayQuark = new Pair<ITmfStateSystem, Integer>(ss, attrib);
        this.fIDToDisplayQuark.put(id, displayQuark);
        for (Integer child : ss.getSubAttributes(attrib.intValue(), false)) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            this.addSubAttributes(monitor, id, startTime, endTime, ss, child);
        }
        attributeEntry.setEndTime(endTime);
        this.fEntryBuilder.put((Object)parentId, (Object)name, (Object)attributeEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TimeGraphEntryModel> buildEntryList(@Nullable IProgressMonitor monitor) {
        ArrayList<TimeGraphEntryModel> entryList = new ArrayList<TimeGraphEntryModel>();
        Table<Long, String, EntryModelBuilder> table = this.fEntryBuilder;
        synchronized (table) {
            for (EntryModelBuilder entry : this.fEntryBuilder.values()) {
                if (monitor != null && monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                entryList.add((TimeGraphEntryModel)entry.build());
            }
        }
        return entryList;
    }

    private void deleteElementFromBuildEntryList(Long rowID) {
        for (EntryModelBuilder entry : this.fEntryBuilder.row((Object)rowID).values()) {
            this.deleteElementFromBuildEntryList(entry.getId());
        }
        this.fEntryBuilder.row((Object)rowID).clear();
    }

    private void waitForInitialization(ITmfTrace trace, ITmfAnalysisModuleWithStateSystems module) {
        if (module.isAutomatic() || this.fStartedAnalysis.remove(module)) {
            module.waitForInitialization();
            return;
        }
        String dir = TmfTraceManager.getSupplementaryFileDir(trace);
        boolean exists = Paths.get(dir, String.valueOf(module.getId()) + HT_EXTENSION).toFile().exists();
        if (exists) {
            module.schedule();
            module.waitForInitialization();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull TmfModelResponse<@NonNull TimeGraphModel> fetchRowModel(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        HashBasedTable table = HashBasedTable.create();
        Collection<Long> selectedItems = DataProviderParameterUtils.extractSelectedItems(fetchParameters);
        Table<Long, String, EntryModelBuilder> table2 = this.fEntryBuilder;
        synchronized (table2) {
            if (selectedItems == null) {
                selectedItems = this.fIDToDisplayQuark.keySet();
            }
            for (Long id : selectedItems) {
                Pair<ITmfStateSystem, Integer> pair = this.fIDToDisplayQuark.get(id);
                if (pair == null) continue;
                table.put((Object)pair.getFirst(), (Object)((Integer)pair.getSecond()), (Object)id);
            }
        }
        ArrayList<@NonNull ITimeGraphRowModel> allRows = new ArrayList<ITimeGraphRowModel>();
        try {
            List<Long> times = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
            for (Map.Entry entry : table.rowMap().entrySet()) {
                ITmfStateSystem ss = Objects.requireNonNull((ITmfStateSystem)entry.getKey());
                List<@NonNull ITimeGraphRowModel> rows = this.getRowModels(ss, (Map)entry.getValue(), times, fetchParameters, monitor);
                if (monitor != null && monitor.isCanceled()) {
                    return new TmfModelResponse<Object>(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                }
                Table<Long, String, EntryModelBuilder> table3 = this.fEntryBuilder;
                synchronized (table3) {
                    Long ssId = this.fSsToId.get(ss);
                    if (ssId != null && selectedItems.contains(ssId)) {
                        TimeGraphRowModel ssRow = new TimeGraphRowModel(ssId, new ArrayList<ITimeGraphState>());
                        List<@NonNull ITimeGraphState> states = ssRow.getStates();
                        states.add(new TimeGraphState(ss.getStartTime(), ss.getCurrentEndTime() - ss.getStartTime(), Integer.MAX_VALUE));
                        rows.add(ssRow);
                    }
                }
                allRows.addAll(rows);
            }
            Table<Long, String, EntryModelBuilder> table4 = this.fEntryBuilder;
            synchronized (table4) {
                for (ModuleEntryModel module : this.fModuleEntryModelList) {
                    if (!selectedItems.contains(module.getId())) continue;
                    allRows.add(StateSystemDataProvider.getModuleRowModels(module));
                }
            }
            if (monitor != null && monitor.isCanceled()) {
                return new TmfModelResponse<Object>(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
            }
            return new TmfModelResponse<TimeGraphModel>(new TimeGraphModel(allRows), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException e) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, CommonStatusMessage.STATE_SYSTEM_FAILED);
        }
    }

    private static ITimeGraphRowModel getModuleRowModels(ModuleEntryModel module) {
        TimeGraphRowModel moduleRow = new TimeGraphRowModel(module.getId(), new ArrayList<ITimeGraphState>());
        List<@NonNull ITimeGraphState> states = moduleRow.getStates();
        states.add(new TimeGraphState(module.getStartTime(), module.getEndTime() - module.getStartTime(), Integer.MAX_VALUE));
        return moduleRow;
    }

    private List<@NonNull ITimeGraphRowModel> getRowModels(ITmfStateSystem ss, Map<Integer, Long> idToDisplayQuark, @Nullable List<Long> times, Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        HashMap<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates = new HashMap<Integer, Predicate<Multimap<String, Object>>>();
        Multimap<@NonNull Integer, @NonNull String> regexesMap = DataProviderParameterUtils.extractRegexFilter(fetchParameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        HashMap<Integer, TimeGraphRowModel> quarkToRow = new HashMap<Integer, TimeGraphRowModel>(idToDisplayQuark.size());
        for (Map.Entry<Integer, Long> entry : idToDisplayQuark.entrySet()) {
            quarkToRow.put(entry.getKey(), new TimeGraphRowModel(entry.getValue(), new ArrayList<ITimeGraphState>()));
        }
        for (ITmfStateInterval interval : ss.query2D(idToDisplayQuark.keySet(), StateSystemDataProvider.getTimes(ss, times))) {
            if (monitor != null && monitor.isCanceled()) {
                return Collections.emptyList();
            }
            ITimeGraphRowModel row = (ITimeGraphRowModel)quarkToRow.get(interval.getAttribute());
            if (row == null) continue;
            List<@NonNull ITimeGraphState> states = row.getStates();
            TimeGraphState timeGraphState = StateSystemDataProvider.getStateFromInterval(interval, ss.getCurrentEndTime());
            this.applyFilterAndAddState(states, timeGraphState, row.getEntryID(), predicates, monitor);
        }
        for (ITimeGraphRowModel model : quarkToRow.values()) {
            model.getStates().sort(Comparator.comparingLong(ITimeElement::getStartTime));
        }
        return new ArrayList<ITimeGraphRowModel>(quarkToRow.values());
    }

    private static Set<Long> getTimes(ITmfStateSystem key, @Nullable List<Long> timeRequested) {
        if (timeRequested == null) {
            return Collections.emptySet();
        }
        HashSet<@NonNull Long> times = new HashSet<Long>();
        for (long t : timeRequested) {
            if (key.getStartTime() > t || t > key.getCurrentEndTime()) continue;
            times.add(t);
        }
        return times;
    }

    private static TimeGraphState getStateFromInterval(ITmfStateInterval statusInterval, long currentEndTime) {
        long time = statusInterval.getStartTime();
        long duration = Math.min(statusInterval.getEndTime(), currentEndTime - 1L) + 1L - time;
        Object o = statusInterval.getValue();
        if (o instanceof Integer) {
            return new TimeGraphState(time, duration, (Integer)o, String.valueOf(o));
        }
        if (o instanceof Long) {
            long l = (Long)o;
            return new TimeGraphState(time, duration, (int)l, "0x" + Long.toHexString(l));
        }
        if (o instanceof String) {
            return new TimeGraphState(time, duration, Integer.MIN_VALUE, (String)o);
        }
        if (o instanceof Double) {
            return new TimeGraphState(time, duration, ((Double)o).intValue());
        }
        return new TimeGraphState(time, duration, Integer.MIN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startedAnalysisSignalHandler(ITmfAnalysisModuleWithStateSystems module) {
        Set<ITmfAnalysisModuleWithStateSystems> set = this.fStartedAnalysis;
        synchronized (set) {
            this.fStartedAnalysis.add(module);
        }
    }

    public static class AttributeEntryModel
    extends TimeGraphEntryModel {
        private final int fQuark;

        protected AttributeEntryModel(long id, long parentId, String name, long start, long end, int quark) {
            super(id, parentId, name, start, end, true);
            this.fQuark = quark;
        }

        public int getQuark() {
            return this.fQuark;
        }

        private static final class Builder
        extends EntryModelBuilder {
            private final Integer fQuark;

            public Builder(long id, Long parentId, String traceName, long startTime, long endTime, Integer quark) {
                super(id, parentId, traceName, startTime);
                this.setEndTime(endTime);
                this.fQuark = quark;
            }

            public Integer getQuark() {
                return this.fQuark;
            }

            public AttributeEntryModel build() {
                return new AttributeEntryModel(this.getId(), this.getParentId(), this.getName(), this.getStartTime(), this.getEndTime(), this.getQuark());
            }
        }
    }

    private static abstract class EntryModelBuilder {
        private final long fId;
        private final long fParentId;
        private final String fName;
        private final long fStartTime;
        private long fEndTime;

        public EntryModelBuilder(long id, long parenId, String traceName, long startTime) {
            this.fId = id;
            this.fParentId = parenId;
            this.fName = traceName;
            this.fStartTime = startTime;
            this.fEndTime = startTime;
        }

        public long getId() {
            return this.fId;
        }

        public long getParentId() {
            return this.fParentId;
        }

        public String getName() {
            return this.fName;
        }

        public long getStartTime() {
            return this.fStartTime;
        }

        public long getEndTime() {
            return this.fEndTime;
        }

        public void setEndTime(long endTime) {
            this.fEndTime = endTime;
        }

        public abstract <T extends TimeGraphEntryModel> T build();
    }

    public static class ModuleEntryModel
    extends TimeGraphEntryModel {
        private final ITmfAnalysisModuleWithStateSystems fModule;

        protected ModuleEntryModel(long id, long parentId, String name, long startTime, long endTime, ITmfAnalysisModuleWithStateSystems module) {
            super(id, parentId, name, startTime, endTime);
            this.fModule = module;
        }

        public ITmfAnalysisModuleWithStateSystems getModule() {
            return this.fModule;
        }

        private static final class Builder
        extends EntryModelBuilder {
            private final ITmfAnalysisModuleWithStateSystems fModule;

            public Builder(long id, long parentId, String traceName, long startTime, ITmfAnalysisModuleWithStateSystems module) {
                super(id, parentId, traceName, startTime);
                this.fModule = module;
            }

            public ModuleEntryModel build() {
                return new ModuleEntryModel(this.getId(), this.getParentId(), this.getName(), this.getStartTime(), this.getEndTime(), this.fModule);
            }
        }
    }

    public static class StateSystemEntryModel
    extends TimeGraphEntryModel {
        private final ITmfStateSystem fSs;

        protected StateSystemEntryModel(long id, long parentId, String name, long startTime, long endTime, ITmfStateSystem ss) {
            super(id, parentId, name, startTime, endTime);
            this.fSs = ss;
        }

        public ITmfStateSystem getStateSystem() {
            return this.fSs;
        }

        private static final class Builder
        extends EntryModelBuilder {
            private final ITmfStateSystem fSs;

            public Builder(long id, long parentId, String traceName, long startTime, long endTime, ITmfStateSystem ss) {
                super(id, parentId, traceName, startTime);
                this.setEndTime(endTime);
                this.fSs = ss;
            }

            public StateSystemEntryModel build() {
                return new StateSystemEntryModel(this.getId(), this.getParentId(), this.getName(), this.getStartTime(), this.getEndTime(), this.fSs);
            }
        }
    }

    public static class TraceEntryModel
    extends TimeGraphEntryModel {
        private final ITmfTrace fEntryTrace;

        protected TraceEntryModel(long id, long parentId, String traceName, long startTime, long endTime, ITmfTrace trace) {
            super(id, parentId, traceName, startTime, endTime);
            this.fEntryTrace = trace;
        }

        public ITmfTrace getTrace() {
            return this.fEntryTrace;
        }

        private static final class Builder
        extends EntryModelBuilder {
            private final ITmfTrace fTrace;

            public Builder(long id, long parentId, String traceName, long startTime, ITmfTrace trace) {
                super(id, parentId, traceName, startTime);
                this.fTrace = trace;
            }

            public TraceEntryModel build() {
                return new TraceEntryModel(this.getId(), this.getParentId(), this.getName(), this.getStartTime(), this.getEndTime(), this.fTrace);
            }
        }
    }
}

