/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.handler;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.ui.views.handler.MRUList;
import org.eclipse.tcf.te.ui.views.nls.Messages;
import org.eclipse.ui.internal.navigator.NavigatorFilterService;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

public class UpdateActiveFiltersOperation
extends AbstractOperation {
    private String[] filterIdsToActivate;
    private final CommonViewer commonViewer;
    private final INavigatorContentService contentService;

    public UpdateActiveFiltersOperation(CommonViewer aCommonViewer, String[] theActiveFilterIds) {
        super(Messages.UpdateActiveFiltersOperation_OperationName);
        Assert.isNotNull((Object)theActiveFilterIds);
        this.commonViewer = aCommonViewer;
        this.contentService = this.commonViewer.getNavigatorContentService();
        this.filterIdsToActivate = theActiveFilterIds;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        NavigatorFilterService filterService = (NavigatorFilterService)this.contentService.getFilterService();
        ICommonFilterDescriptor[] filterDescriptors = filterService.getVisibleFilterDescriptorsForUI();
        ArrayList<String> deltaList = new ArrayList<String>();
        HashSet<String> current = new HashSet<String>();
        Object[] objectArray = filterDescriptors;
        int n = filterDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ICommonFilterDescriptor filterDescriptor = objectArray[n2];
            String filterId = filterDescriptor.getId();
            if (filterService.isActive(filterId)) {
                current.add(filterId);
                deltaList.add(filterId);
            }
            ++n2;
        }
        objectArray = this.filterIdsToActivate;
        n = this.filterIdsToActivate.length;
        n2 = 0;
        while (n2 < n) {
            ICommonFilterDescriptor filterId = objectArray[n2];
            if (current.contains(filterId)) {
                deltaList.remove(filterId);
            } else {
                deltaList.add((String)filterId);
            }
            ++n2;
        }
        filterService.activateFilterIdsAndUpdateViewer(this.filterIdsToActivate);
        MRUList mru = new MRUList("te.ui.PrefFilterMRUs");
        mru.updateMRUList(deltaList);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
        return null;
    }
}

