/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.concurrent.TCFOperationMonitor;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNodeWorkingCopy;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.AbstractOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpDelete
extends AbstractOperation {
    LinkedList<WorkItem> fWork = new LinkedList();
    IConfirmCallback fConfirmCallback;
    private List<FSTreeNode> fNodes;

    public OpDelete(List<? extends IFSTreeNode> nodes, IConfirmCallback confirmCallback) {
        this.fNodes = this.dropNestedNodes(nodes);
        this.fConfirmCallback = confirmCallback;
    }

    @Override
    protected IStatus doRun(IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getName(), (int)this.fNodes.size());
        for (FSTreeNode node : this.fNodes) {
            IStatus status = this.removeNode(node, sm.newChild(1));
            node.getParent().notifyChange();
            if (status.isOK()) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    private IStatus removeNode(FSTreeNode node, SubMonitor monitor) {
        this.fWork.add(new WorkItem(node));
        while (!this.fWork.isEmpty()) {
            IStatus s = this.runWorkItem(this.fWork.remove(), (IProgressMonitor)monitor);
            if (s.isOK()) continue;
            node.notifyChange();
            return s;
        }
        return Status.OK_STATUS;
    }

    protected IStatus runWorkItem(final WorkItem item, IProgressMonitor monitor) {
        if (item.fContentLeftOK) {
            if (item.fParent == null) {
                return item.fNode.operationRefresh(true).run(monitor);
            }
            return Status.OK_STATUS;
        }
        if (this.fConfirmCallback != null && this.fConfirmCallback.requires(item.fNode)) {
            int makeWritable = this.confirmCallback(item.fNode, this.fConfirmCallback);
            switch (makeWritable) {
                case 2: {
                    item.setContentLeftOK();
                    return Status.OK_STATUS;
                }
                case 0: {
                    IStatus s = this.mkWritable(item.fNode, monitor);
                    if (s.isOK()) break;
                    return s;
                }
                default: {
                    return Status.CANCEL_STATUS;
                }
            }
        }
        CacheManager.clearCache(item.fNode);
        final TCFOperationMonitor result = new TCFOperationMonitor();
        monitor.subTask(NLS.bind((String)Messages.OpDelete_RemovingFileFolder, (Object)item.fNode.getLocation()));
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                OpDelete.this.tcfRunWorkItem(item, result);
            }
        });
        return result.waitDone(monitor);
    }

    private IStatus mkWritable(IFSTreeNode node, IProgressMonitor monitor) {
        IFSTreeNodeWorkingCopy workingCopy = node.createWorkingCopy();
        if (node.isWindowsNode()) {
            workingCopy.setReadOnly(false);
        } else {
            workingCopy.setWritable(true);
        }
        return workingCopy.operationCommit().run((IProgressMonitor)new SubProgressMonitor(monitor, 0));
    }

    protected void tcfRunWorkItem(WorkItem item, TCFOperationMonitor<?> result) {
        if (item.fNode.isFile()) {
            this.tcfDeleteFile(item, result);
        } else if (item.fNode.isDirectory()) {
            if (item.fContentCleared) {
                this.tcfDeleteEmptyFolder(item, result);
            } else {
                this.tcfDeleteFolder(item, result);
            }
        } else {
            result.setDone(null);
        }
    }

    private void tcfDeleteFolder(final WorkItem item, final TCFOperationMonitor<?> result) {
        final String path = item.fNode.getLocation(true);
        IFileSystem fs = item.fNode.getRuntimeModel().getFileSystem();
        if (fs == null) {
            result.setCancelled();
            return;
        }
        this.tcfReadDir(fs, path, new AbstractOperation.IReadDirDone(){

            @Override
            public void error(IFileSystem.FileSystemException error) {
                result.setError(MessageFormat.format(Messages.OpDelete_error_readDir, path), (Throwable)error);
            }

            @Override
            public boolean checkCancelled() {
                return result.checkCancelled();
            }

            @Override
            public void done(List<IFileSystem.DirEntry> entries) {
                item.fContentCleared = true;
                OpDelete.this.fWork.addFirst(item);
                for (IFileSystem.DirEntry entry : entries) {
                    FSTreeNode node = new FSTreeNode(item.fNode, entry.filename, false, entry.attrs);
                    OpDelete.this.fWork.addFirst(new WorkItem(item, node));
                }
                result.setDone(null);
            }
        });
    }

    private void tcfDeleteFile(final WorkItem item, final TCFOperationMonitor<?> result) {
        IFileSystem fs = item.fNode.getRuntimeModel().getFileSystem();
        if (fs == null) {
            result.setCancelled();
            return;
        }
        fs.remove(item.fNode.getLocation(true), new IFileSystem.DoneRemove(){

            public void doneRemove(IToken token, IFileSystem.FileSystemException error) {
                OpDelete.this.tcfHandleRemoved(item, error, result);
            }
        });
    }

    private void tcfDeleteEmptyFolder(final WorkItem item, final TCFOperationMonitor<?> result) {
        IFileSystem fs = item.fNode.getRuntimeModel().getFileSystem();
        if (fs == null) {
            result.setCancelled();
            return;
        }
        fs.rmdir(item.fNode.getLocation(true), new IFileSystem.DoneRemove(){

            public void doneRemove(IToken token, IFileSystem.FileSystemException error) {
                OpDelete.this.tcfHandleRemoved(item, error, result);
            }
        });
    }

    protected void tcfHandleRemoved(WorkItem item, IFileSystem.FileSystemException error, TCFOperationMonitor<?> result) {
        if (error != null) {
            result.setError(MessageFormat.format(Messages.OpDelete_error_delete, item.fNode.getLocation()), (Throwable)error);
        } else if (!result.checkCancelled()) {
            if (item.fParent == null) {
                item.fNode.getParent().removeNode(item.fNode, true);
            }
            result.setDone(null);
        }
    }

    @Override
    public String getName() {
        return Messages.OpDelete_Deleting;
    }

    private static class WorkItem {
        final WorkItem fParent;
        final FSTreeNode fNode;
        boolean fContentCleared = false;
        boolean fContentLeftOK = false;

        WorkItem(FSTreeNode node) {
            this.fParent = null;
            this.fNode = node;
        }

        WorkItem(WorkItem item, FSTreeNode node) {
            this.fParent = item;
            this.fNode = node;
        }

        void setContentLeftOK() {
            this.fContentLeftOK = true;
            if (this.fParent != null) {
                this.fParent.setContentLeftOK();
            }
        }
    }
}

