/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.jdt.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swtbot.generator.framework.GenerationRule;
import org.eclipse.swtbot.generator.framework.Generator;
import org.eclipse.swtbot.generator.framework.IRecorderDialog;
import org.eclipse.swtbot.generator.jdt.editor.AddClassDialog;
import org.eclipse.swtbot.generator.jdt.editor.AddMethodDialog;
import org.eclipse.swtbot.generator.jdt.editor.document.ClassDocument;
import org.eclipse.swtbot.generator.jdt.editor.listener.AnnotationSelectionListener;
import org.eclipse.swtbot.generator.jdt.editor.listener.ClassAnnotationSelectionListener;
import org.eclipse.swtbot.generator.jdt.editor.listener.MethodSelectionListener;
import org.eclipse.swtbot.generator.ui.BotGeneratorEventDispatcher;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class JDTRecorderDialog
extends TitleAreaDialog
implements IRecorderDialog {
    private BotGeneratorEventDispatcher recorder;
    private List<Generator> availableGenerators;
    private Map<CTabItem, SourceViewer> tabViewer;
    private Map<CTabItem, ToolBar> tabToolBar;
    private CTabFolder classTabFolder;
    private Button recordPauseButton;
    private MethodSelectionListener methodListener;
    private List<Shell> ignoredShells = new ArrayList<Shell>();
    public static final String ID = "org.eclipse.swtbot.generator.dialog.jdt";
    private Image wizban;
    private Image icon;

    public JDTRecorderDialog() {
        super(null);
        this.tabViewer = new HashMap<CTabItem, SourceViewer>();
        this.setShellStyle(3184);
        this.setBlockOnOpen(false);
        this.tabToolBar = new HashMap<CTabItem, ToolBar>();
    }

    public void create() {
        this.wizban = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.swtbot.generator", (String)"icons/swtbot_rec64.png").createImage();
        this.icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.swtbot.generator", (String)"icons/swtbot_rec16.png").createImage();
        super.create();
        this.getShell().setImage(this.icon);
        this.getShell().setText("SWTBot Test Recorder");
        this.setMessage("This dialog will track the generated code while you're recording your UI scenario.");
        this.setTitle("SWTBot Test Recorder");
        this.setTitleImage(this.wizban);
        this.ignoredShells.add(this.getShell());
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite generatorSelectionContainer = new Composite(container, 0);
        generatorSelectionContainer.setLayout((Layout)new GridLayout(2, false));
        Label selectorLabel = new Label(generatorSelectionContainer, 0);
        selectorLabel.setText("Target Bot API:");
        selectorLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        ComboViewer generatorSelectionCombo = new ComboViewer(generatorSelectionContainer);
        generatorSelectionCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        generatorSelectionCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object o) {
                return ((Generator)o).getLabel();
            }
        });
        generatorSelectionCombo.setInput(this.availableGenerators);
        generatorSelectionCombo.setSelection((ISelection)new StructuredSelection((Object)this.recorder.getCurrentGenerator()));
        generatorSelectionCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Generator newGenerator = (Generator)((IStructuredSelection)event.getSelection()).getFirstElement();
                JDTRecorderDialog.this.recorder.setGenerator(newGenerator);
                JDTRecorderDialog.this.updateAnnotationToolBar();
                Image image = newGenerator.getImage();
                if (image != null) {
                    image = new Image((Device)Display.getDefault(), image.getImageData().scaledTo(80, 80));
                    JDTRecorderDialog.this.setTitleImage(image);
                } else {
                    JDTRecorderDialog.this.setTitleImage(null);
                }
            }
        });
        this.classTabFolder = new CTabFolder(container, 2112);
        this.classTabFolder.setUnselectedCloseVisible(false);
        this.classTabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        ToolBar addClassToolbar = new ToolBar((Composite)this.classTabFolder, 256);
        this.classTabFolder.setTopRight((Control)addClassToolbar);
        ToolItem addClassItem = new ToolItem(addClassToolbar, 0);
        addClassItem.setText("+");
        addClassItem.setToolTipText("Add class");
        addClassItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JDTRecorderDialog.this.openClassShell();
            }
        });
        this.createTabItem(this.classTabFolder, "RecordedTestCase");
        this.classTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SourceViewer viewer = (SourceViewer)JDTRecorderDialog.this.tabViewer.get(JDTRecorderDialog.this.classTabFolder.getSelection());
                ClassDocument doc = (ClassDocument)viewer.getDocument();
                if (doc.getActiveMethod() == null) {
                    JDTRecorderDialog.this.recorder.setRecording(false);
                    JDTRecorderDialog.this.recordPauseButton.setText("Start Recording");
                }
                JDTRecorderDialog.this.updateAnnotationToolBar();
            }
        });
        Composite actionsComposite = new Composite(container, 0);
        actionsComposite.setLayout((Layout)new RowLayout(256));
        this.recordPauseButton = new Button(actionsComposite, 8);
        this.recordPauseButton.setText("Start Recording");
        Button copyButton = new Button(actionsComposite, 8);
        copyButton.setText("Copy");
        this.recordPauseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JDTRecorderDialog.this.recorder.isRecording()) {
                    JDTRecorderDialog.this.recorder.setRecording(false);
                    JDTRecorderDialog.this.recordPauseButton.setText("Start Recording");
                } else {
                    SourceViewer viewer = (SourceViewer)JDTRecorderDialog.this.tabViewer.get(JDTRecorderDialog.this.classTabFolder.getSelection());
                    ClassDocument doc = (ClassDocument)viewer.getDocument();
                    if (doc.getActiveMethod() == null) {
                        JDTRecorderDialog.this.openMethodShell(true);
                    } else {
                        JDTRecorderDialog.this.recorder.setRecording(true);
                        JDTRecorderDialog.this.recordPauseButton.setText("Pause");
                    }
                }
            }
        });
        this.recorder.addListener(new BotGeneratorEventDispatcher.CodeGenerationListener(){

            public void handleCodeGenerated(GenerationRule code) {
                SourceViewer viewer = (SourceViewer)JDTRecorderDialog.this.tabViewer.get(JDTRecorderDialog.this.classTabFolder.getSelection());
                ClassDocument doc = (ClassDocument)viewer.getDocument();
                doc.addGenerationRule(code);
                viewer.setTopIndex(((ClassDocument)viewer.getDocument()).getLastOffset() - 4);
            }
        });
        copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Clipboard cb = new Clipboard(Display.getDefault());
                TextTransfer textTransfer = TextTransfer.getInstance();
                SourceViewer viewer = (SourceViewer)JDTRecorderDialog.this.tabViewer.get(JDTRecorderDialog.this.classTabFolder.getSelection());
                cb.setContents(new Object[]{viewer.getDocument().get()}, new Transfer[]{textTransfer});
                cb.dispose();
            }
        });
        return container;
    }

    private void createTabItem(CTabFolder tabFolder, String text) {
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(text);
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        ToolBar toolBar = new ToolBar(composite, 256);
        this.tabToolBar.put(tabItem, toolBar);
        RowLayout rLayout = new RowLayout();
        rLayout.fill = true;
        rLayout.justify = true;
        toolBar.setLayout((Layout)rLayout);
        ToolItem tItem = new ToolItem(toolBar, 8);
        tItem.setText("Add method");
        ToolItem methodItemDropDown = new ToolItem(toolBar, 4);
        methodItemDropDown.setText("No active method");
        ToolItem annotationsToolItem = new ToolItem(toolBar, 4);
        annotationsToolItem.setText("Method annotation");
        ToolItem annotationsClassToolItem = new ToolItem(toolBar, 4);
        annotationsClassToolItem.setText("Class annotation");
        this.methodListener = new MethodSelectionListener(methodItemDropDown, this.recorder, this.tabViewer, this.classTabFolder, annotationsToolItem);
        methodItemDropDown.addSelectionListener((SelectionListener)this.methodListener);
        tItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                JDTRecorderDialog.this.openMethodShell(false);
            }
        });
        ClassDocument doc = new ClassDocument(text, this.recorder.getCurrentGenerator().getLabel().toUpperCase().contains("SWTBOT") ? "org.eclipse.swtbot.eclipse.finder.SWTBotEclipseTestCase" : null);
        SourceViewer generatedCode = new SourceViewer(composite, (IVerticalRuler)new VerticalRuler(0), 2818);
        JavaSourceViewerConfiguration javaConf = new JavaSourceViewerConfiguration(JavaUI.getColorManager(), PreferenceConstants.getPreferenceStore(), null, null);
        generatedCode.configure((SourceViewerConfiguration)javaConf);
        JavaTextTools tools = new JavaTextTools(PreferenceConstants.getPreferenceStore());
        tools.setupJavaDocumentPartitioner((IDocument)doc);
        generatedCode.setDocument((IDocument)doc);
        generatedCode.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        generatedCode.setEditable(false);
        tabItem.setControl((Control)composite);
        tabFolder.setSelection(tabItem);
        this.tabViewer.put(tabItem, generatedCode);
        doc.setViewer(generatedCode);
        AnnotationSelectionListener listenerAnnot = new AnnotationSelectionListener(annotationsToolItem, this.recorder, this.tabViewer, this.classTabFolder);
        annotationsToolItem.addSelectionListener((SelectionListener)listenerAnnot);
        annotationsToolItem.setData((Object)listenerAnnot);
        ClassAnnotationSelectionListener listenerClassAnnot = new ClassAnnotationSelectionListener(annotationsClassToolItem, this.recorder, this.tabViewer, this.classTabFolder);
        annotationsClassToolItem.addSelectionListener((SelectionListener)listenerClassAnnot);
        annotationsClassToolItem.setData((Object)listenerClassAnnot);
        listenerAnnot.update();
    }

    private void openClassShell() {
        final AddClassDialog d = new AddClassDialog(this.getShell());
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (d.open() == 0) {
                    String classText = d.getClassName();
                    JDTRecorderDialog.this.createTabItem(JDTRecorderDialog.this.classTabFolder, classText);
                    JDTRecorderDialog.this.recorder.setRecording(false);
                    JDTRecorderDialog.this.recordPauseButton.setText("Start Recording");
                }
            }
        });
    }

    private void openMethodShell(final boolean fromStartButton) {
        SourceViewer viewer = this.tabViewer.get(this.classTabFolder.getSelection());
        final ClassDocument doc = (ClassDocument)viewer.getDocument();
        final AddMethodDialog d = new AddMethodDialog(this.getShell(), doc.getMethods());
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (d.open() == 0) {
                    String methodText = d.getMethodName();
                    doc.addMethod(methodText);
                    JDTRecorderDialog.this.methodListener.add(methodText);
                    if (fromStartButton) {
                        JDTRecorderDialog.this.recorder.setRecording(true);
                        JDTRecorderDialog.this.recordPauseButton.setText("Pause");
                    }
                    JDTRecorderDialog.this.updateAnnotationToolBar();
                }
            }
        });
    }

    protected Point getInitialSize() {
        return new Point(585, 650);
    }

    public void createButtonsForButtonBar(Composite parent) {
    }

    public BotGeneratorEventDispatcher getRecorder() {
        return this.recorder;
    }

    public void setRecorder(BotGeneratorEventDispatcher recorder) {
        this.recorder = recorder;
    }

    public List<Generator> getAvailableGenerators() {
        return this.availableGenerators;
    }

    public void setAvailableGenerators(List<Generator> availableGenerators) {
        this.availableGenerators = availableGenerators;
    }

    public List<Shell> getIgnoredShells() {
        return this.ignoredShells;
    }

    public String getName() {
        return "JDT Dialog";
    }

    public String getId() {
        return ID;
    }

    public void setRecording(boolean record) {
        this.recorder.setRecording(record);
        if (record) {
            this.recordPauseButton.setText("Pause");
        } else {
            this.recordPauseButton.setText("Start Recording");
        }
    }

    public String getGeneratedCodeText() {
        SourceViewer viewer = this.tabViewer.get(this.classTabFolder.getSelection());
        ClassDocument doc = (ClassDocument)viewer.getDocument();
        return doc.get();
    }

    private void updateAnnotationToolBar() {
        ToolBar activeToolBar = this.tabToolBar.get(this.classTabFolder.getSelection());
        ToolItem[] toolItemArray = activeToolBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            if (item.getData() instanceof AnnotationSelectionListener) {
                ((AnnotationSelectionListener)((Object)item.getData())).addItems(this.recorder.getCurrentGenerator().createAnnotationRules());
                ((AnnotationSelectionListener)((Object)item.getData())).update();
            } else if (item.getData() instanceof ClassAnnotationSelectionListener) {
                ((ClassAnnotationSelectionListener)((Object)item.getData())).addItems(this.recorder.getCurrentGenerator().createAnnotationRules());
                ((ClassAnnotationSelectionListener)((Object)item.getData())).update();
            }
            ++n2;
        }
    }

    public boolean close() {
        this.wizban.dispose();
        this.icon.dispose();
        return super.close();
    }
}

