/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.resources;

import org.eclipse.rse.files.ui.resources.ISystemRemoteMarkerSetElement;

public class SystemRemoteMarkerSet {
    private static final int MINIMUM_SIZE = 5;
    private int elementCount = 0;
    private ISystemRemoteMarkerSetElement[] elements;

    public SystemRemoteMarkerSet() {
        this(5);
    }

    public SystemRemoteMarkerSet(int capacity) {
        this.elements = new ISystemRemoteMarkerSetElement[Math.max(5, capacity * 2)];
    }

    public void add(ISystemRemoteMarkerSetElement element) {
        int hash;
        if (element == null) {
            return;
        }
        int i = hash = this.hashFor(element.getId()) % this.elements.length;
        while (i < this.elements.length) {
            if (this.elements[i] == null) {
                this.elements[i] = element;
                ++this.elementCount;
                if (this.shouldGrow()) {
                    this.expand();
                }
                return;
            }
            ++i;
        }
        i = 0;
        while (i < hash - 1) {
            if (this.elements[i] == null) {
                this.elements[i] = element;
                ++this.elementCount;
                if (this.shouldGrow()) {
                    this.expand();
                }
                return;
            }
            ++i;
        }
        this.expand();
        this.add(element);
    }

    public void addAll(ISystemRemoteMarkerSetElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            this.add(elements[i]);
            ++i;
        }
    }

    public boolean contains(long id) {
        return this.get(id) != null;
    }

    public ISystemRemoteMarkerSetElement[] elements() {
        ISystemRemoteMarkerSetElement[] result = new ISystemRemoteMarkerSetElement[this.elementCount];
        int j = 0;
        int i = 0;
        while (i < this.elements.length) {
            ISystemRemoteMarkerSetElement element = this.elements[i];
            if (element != null) {
                result[j] = element;
                ++j;
            }
            ++i;
        }
        return result;
    }

    private void expand() {
        ISystemRemoteMarkerSetElement[] array = new ISystemRemoteMarkerSetElement[this.elements.length * 2];
        int maxArrayIndex = array.length - 1;
        int i = 0;
        while (i < this.elements.length) {
            ISystemRemoteMarkerSetElement element = this.elements[i];
            if (element != null) {
                int hash = this.hashFor(element.getId()) % array.length;
                while (array[hash] != null) {
                    if (++hash <= maxArrayIndex) continue;
                    hash = 0;
                }
                array[hash] = element;
            }
            ++i;
        }
        this.elements = array;
    }

    public ISystemRemoteMarkerSetElement get(long id) {
        ISystemRemoteMarkerSetElement element;
        int hash;
        if (this.elementCount == 0) {
            return null;
        }
        int i = hash = this.hashFor(id) % this.elements.length;
        while (i < this.elements.length) {
            element = this.elements[i];
            if (element == null) {
                return null;
            }
            if (element.getId() == id) {
                return element;
            }
            ++i;
        }
        i = 0;
        while (i < hash - 1) {
            element = this.elements[i];
            if (element == null) {
                return null;
            }
            if (element.getId() == id) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private int hashFor(long id) {
        return Math.abs((int)id);
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    private void rehashTo(int anIndex) {
        int target = anIndex;
        int index = anIndex + 1;
        if (index >= this.elements.length) {
            index = 0;
        }
        ISystemRemoteMarkerSetElement element = this.elements[index];
        while (element != null) {
            boolean match;
            int hashIndex = this.hashFor(element.getId()) % this.elements.length;
            if (index < target) {
                match = hashIndex <= target && hashIndex > index;
            } else {
                boolean bl = match = hashIndex <= target || hashIndex > index;
            }
            if (match) {
                this.elements[target] = element;
                target = index;
            }
            if (++index >= this.elements.length) {
                index = 0;
            }
            element = this.elements[index];
        }
        this.elements[target] = null;
    }

    public void remove(long id) {
        ISystemRemoteMarkerSetElement element;
        int hash;
        int i = hash = this.hashFor(id) % this.elements.length;
        while (i < this.elements.length) {
            element = this.elements[i];
            if (element == null) {
                return;
            }
            if (element.getId() == id) {
                this.rehashTo(i);
                --this.elementCount;
            }
            ++i;
        }
        i = 0;
        while (i < hash - 1) {
            element = this.elements[i];
            if (element == null) {
                return;
            }
            if (element.getId() == id) {
                this.rehashTo(i);
                --this.elementCount;
            }
            ++i;
        }
    }

    public void remove(ISystemRemoteMarkerSetElement element) {
        this.remove(element.getId());
    }

    public void removeAll(ISystemRemoteMarkerSetElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            this.remove(elements[i]);
            ++i;
        }
    }

    private boolean shouldGrow() {
        return (double)this.elementCount > (double)this.elements.length * 0.75;
    }

    public int size() {
        return this.elementCount;
    }
}

