/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.cdt.ui.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.wizards.CDTConfigWizardPage;
import org.eclipse.cdt.managedbuilder.ui.wizards.CfgHolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.internal.rdt.sync.cdt.core.Activator;
import org.eclipse.ptp.internal.rdt.sync.cdt.ui.messages.Messages;
import org.eclipse.ptp.internal.rdt.sync.ui.wizards.SyncWizardDataCache;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.resources.RemoteSyncNature;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SyncConfigToBuildConfigWizardPage
extends WizardPage {
    private static final String ConfigMapKey = "config-map";
    private static final String ToolchainMapKey = "toolchain-map";
    private static final String SyncConfigSetKey = "sync-config-set";
    private static final String ProjectNameKey = "project-name";
    public static final String CDT_CONFIG_PAGE_ID = "org.eclipse.cdt.managedbuilder.ui.wizard.CConfigWizardPage";
    private String fConfigName;
    private Composite parentComposite;
    private Composite composite;
    private Map<String, String> syncConfigToBuildConfigMap = new HashMap<String, String>();
    private Map<String, String> syncConfigToToolchainMap;
    private Map<String, String> toolchainToBuildConfigMap = new HashMap<String, String>();
    private final WizardMode wizardMode;

    public SyncConfigToBuildConfigWizardPage(WizardMode mode) {
        super("CDT SyncConfigToBuildConfigWizardPage");
        this.wizardMode = mode;
        this.setTitle(Messages.SyncConfigToBuildConfigWizardPage_0);
        this.setDescription(Messages.SyncConfigToBuildConfigWizardPage_1);
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        this.parentComposite = parent;
        this.update();
    }

    private IProject getAndValidateProject() {
        String projectName = SyncWizardDataCache.getProperty((String)ProjectNameKey);
        if (projectName == null) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        assert (project != null) : String.valueOf(Messages.SyncConfigToBuildConfigWizardPage_4) + projectName;
        return project;
    }

    public String getBuildConfiguration() {
        return this.fConfigName;
    }

    private CDTConfigWizardPage findCDTConfigPage() {
        IWizardPage page = this.getPreviousPage();
        while (page != null) {
            if (page instanceof CDTConfigWizardPage) {
                return (CDTConfigWizardPage)page;
            }
            page = page.getPreviousPage();
        }
        return null;
    }

    private Set<String> getBuildConfigNames() {
        CfgHolder[] cfgHolders;
        CDTConfigWizardPage configPage = this.findCDTConfigPage();
        if (configPage == null) {
            Activator.log((String)Messages.SyncConfigToBuildConfigWizardPage_8);
            return new HashSet<String>();
        }
        HashSet<String> configNames = new HashSet<String>();
        CfgHolder[] cfgHolderArray = cfgHolders = configPage.getCfgItems(false);
        int n = cfgHolders.length;
        int n2 = 0;
        while (n2 < n) {
            CfgHolder h = cfgHolderArray[n2];
            configNames.add(h.getName());
            IToolChain toolchain = h.getToolChain();
            String toolchainName = toolchain == null ? "No ToolChain" : h.getToolChain().getName();
            if (toolchainName != null) {
                this.toolchainToBuildConfigMap.put(toolchainName, h.getName());
            }
            ++n2;
        }
        return configNames;
    }

    private String[] getBuildConfigs() {
        switch (this.wizardMode) {
            case NEW: 
            case ADD_CDT: {
                Set<String> buildConfigsSet = this.getBuildConfigNames();
                if (buildConfigsSet == null) {
                    return null;
                }
                assert (buildConfigsSet.size() > 0) : Messages.SyncConfigToBuildConfigWizardPage_7;
                return buildConfigsSet.toArray(new String[0]);
            }
            case ADD_SYNC: {
                IProject project = this.getAndValidateProject();
                if (project == null) {
                    return null;
                }
                assert (this.isCDTProject(project)) : String.valueOf(Messages.SyncConfigToBuildConfigWizardPage_5) + project.getName();
                IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
                IConfiguration[] buildConfigs = buildInfo.getManagedProject().getConfigurations();
                ArrayList<String> buildConfigNames = new ArrayList<String>();
                IConfiguration[] iConfigurationArray = buildConfigs;
                int n = buildConfigs.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfiguration config = iConfigurationArray[n2];
                    buildConfigNames.add(config.getName());
                    ++n2;
                }
                return buildConfigNames.toArray(new String[0]);
            }
        }
        assert (false) : Messages.SyncConfigToBuildConfigWizardPage_6;
        return null;
    }

    private String[] getSyncConfigs() {
        switch (this.wizardMode) {
            case NEW: 
            case ADD_SYNC: {
                Set syncConfigsSet = SyncWizardDataCache.getMultiValueProperty((String)SyncConfigSetKey);
                if (syncConfigsSet == null) {
                    return null;
                }
                assert (syncConfigsSet.size() > 0) : Messages.SyncConfigToBuildConfigWizardPage_2;
                return syncConfigsSet.toArray(new String[0]);
            }
            case ADD_CDT: {
                IProject project = this.getAndValidateProject();
                if (project == null) {
                    return null;
                }
                assert (this.isSyncProject(project)) : String.valueOf(Messages.SyncConfigToBuildConfigWizardPage_5) + project.getName();
                SyncConfig[] syncConfigs = SyncConfigManager.getConfigs((IProject)project);
                ArrayList<String> syncConfigNames = new ArrayList<String>();
                SyncConfig[] syncConfigArray = syncConfigs;
                int n = syncConfigs.length;
                int n2 = 0;
                while (n2 < n) {
                    SyncConfig config = syncConfigArray[n2];
                    syncConfigNames.add(config.getName());
                    ++n2;
                }
                return syncConfigNames.toArray(new String[0]);
            }
        }
        assert (false) : Messages.SyncConfigToBuildConfigWizardPage_6;
        return null;
    }

    private boolean isCDTProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature");
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
            return false;
        }
    }

    private boolean isSyncProject(IProject project) {
        return RemoteSyncNature.hasNature((IProject)project);
    }

    public void setVisible(boolean isVisible) {
        this.update();
        super.setVisible(isVisible);
    }

    public void update() {
        if (this.composite != null) {
            this.composite.dispose();
        }
        this.composite = new Composite(this.parentComposite, 0);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label syncConfigLabel = new Label(this.composite, 0x1000000);
        syncConfigLabel.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        syncConfigLabel.setText(Messages.SyncConfigToBuildConfigWizardPage_10);
        Label buildConfigLabel = new Label(this.composite, 0x1000000);
        buildConfigLabel.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        buildConfigLabel.setText(Messages.SyncConfigToBuildConfigWizardPage_11);
        String[] syncConfigNames = this.getSyncConfigs();
        String[] buildConfigNames = this.getBuildConfigs();
        this.syncConfigToToolchainMap = SyncWizardDataCache.getMap((String)ToolchainMapKey);
        if (this.syncConfigToToolchainMap == null) {
            this.syncConfigToToolchainMap = new HashMap<String, String>();
        }
        if (syncConfigNames == null || buildConfigNames == null) {
            this.setControl((Control)this.composite);
            return;
        }
        String[] stringArray = syncConfigNames;
        int n = syncConfigNames.length;
        int n2 = 0;
        while (n2 < n) {
            final String sname = stringArray[n2];
            Label label = new Label(this.composite, 0);
            label.setLayoutData((Object)new GridData(131072, 4, false, false));
            label.setText(String.valueOf(sname) + ":");
            final Combo combo = new Combo(this.composite, 8);
            String defaultBuildConfig = "none";
            String defaultToolchain = this.syncConfigToToolchainMap.get(sname);
            if (defaultToolchain != null && this.toolchainToBuildConfigMap.containsKey(defaultToolchain)) {
                defaultBuildConfig = this.toolchainToBuildConfigMap.get(defaultToolchain);
            }
            int toSelect = -1;
            String[] stringArray2 = buildConfigNames;
            int n3 = buildConfigNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String bname = stringArray2[n4];
                if (defaultBuildConfig.equals(bname)) {
                    toSelect = combo.getItemCount();
                }
                combo.add(bname);
                ++n4;
            }
            if (toSelect > -1) {
                combo.select(toSelect);
            }
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = combo.getSelectionIndex();
                    if (index >= 0) {
                        SyncConfigToBuildConfigWizardPage.this.syncConfigToBuildConfigMap.put(sname, combo.getText());
                    } else {
                        SyncConfigToBuildConfigWizardPage.this.syncConfigToBuildConfigMap.remove(sname);
                    }
                    SyncWizardDataCache.setMap((String)SyncConfigToBuildConfigWizardPage.ConfigMapKey, (Map)SyncConfigToBuildConfigWizardPage.this.syncConfigToBuildConfigMap);
                }
            });
            ++n2;
        }
        this.setControl((Control)this.composite);
        this.parentComposite.layout(true, true);
    }

    static enum WizardMode {
        NEW,
        ADD_SYNC,
        ADD_CDT;

    }
}

