/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.launch;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class AnyResourceTreeSelectionDialog
extends ElementTreeSelectionDialog {
    private Text text;
    private boolean isRefresh;
    private TreeViewer viewer;
    private List<IPath> result;
    private String textMessage;

    public AnyResourceTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        this.viewer = super.createTreeViewer(parent);
        this.viewer.addSelectionChangedListener(event -> {
            if (this.isRefresh) {
                return;
            }
            this.isRefresh = true;
            try {
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                String newText = ssel.isEmpty() ? "" : ((IResource)ssel.getFirstElement()).getProjectRelativePath().toPortableString();
                this.text.setText(newText);
                this.result = null;
            }
            finally {
                this.isRefresh = false;
            }
        });
        Label label = new Label(parent, 2048);
        label.setText(this.textMessage);
        this.text = new Text(parent, 2048);
        this.text.setLayoutData((Object)new GridData(4, -1, true, false));
        this.text.addModifyListener(e -> {
            if (this.isRefresh) {
                return;
            }
            this.isRefresh = true;
            try {
                String newtext = this.text.getText();
                Path path = new Path(newtext);
                IResource res = ((IContainer)this.viewer.getInput()).findMember((IPath)path);
                if (res != null) {
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)res));
                } else {
                    this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
                this.result = Collections.singletonList(path);
            }
            finally {
                this.isRefresh = false;
            }
        });
        return this.viewer;
    }

    protected void computeResult() {
        if (this.result != null) {
            this.setResult(this.result);
        } else {
            super.computeResult();
        }
    }

    public void setTextMessage(String text) {
        this.textMessage = text;
    }
}

