/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger.handlers;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.WorkspaceRoot;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.php.debug.core.debugger.messages.IDebugMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugResponseMessage;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.model.IPHPExceptionBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.zend.debugger.Breakpoint;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.handlers.AbstractFileContentRequestHandler;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.FileContentRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.FileContentResponse;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;

public class FileContentRequestStaleHandler
extends AbstractFileContentRequestHandler {
    private int reqID;
    private String lastFileName;
    private String encoding;
    private PHPDebugTarget debugTarget;
    private boolean isFirstFileToDebug = true;
    private FileContentRequest contentRequest;

    @Override
    public void handle(IDebugMessage request, PHPDebugTarget debugTarget) {
        this.debugTarget = debugTarget;
        RemoteDebugger remoteDebugger = (RemoteDebugger)debugTarget.getRemoteDebugger();
        boolean isWebServerDebugger = Boolean.toString(true).equals(debugTarget.getLaunch().getAttribute("webServerDebugger"));
        this.contentRequest = (FileContentRequest)request;
        this.reqID = this.contentRequest.getID();
        String currentFileName = this.contentRequest.getFileName();
        debugTarget.setLastFileName(currentFileName);
        String debugType = this.getDebugType();
        this.lastFileName = currentFileName;
        this.encoding = this.contentRequest.getTransferEncoding();
        if (VirtualPath.isAbsolute(this.lastFileName)) {
            Path testWSPath = new Path(this.lastFileName);
            IFile testWSFile = null;
            if (testWSPath.segmentCount() > 1) {
                testWSFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)testWSPath);
            }
            if (!this.isFirstFileToDebug || testWSFile == null || !testWSFile.exists()) {
                if (this.isDummyFile()) {
                    return;
                }
                if (debugType.equals("php_exe_script_debug")) {
                    this.lastFileName = null;
                    this.isFirstFileToDebug = false;
                    return;
                }
                if (isWebServerDebugger) {
                    if (this.isFirstFileToDebug) {
                        this.mapFirstFile(currentFileName);
                        if (debugType.equals("php_web_script_debug")) {
                            VirtualPath remotePath = new VirtualPath(currentFileName);
                            remotePath.removeLastSegment();
                            remoteDebugger.setCurrentWorkingDirectory(remotePath.toString());
                        }
                    }
                    this.lastFileName = remoteDebugger.convertToLocalFilename(currentFileName);
                }
            }
        } else {
            this.lastFileName = remoteDebugger.convertToLocalFilename(currentFileName);
        }
        if (this.lastFileName != null && debugTarget.getLaunch().getLaunchMode().equals("debug")) {
            this.addBreakPoints(debugTarget, currentFileName);
        }
        this.isFirstFileToDebug = false;
    }

    private void addBreakPoints(PHPDebugTarget debugTarget, String currentFileName) {
        IBreakpoint[] breakpoints;
        IBreakpointManager breakpointManager = debugTarget.getBreakpointManager();
        if (!breakpointManager.isEnabled()) {
            return;
        }
        IBreakpoint[] iBreakpointArray = breakpoints = breakpointManager.getBreakpoints("org.eclipse.php.debug.core");
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint element = iBreakpointArray[n2];
            if (!(element instanceof IPHPExceptionBreakpoint)) {
                IResource resourceWithBreakPoint = element.getMarker().getResource();
                String resourcePathName = "";
                if (resourceWithBreakPoint instanceof WorkspaceRoot) {
                    try {
                        resourcePathName = element.getMarker().getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path").toString();
                    }
                    catch (CoreException ce) {
                        PHPDebugPlugin.log(ce);
                        return;
                    }
                } else {
                    IPath resourceLocation = resourceWithBreakPoint.getLocation();
                    resourcePathName = resourceLocation == null ? resourceWithBreakPoint.getLocationURI().toString() : resourceLocation.toOSString();
                }
                String comparablePathName = "";
                if (new File(this.lastFileName).exists()) {
                    comparablePathName = this.lastFileName;
                } else {
                    IFile tmpIFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.lastFileName));
                    IPath tmpLocation = tmpIFile.getLocation();
                    if (tmpIFile.exists()) {
                        comparablePathName = tmpLocation == null ? tmpIFile.getLocationURI().toString() : tmpLocation.toOSString();
                    }
                }
                if (new VirtualPath(resourcePathName).equals(new VirtualPath(comparablePathName))) {
                    try {
                        PHPConditionalBreakpoint phpBP = (PHPConditionalBreakpoint)element;
                        Breakpoint runtimeBreakpoint = phpBP.getRuntimeBreakpoint();
                        int lineNumber = (Integer)element.getMarker().getAttribute("lineNumber");
                        Breakpoint tmpBreakpoint = new Breakpoint(currentFileName, lineNumber);
                        if (tmpBreakpoint.isEnable()) {
                            debugTarget.getRemoteDebugger().addBreakpoint(tmpBreakpoint);
                        }
                        runtimeBreakpoint.setID(tmpBreakpoint.getID());
                    }
                    catch (Exception e) {
                        Logger.logException(e);
                    }
                }
            }
            ++n2;
        }
    }

    private void mapFirstFile(String currentFileName) {
        PathEntry pathEntry = null;
        String debugFileName = null;
        ILaunchConfiguration launchConfiguration = this.debugTarget.getLaunch().getLaunchConfiguration();
        PathMapper pathMapper = PathMapperRegistry.getByLaunchConfiguration(launchConfiguration);
        if (pathMapper != null) {
            try {
                debugFileName = launchConfiguration.getAttribute("ATTR_FILE", null);
            }
            catch (CoreException e) {
                Logger.logException(e);
                return;
            }
            if (debugFileName != null) {
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(debugFileName);
                if (resource instanceof IFile) {
                    pathEntry = new PathEntry(debugFileName, PathEntry.Type.WORKSPACE, (Object)resource.getParent());
                } else if (new File(debugFileName).exists()) {
                    pathEntry = new PathEntry(debugFileName, PathEntry.Type.EXTERNAL, (Object)new File(debugFileName).getParentFile());
                }
            }
            if (pathEntry != null) {
                pathMapper.addEntry(currentFileName, pathEntry, PathMapper.Mapping.MappingSource.ENVIRONMENT);
                PathMapperRegistry.storeToPreferences();
            }
        }
    }

    @Override
    public IDebugResponseMessage getResponseMessage() {
        FileContentResponse response = new FileContentResponse();
        response.setID(this.reqID);
        try {
            byte[] content = null;
            if (this.isDummyFile()) {
                content = this.getDummyContent();
            } else {
                File file;
                IResource member = null;
                if (this.lastFileName != null) {
                    member = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.lastFileName));
                }
                if (member != null) {
                    IPath location = member.getLocation();
                    if (location != null) {
                        File file2 = location.toFile();
                        content = this.getBytesFromFile(file2);
                    } else if (member.exists()) {
                        URI uri = member.getLocationURI();
                        content = this.getBytesFromURI(uri);
                    }
                } else if (this.lastFileName != null && (file = new File(this.lastFileName)).exists()) {
                    content = this.getBytesFromFile(file);
                }
            }
            if (content == null) {
                content = new byte[]{};
            }
            this.setResponseContent(response, this.contentRequest, content);
        }
        catch (FileNotFoundException content) {
        }
        catch (NullPointerException content) {
        }
        catch (Throwable t) {
            Logger.logException("Fail to send the file content to the server", t);
        }
        return response;
    }

    private boolean isDummyFile() {
        return this.lastFileName != null && this.lastFileName.endsWith(this.getDummyFileName());
    }

    private String getDummyFileName() {
        return Platform.getPreferencesService().getString("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.ZEND_DEBUG_DUMMY_FILE, "", null);
    }

    private String getDebugType() {
        String debugType = "";
        try {
            debugType = this.debugTarget.getLaunch().getLaunchConfiguration().getAttribute("php_debug_type", "");
        }
        catch (CoreException ce) {
            PHPDebugPlugin.log(ce);
        }
        return debugType;
    }

    private byte[] getDummyContent() {
        String originalFileName = "";
        try {
            ILaunchConfiguration launchConfiguration = this.debugTarget.getLaunch().getLaunchConfiguration();
            originalFileName = launchConfiguration.getAttribute("ATTR_FILE_FULL_PATH", "");
        }
        catch (CoreException launchConfiguration) {
            // empty catch block
        }
        StringBuilder contentBuf = new StringBuilder("<?php ");
        File originalFile = new File(originalFileName);
        if (!originalFileName.startsWith("\\\\") && originalFile.exists() && this.getDebugType().equals("php_exe_script_debug")) {
            String parentDirectory = originalFile.getParentFile().getAbsolutePath();
            parentDirectory = parentDirectory.replaceAll("\\\\", "\\\\\\\\");
            contentBuf.append("chdir('").append(parentDirectory).append("'); ");
        }
        originalFileName = originalFileName.replaceAll("\\\\", "\\\\\\\\");
        contentBuf.append("include('").append(originalFileName).append("'); ?>");
        String content = contentBuf.toString();
        if (this.encoding != null) {
            try {
                return content.getBytes(this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                Logger.logException("Failed to create dummy content in the '" + this.encoding + "' encoding. \nCreating with the default encoding.", e);
            }
        }
        return content.getBytes();
    }

    private byte[] getBytesFromFile(File file) throws Exception {
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new Exception("The requested file '" + this.lastFileName + "' is too big");
        }
        byte[] bytes = new byte[(int)length];
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        in.readFully(bytes);
        in.close();
        return bytes;
    }

    private byte[] getBytesFromURI(URI uri) throws Exception {
        IFileStore fileStore = EFS.getStore((URI)uri);
        IFileInfo fileInfo = fileStore.fetchInfo();
        long length = fileInfo.getLength();
        if (length > Integer.MAX_VALUE) {
            throw new Exception("The requested file '" + this.lastFileName + "' is too big");
        }
        byte[] bytes = new byte[(int)length];
        InputStream openInputStream = fileStore.openInputStream(0, null);
        DataInputStream in = new DataInputStream(openInputStream);
        in.readFully(bytes);
        in.close();
        return bytes;
    }
}

