/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger.handlers;

import java.util.zip.Adler32;
import org.eclipse.php.debug.core.debugger.handlers.IDebugRequestHandler;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.FileContentExtendedRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.FileContentRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.FileContentResponse;

public abstract class AbstractFileContentRequestHandler
implements IDebugRequestHandler {
    protected void setResponseContent(FileContentResponse response, FileContentRequest request, byte[] content) {
        FileContentExtendedRequest extendedRequest;
        if (request instanceof FileContentExtendedRequest && AbstractFileContentRequestHandler.filesAreIdentical((extendedRequest = (FileContentExtendedRequest)request).getSize(), extendedRequest.getCheckSum(), content)) {
            response.setStatus(302);
            return;
        }
        response.setContent(content);
    }

    private static boolean filesAreIdentical(int requestSize, int requestChecksum, byte[] content) {
        block12: {
            int checksum;
            byte[] newContent;
            byte slashN;
            byte slashR;
            block13: {
                if (requestSize == content.length) {
                    int checksum2 = AbstractFileContentRequestHandler.calcCheckSum(content);
                    return requestChecksum == checksum2;
                }
                int numOfNewLine = 0;
                slashR = 13;
                slashN = 10;
                byte[] byArray = content;
                int n = content.length;
                int n2 = 0;
                while (n2 < n) {
                    byte element = byArray[n2];
                    if (element == slashN) {
                        ++numOfNewLine;
                    }
                    ++n2;
                }
                if (requestSize != content.length + numOfNewLine) break block12;
                newContent = new byte[content.length + numOfNewLine];
                int newContentIndex = 0;
                byte[] byArray2 = content;
                int n3 = content.length;
                int n4 = 0;
                while (n4 < n3) {
                    byte element = byArray2[n4];
                    if (element == slashN) {
                        newContent[newContentIndex] = slashR;
                        ++newContentIndex;
                    }
                    newContent[newContentIndex] = element;
                    ++newContentIndex;
                    ++n4;
                }
                checksum = AbstractFileContentRequestHandler.calcCheckSum(newContent);
                if (requestChecksum != checksum) break block13;
                return true;
            }
            try {
                int index = 0;
                while (index < content.length) {
                    if (content[index] == slashN) {
                        newContent[index] = slashR;
                    } else if (content[index] == slashR) {
                        newContent[index] = slashN;
                    }
                    ++index;
                }
                checksum = AbstractFileContentRequestHandler.calcCheckSum(newContent);
                return requestChecksum == checksum;
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        return false;
    }

    private static int calcCheckSum(byte[] content) {
        Adler32 checksumCalculator = new Adler32();
        checksumCalculator.update(content);
        return (int)checksumCalculator.getValue();
    }
}

