/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.php.internal.core.util.NetworkUtil;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ConfigureHostsDialog
extends MessageDialog {
    private List<Inet4Address> inputIPs;
    private List<Inet4Address> detectedIPs;
    private List<Inet4Address> mergedIPs;
    private Map<Inet4Address, Boolean> initialState = new LinkedHashMap<Inet4Address, Boolean>();
    private CheckboxTableViewer ipsTableViewer;
    private Button resetButton;
    private List<Inet4Address> selectedIPs = new ArrayList<Inet4Address>();

    public ConfigureHostsDialog(List<Inet4Address> inputIPs, List<Inet4Address> detectedIPs) {
        super(PlatformUI.getWorkbench().getDisplay().getActiveShell(), PHPDebugCoreMessages.ConfigureHostsDialog_Configure_client_IPs, null, PHPDebugCoreMessages.ConfigureHostsDialog_Select_addresses, 2, new String[]{PHPDebugCoreMessages.ConfigureHostsDialog_OK_button, PHPDebugCoreMessages.ConfigureHostsDialog_Cancel_button}, 0);
        this.mergeAddresses(inputIPs, detectedIPs);
    }

    public void create() {
        super.create();
        this.getShell().pack(false);
    }

    protected Control createCustomArea(Composite parent) {
        ((GridData)this.messageLabel.getLayoutData()).widthHint = 400;
        return this.createResultTable(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            Object[] selected;
            Object[] objectArray = selected = this.ipsTableViewer.getCheckedElements();
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                this.selectedIPs.add((Inet4Address)s);
                ++n2;
            }
        }
        super.buttonPressed(buttonId);
    }

    protected boolean isResizable() {
        return true;
    }

    private void mergeAddresses(List<Inet4Address> allIPs, List<Inet4Address> detectedIPs) {
        this.inputIPs = allIPs;
        this.detectedIPs = detectedIPs;
        this.mergedIPs = new ArrayList<Inet4Address>();
        this.mergedIPs.addAll(allIPs);
        for (Inet4Address ip : detectedIPs) {
            if (this.mergedIPs.contains(ip)) continue;
            this.mergedIPs.add(ip);
        }
    }

    private Control createResultTable(Composite composite) {
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        compositeLayout.numColumns = 2;
        composite.setLayout((Layout)compositeLayout);
        Composite tableComposite = new Composite(composite, 0);
        GridLayout tableCompositeLayout = new GridLayout();
        tableCompositeLayout.marginHeight = 0;
        tableCompositeLayout.marginWidth = 0;
        tableComposite.setLayout((Layout)new TableColumnLayout());
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonsComposite = new Composite(composite, 0);
        GridLayout buttonsCompositeLayout = new GridLayout();
        buttonsCompositeLayout.marginHeight = 0;
        buttonsCompositeLayout.marginWidth = 0;
        buttonsComposite.setLayout((Layout)buttonsCompositeLayout);
        buttonsComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        GridData tableGridData = new GridData(1, 1, false, false);
        Table ipsTable = new Table(tableComposite, 68388);
        ipsTable.setLayoutData((Object)tableGridData);
        ipsTable.setHeaderVisible(true);
        ipsTable.setLinesVisible(true);
        this.ipsTableViewer = new CheckboxTableViewer(ipsTable);
        this.ipsTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.ipsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.ipsTableViewer);
        this.createColumn(tableComposite, (TableViewer)this.ipsTableViewer, PHPDebugCoreMessages.ConfigureHostsDialog_Address_column, 60, (CellLabelProvider)new AddressLabelProvider());
        this.createColumn(tableComposite, (TableViewer)this.ipsTableViewer, PHPDebugCoreMessages.ConfigureHostsDialog_Type_column, 40, (CellLabelProvider)new TypeLabelProvider());
        this.ipsTableViewer.setInput(this.mergedIPs);
        this.setSelection();
        this.setInitialState();
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(PHPDebugCoreMessages.ConfigureHostsDialog_Select_all_button);
        selectAll.setLayoutData((Object)new GridData(4, 4, true, false));
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureHostsDialog.this.ipsTableViewer.setAllChecked(true);
                ConfigureHostsDialog.this.updateReset();
            }
        });
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(PHPDebugCoreMessages.ConfigureHostsDialog_Deselect_all_button);
        deselectAll.setLayoutData((Object)new GridData(4, 4, true, false));
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureHostsDialog.this.ipsTableViewer.setAllChecked(false);
                ConfigureHostsDialog.this.updateReset();
            }
        });
        this.resetButton = new Button(buttonsComposite, 8);
        this.resetButton.setText(PHPDebugCoreMessages.ConfigureHostsDialog_Reset_button);
        this.resetButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.resetButton.setEnabled(false);
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureHostsDialog.this.restoreInitialState();
            }
        });
        final Button moveUp = new Button(buttonsComposite, 8);
        moveUp.setText(PHPDebugCoreMessages.ConfigureHostsDialog_Up_button);
        moveUp.setLayoutData((Object)new GridData(4, 4, true, false));
        moveUp.setEnabled(false);
        moveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureHostsDialog.this.moveSelectionUp();
            }
        });
        final Button moveDown = new Button(buttonsComposite, 8);
        moveDown.setText(PHPDebugCoreMessages.ConfigureHostsDialog_Down_button);
        moveDown.setLayoutData((Object)new GridData(4, 4, true, false));
        moveDown.setEnabled(false);
        moveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureHostsDialog.this.moveSelectionDown();
            }
        });
        this.ipsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    if (structuredSelection.getFirstElement() != null) {
                        moveUp.setEnabled(true);
                        moveDown.setEnabled(true);
                    } else {
                        moveUp.setEnabled(false);
                        moveDown.setEnabled(false);
                    }
                }
                ConfigureHostsDialog.this.updateReset();
            }
        });
        return composite;
    }

    private void createColumn(Composite tableComposite, TableViewer viewer, String title, int weight, CellLabelProvider labelProvider) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(false);
        TableColumnLayout tableLayout = (TableColumnLayout)tableComposite.getLayout();
        ColumnWeightData columnLayoutData = new ColumnWeightData(weight);
        tableLayout.setColumnData((Widget)column, (ColumnLayoutData)columnLayoutData);
        if (labelProvider != null) {
            viewerColumn.setLabelProvider(labelProvider);
        }
    }

    private void updateReset() {
        boolean enable = false;
        Set<Inet4Address> initialOrder = this.initialState.keySet();
        int ordinal = 0;
        for (Inet4Address address : initialOrder) {
            if (!address.equals(this.mergedIPs.get(ordinal)) || this.ipsTableViewer.getChecked((Object)address) != this.initialState.get(address).booleanValue()) {
                enable = true;
                break;
            }
            ++ordinal;
        }
        this.resetButton.setEnabled(enable);
    }

    private void setSelection() {
        int i = 0;
        while (i < this.mergedIPs.size()) {
            Inet4Address next = this.mergedIPs.get(i);
            if (this.inputIPs.contains(next)) {
                this.ipsTableViewer.setChecked((Object)next, true);
            } else {
                this.ipsTableViewer.setChecked((Object)next, false);
            }
            ++i;
        }
    }

    private void moveSelectionDown() {
        ISelection selection = this.ipsTableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            int index = this.mergedIPs.indexOf(selected);
            this.mergedIPs.remove(index);
            this.mergedIPs.add(index == this.mergedIPs.size() ? index : index + 1, (Inet4Address)selected);
            this.ipsTableViewer.setSelection((ISelection)new StructuredSelection(selected));
            this.ipsTableViewer.setInput(this.mergedIPs);
        }
        this.updateReset();
    }

    private void moveSelectionUp() {
        ISelection selection = this.ipsTableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            int index = this.mergedIPs.indexOf(selected);
            this.mergedIPs.remove(index);
            this.mergedIPs.add(index == 0 ? index : index - 1, (Inet4Address)selected);
            this.ipsTableViewer.setSelection((ISelection)new StructuredSelection(selected));
            this.ipsTableViewer.setInput(this.mergedIPs);
        }
        this.updateReset();
    }

    private void setInitialState() {
        this.initialState = new LinkedHashMap<Inet4Address, Boolean>();
        for (Inet4Address address : this.mergedIPs) {
            this.initialState.put(address, false);
        }
        Object[] objectArray = this.ipsTableViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object checked = objectArray[n2];
            this.initialState.put((Inet4Address)checked, true);
            ++n2;
        }
    }

    private void restoreInitialState() {
        this.mergeAddresses(this.inputIPs, this.detectedIPs);
        this.ipsTableViewer.setInput(this.mergedIPs);
        this.setSelection();
        this.setInitialState();
        this.resetButton.setEnabled(false);
    }

    public List<Inet4Address> getSelectedIPs() {
        return this.selectedIPs;
    }

    private class AddressLabelProvider
    extends ColumnLabelProvider {
        private AddressLabelProvider() {
        }

        public String getText(Object element) {
            Inet4Address address = (Inet4Address)element;
            return address.getHostAddress();
        }

        public Image getImage(Object element) {
            Inet4Address address = (Inet4Address)element;
            if (!ConfigureHostsDialog.this.detectedIPs.contains(address)) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            return null;
        }

        public String getToolTipText(Object element) {
            Inet4Address address = (Inet4Address)element;
            if (!ConfigureHostsDialog.this.detectedIPs.contains(address)) {
                return PHPDebugCoreMessages.ConfigureHostsDialog_Address_could_not_be_detected;
            }
            return null;
        }
    }

    private class TypeLabelProvider
    extends ColumnLabelProvider {
        private TypeLabelProvider() {
        }

        public String getText(Object element) {
            Inet4Address address = (Inet4Address)element;
            switch (NetworkUtil.getType((Inet4Address)address)) {
                case 1: {
                    return "public";
                }
                case 2: {
                    return "private";
                }
                case 4: {
                    return "localhost";
                }
            }
            return null;
        }

        public String getToolTipText(Object element) {
            Inet4Address address = (Inet4Address)element;
            if (!ConfigureHostsDialog.this.detectedIPs.contains(address)) {
                return PHPDebugCoreMessages.ConfigureHostsDialog_Address_could_not_be_detected;
            }
            return null;
        }
    }
}

