/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.search;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDEManager;

public class PluginJavaSearchUtil {
    public static IPluginModelBase[] getPluginImports(IPluginImport dep) {
        HashSet<IPluginModelBase> set = new HashSet<IPluginModelBase>();
        VersionRange range = new VersionRange(dep.getVersion());
        PluginJavaSearchUtil.collectAllPrerequisites(PluginRegistry.findModel(dep.getId(), range, null), set);
        return set.toArray(new IPluginModelBase[set.size()]);
    }

    public static IPluginModelBase[] getPluginImports(String pluginImportID) {
        HashSet<IPluginModelBase> set = new HashSet<IPluginModelBase>();
        PluginJavaSearchUtil.collectAllPrerequisites(PluginRegistry.findModel(pluginImportID), set);
        return set.toArray(new IPluginModelBase[set.size()]);
    }

    public static void collectAllPrerequisites(IPluginModelBase model, HashSet<IPluginModelBase> set) {
        IPluginImport[] imports;
        if (model == null || !set.add(model)) {
            return;
        }
        IPluginImport[] iPluginImportArray = imports = model.getPluginBase().getImports();
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase child;
            IPluginImport pluginImport = iPluginImportArray[n2];
            if (pluginImport.isReexported() && (child = PluginRegistry.findModel(pluginImport.getId())) != null) {
                PluginJavaSearchUtil.collectAllPrerequisites(child, set);
            }
            ++n2;
        }
    }

    public static IPackageFragment[] collectPackageFragments(IPluginModelBase[] models, IJavaProject parentProject, boolean filterEmptyPackages) throws JavaModelException {
        ArrayList<IPackageFragment> result = new ArrayList<IPackageFragment>();
        IPackageFragmentRoot[] roots = parentProject.getAllPackageFragmentRoots();
        IPluginModelBase[] iPluginModelBaseArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            IResource resource = model.getUnderlyingResource();
            if (resource == null) {
                ArrayList<Path> libraryPaths = new ArrayList<Path>();
                PluginJavaSearchUtil.addLibraryPaths(model, libraryPaths);
                var14_14 = roots;
                var13_13 = roots.length;
                var12_12 = 0;
                while (var12_12 < var13_13) {
                    root = var14_14[var12_12];
                    if (libraryPaths.contains(root.getPath())) {
                        PluginJavaSearchUtil.extractPackageFragments(root, result, filterEmptyPackages);
                    }
                    ++var12_12;
                }
            } else {
                IProject project = resource.getProject();
                var14_14 = roots;
                var13_13 = roots.length;
                var12_12 = 0;
                while (var12_12 < var13_13) {
                    root = var14_14[var12_12];
                    IJavaProject jProject = (IJavaProject)root.getParent();
                    if (jProject.getProject().equals((Object)project)) {
                        PluginJavaSearchUtil.extractPackageFragments(root, result, filterEmptyPackages);
                    }
                    ++var12_12;
                }
            }
            ++n2;
        }
        return result.toArray(new IPackageFragment[result.size()]);
    }

    private static void extractPackageFragments(IPackageFragmentRoot root, ArrayList<IPackageFragment> result, boolean filterEmpty) {
        try {
            IJavaElement[] children;
            IJavaElement[] iJavaElementArray = children = root.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement element = iJavaElementArray[n2];
                IPackageFragment fragment = (IPackageFragment)element;
                if (!filterEmpty || fragment.hasChildren()) {
                    result.add(fragment);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private static void addLibraryPaths(IPluginModelBase model, ArrayList<Path> libraryPaths) {
        int n;
        File file;
        IPluginBase plugin = model.getPluginBase();
        IFragmentModel[] fragments = new IFragmentModel[]{};
        if (plugin instanceof IPlugin) {
            fragments = PDEManager.findFragmentsFor(model);
        }
        if ((file = new File(model.getInstallLocation())).isFile()) {
            libraryPaths.add(new Path(file.getAbsolutePath()));
        } else {
            IPluginLibrary[] libraries;
            IPluginLibrary[] iPluginLibraryArray = libraries = plugin.getLibraries();
            int n2 = libraries.length;
            n = 0;
            while (n < n2) {
                IPluginLibrary library = iPluginLibraryArray[n];
                String libraryName = ClasspathUtilCore.expandLibraryName(library.getName());
                String path = String.valueOf(plugin.getModel().getInstallLocation()) + '/' + libraryName;
                if (new File(path).exists()) {
                    libraryPaths.add(new Path(path));
                } else {
                    PluginJavaSearchUtil.findLibraryInFragments(fragments, libraryName, libraryPaths);
                }
                ++n;
            }
        }
        if (ClasspathUtilCore.hasExtensibleAPI(model)) {
            IFragmentModel[] iFragmentModelArray = fragments;
            n = fragments.length;
            int n3 = 0;
            while (n3 < n) {
                IFragmentModel fragment = iFragmentModelArray[n3];
                PluginJavaSearchUtil.addLibraryPaths(fragment, libraryPaths);
                ++n3;
            }
        }
    }

    private static void findLibraryInFragments(IFragmentModel[] fragments, String libraryName, ArrayList<Path> libraryPaths) {
        IFragmentModel[] iFragmentModelArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            IFragmentModel fragment = iFragmentModelArray[n2];
            String path = String.valueOf(fragment.getInstallLocation()) + '/' + libraryName;
            if (new File(path).exists()) {
                libraryPaths.add(new Path(path));
                break;
            }
            ++n2;
        }
    }

    public static IJavaSearchScope createSeachScope(IJavaProject jProject) throws JavaModelException {
        IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
        ArrayList<IPackageFragmentRoot> filteredRoots = new ArrayList<IPackageFragmentRoot>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getResource() != null && root.getResource().getProject().equals((Object)jProject.getProject())) {
                filteredRoots.add(root);
            }
            ++n2;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])filteredRoots.toArray(new IJavaElement[filteredRoots.size()]));
    }
}

