/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.builder.Reference;
import org.eclipse.pde.api.tools.internal.model.AbstractApiTypeRoot;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiField;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ReferenceExtractor
extends ClassVisitor {
    Set<Reference> collector = null;
    private String classname = null;
    IApiType fType;
    Stack<IApiMember> fMemberStack = new Stack();
    Stack<String> fSuperStack = new Stack();
    HashMap<String, List<Reference>> fAnonymousTypes = new HashMap();
    private boolean fIncludeLocalRefs = false;
    private int fReferenceKinds = 0;
    FieldTracker fieldtracker = null;
    private int fVersion;
    private static final int VISIT_MEMBERS_MASK = 0x7FFFFFFC;
    private boolean fIsVisitMembers = false;
    private ClassFileSignatureVisitor signaturevisitor = new ClassFileSignatureVisitor();
    static int TYPE = 0;
    static int FIELD = 1;
    static int METHOD = 2;
    private ClassFileFieldVisitor fieldvisitor = new ClassFileFieldVisitor();

    public ReferenceExtractor(IApiType type, Set<Reference> collector, int referenceKinds) {
        super(589824, (ClassVisitor)new ClassNode());
        this.fType = type;
        this.collector = collector;
        this.fReferenceKinds = referenceKinds;
        this.fIsVisitMembers = (0x7FFFFFFC & this.fReferenceKinds) != 0;
        this.fieldtracker = new FieldTracker(this);
    }

    protected ReferenceExtractor(IApiType type, Set<Reference> collector, int referenceKinds, FieldTracker tracker) {
        super(589824, (ClassVisitor)new ClassNode());
        this.fType = type;
        this.collector = collector;
        this.fReferenceKinds = referenceKinds;
        this.fIsVisitMembers = (0x7FFFFFFC & this.fReferenceKinds) != 0;
        this.fieldtracker = tracker;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Reference extractor for: ");
        buffer.append(this.fType.getName());
        buffer.append("\n");
        buffer.append("Reference kinds: ");
        buffer.append(Reference.getReferenceText(this.fReferenceKinds));
        buffer.append("\n");
        buffer.append("Is visiting members: ");
        buffer.append(this.fIsVisitMembers);
        return buffer.toString();
    }

    protected boolean consider(String owner) {
        if (this.fIncludeLocalRefs) {
            return true;
        }
        return !this.classname.equals(owner) && !this.classname.startsWith(owner) && !"<clinit>".equals(owner) && !"this".equals(owner);
    }

    protected boolean consider(Reference ref) {
        int kind = ref.getReferenceKind();
        if ((kind & this.fReferenceKinds) == 0) {
            return false;
        }
        if (this.fIncludeLocalRefs) {
            return true;
        }
        String referencedTypeName = ref.getReferencedTypeName();
        if (kind == 256 || kind == 0x10000000 || kind == 8192 || kind == 16384) {
            return true;
        }
        if (referencedTypeName.startsWith(this.fType.getName())) {
            if (referencedTypeName.length() > this.fType.getName().length()) {
                return referencedTypeName.charAt(this.fType.getName().length()) != '$';
            }
            return false;
        }
        return true;
    }

    protected String processName(String name) {
        String newname = name;
        Type type = Type.getObjectType((String)name);
        if (type != null && type.getSort() == 10) {
            newname = type.getInternalName();
        }
        return newname.replace('/', '.');
    }

    protected Reference addTypeReference(Type type, int kind) {
        Type rtype = this.resolveType(type.getDescriptor());
        if (rtype != null) {
            return this.addReference(Reference.typeReference(this.getMember(), rtype.getClassName(), kind));
        }
        return null;
    }

    protected Reference addFieldReference(Type declaringType, String name, int kind) {
        Type rtype = this.resolveType(declaringType.getDescriptor());
        if (rtype != null) {
            return this.addReference(Reference.fieldReference(this.getMember(), rtype.getClassName(), name, kind));
        }
        return null;
    }

    protected Reference addMethodReference(Type declaringType, String name, String signature, int kind, int flags) {
        Type rtype = this.resolveType(declaringType.getDescriptor());
        if (rtype != null) {
            return this.addReference(Reference.methodReference(this.getMember(), rtype.getClassName(), name, signature, kind, flags));
        }
        return null;
    }

    protected Reference addReference(Reference target) {
        if (this.consider(target)) {
            this.collector.add(target);
            return target;
        }
        return null;
    }

    protected List<Reference> processSignature(String name, String signature, int kind, int type) {
        SignatureReader reader = new SignatureReader(signature);
        this.signaturevisitor.kind = kind;
        this.signaturevisitor.name = this.processName(name);
        this.signaturevisitor.signature = signature;
        this.signaturevisitor.originalkind = kind;
        this.signaturevisitor.argumentcount = 0;
        this.signaturevisitor.type = type;
        if (kind == 0x200000 || kind == 0x800000) {
            reader.accept((SignatureVisitor)this.signaturevisitor);
        } else {
            reader.acceptType((SignatureVisitor)this.signaturevisitor);
        }
        ArrayList<Reference> result = new ArrayList<Reference>();
        result.addAll(this.signaturevisitor.references);
        this.collector.addAll(this.signaturevisitor.references);
        this.signaturevisitor.reset();
        return result;
    }

    protected Type resolveType(String desc) {
        Type type = Type.getType((String)desc);
        if (type.getSort() == 10) {
            return type;
        }
        if (type.getSort() == 9 && (type = type.getElementType()).getSort() == 10) {
            return type;
        }
        return null;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.fVersion = version;
        this.classname = this.processName(name);
        if (ApiPlugin.DEBUG_REFERENCE_EXTRACTOR) {
            System.out.println("Starting visit of type: [" + this.fType.getName() + "]");
        }
        this.enterMember(this.fType);
        if (signature != null) {
            this.processSignature(name, signature, 0x200000, TYPE);
        } else if ((access & 0x200) != 0) {
            Type supertype = null;
            String[] stringArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                String interfaceName = stringArray[n2];
                supertype = Type.getObjectType((String)interfaceName);
                this.addTypeReference(supertype, 1);
                this.fSuperStack.add(supertype.getClassName());
                ++n2;
            }
        } else {
            Type supertype = null;
            if (superName != null) {
                supertype = Type.getObjectType((String)superName);
                this.addTypeReference(supertype, 1);
                this.fSuperStack.add(supertype.getClassName());
            }
            String[] stringArray = interfaces;
            int n = interfaces.length;
            int n3 = 0;
            while (n3 < n) {
                String interfaceName = stringArray[n3];
                supertype = Type.getObjectType((String)interfaceName);
                this.addTypeReference(supertype, 2);
                ++n3;
            }
        }
    }

    public void visitEnd() {
        this.exitMember();
        if (!this.fSuperStack.isEmpty()) {
            String typeName = this.fSuperStack.pop();
            if (ApiPlugin.DEBUG_REFERENCE_EXTRACTOR) {
                System.out.println("ending visit of type: [" + typeName + "]");
            }
        }
        if (!this.fType.isMemberType()) {
            this.fieldtracker.resolveSyntheticFields();
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.fIsVisitMembers) {
            IApiType owner = (IApiType)this.getMember();
            IApiField field = owner.getField(name);
            if (field == null) {
                ApiPlugin.log(Status.warning((String)NLS.bind((String)BuilderMessages.ReferenceExtractor_failed_to_lookup_field, (Object)name, (Object)Signatures.getQualifiedTypeSignature(owner))));
                return null;
            }
            this.enterMember(field);
            if ((access & 0x1000) == 0) {
                if (signature != null) {
                    this.processSignature(name, signature, 0x400000, FIELD);
                } else {
                    this.addTypeReference(Type.getType((String)desc), 4);
                }
            } else {
                this.fieldtracker.addField(this.addTypeReference(Type.getType((String)desc), 4));
            }
            return this.fieldvisitor;
        }
        return null;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        String pname = this.processName(name);
        try {
            if (this.fType.getName().equals(pname) || !pname.startsWith(this.fType.getName())) {
                return;
            }
            IApiComponent comp = this.fType.getApiComponent();
            if (comp == null) {
                return;
            }
            AbstractApiTypeRoot root = (AbstractApiTypeRoot)comp.findTypeRoot(pname);
            if (root != null) {
                IApiType type = root.getStructure();
                if (type == null) {
                    return;
                }
                Set<Reference> refs = this.processInnerClass(type, this.fReferenceKinds);
                if (type.isAnonymous() || type.isLocal()) {
                    ArrayList<Reference> allRefs = new ArrayList<Reference>();
                    for (Reference reference : refs) {
                        if (reference.getLineNumber() >= 0) continue;
                        allRefs.add(reference);
                    }
                    this.fAnonymousTypes.put(pname, allRefs);
                }
                if (refs != null && !refs.isEmpty()) {
                    this.collector.addAll(refs);
                }
            }
        }
        catch (CoreException ce) {
            ApiPlugin.log("Failed to compute types for " + pname, ce);
        }
    }

    private Set<Reference> processInnerClass(IApiType type, int refkinds) throws CoreException {
        HashSet<Reference> refs = new HashSet<Reference>();
        ReferenceExtractor extractor = new ReferenceExtractor(type, refs, refkinds, this.fieldtracker);
        ClassReader reader = new ClassReader(((AbstractApiTypeRoot)type.getTypeRoot()).getContents());
        reader.accept((ClassVisitor)extractor, 4);
        return refs;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        try {
            this.addTypeReference(Type.getType((String)desc), 0x40000000);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.fIsVisitMembers) {
            MethodVisitor mv;
            IApiMember member = this.getMember();
            IApiType owner = null;
            if (member instanceof IApiType) {
                owner = (IApiType)member;
            } else {
                try {
                    owner = member.getEnclosingType();
                }
                catch (CoreException e) {
                    ApiPlugin.log(e.getStatus());
                }
            }
            if (owner == null) {
                return null;
            }
            IApiMethod method = owner.getMethod(name, desc);
            if (method == null) {
                ApiPlugin.log(Status.warning((String)NLS.bind((String)BuilderMessages.ReferenceExtractor_failed_to_lookup_method, (Object[])new String[]{name, desc, Signatures.getQualifiedTypeSignature(owner)})));
                return null;
            }
            this.enterMember(method);
            if ((access & 5) > 0) {
                try {
                    IApiElement def = null;
                    if (this.fVersion >= 52 && !"<init>".equals(name)) {
                        def = ReferenceExtractor.getDefaultDefined(owner, name, desc, true);
                    }
                    if (def != null) {
                        this.addReference(Reference.methodReference(method, def.getName(), method.getName(), method.getSignature(), 0x10000000, 2));
                    } else if (!this.fSuperStack.isEmpty()) {
                        String superTypeName = this.fSuperStack.peek();
                        this.addReference(Reference.methodReference(method, superTypeName, method.getName(), method.getSignature(), 0x10000000));
                    }
                }
                catch (CoreException coreException) {}
            }
            int argumentcount = 0;
            if ((access & 0x1000) == 0) {
                if (signature != null) {
                    this.processSignature(name, signature, 0x800000, METHOD);
                    argumentcount = this.signaturevisitor.argumentcount;
                } else {
                    Type[] arguments;
                    Object[] objectArray = arguments = Type.getArgumentTypes((String)desc);
                    int n = arguments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Type type = objectArray[n2];
                        this.addTypeReference(type, 16);
                        argumentcount += type.getSize();
                        ++n2;
                    }
                    this.addTypeReference(Type.getReturnType((String)desc), 8);
                    if (exceptions != null) {
                        objectArray = exceptions;
                        n = exceptions.length;
                        n2 = 0;
                        while (n2 < n) {
                            Type exception = objectArray[n2];
                            this.addTypeReference(Type.getObjectType((String)exception), 32);
                            ++n2;
                        }
                    }
                }
            }
            if ((mv = super.visitMethod(access, name, desc, signature, exceptions)) != null && (access & 0x500) == 0) {
                return new ClassFileMethodVisitor(mv, name, argumentcount);
            }
        }
        return null;
    }

    protected void enterMember(IApiMember member) {
        this.fMemberStack.push(member);
    }

    protected void exitMember() {
        this.fMemberStack.pop();
    }

    protected IApiMember getMember() {
        return this.fMemberStack.peek();
    }

    static IApiType getDefaultDefined(IApiType type, String name, String signature, boolean isOverride) throws CoreException {
        if (type != null) {
            IApiType[] ints;
            IApiMethod method;
            if (!isOverride && (method = type.getMethod(name, signature)) != null && method.isDefaultMethod()) {
                return type;
            }
            IApiType superclass = ReferenceExtractor.getDefaultDefined(type.getSuperclass(), name, signature, false);
            if (superclass != null) {
                return superclass;
            }
            IApiType[] iApiTypeArray = ints = type.getSuperInterfaces();
            int n = ints.length;
            int n2 = 0;
            while (n2 < n) {
                IApiType j = iApiTypeArray[n2];
                IApiType superint = ReferenceExtractor.getDefaultDefined(j, name, signature, false);
                if (superint != null) {
                    return superint;
                }
                ++n2;
            }
        }
        return null;
    }

    class ClassFileFieldVisitor
    extends FieldVisitor {
        ClassFileFieldVisitor() {
            super(589824);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            ReferenceExtractor.this.addTypeReference(Type.getType((String)desc), 0x40000000);
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
            ReferenceExtractor.this.exitMember();
        }
    }

    class ClassFileMethodVisitor
    extends MethodVisitor {
        int argumentcount;
        LinePositionTracker linePositionTracker;
        String stringLiteral;
        String methodName;
        int lastLineNumber;
        boolean implicitConstructor;
        LocalLineNumberMarker localVariableMarker;
        HashMap<Label, List<LocalLineNumberMarker>> labelsToLocalMarkers;

        public ClassFileMethodVisitor(MethodVisitor mv, String name, int argumentcount) {
            super(589824, mv);
            this.argumentcount = 0;
            this.implicitConstructor = false;
            this.argumentcount = argumentcount;
            this.linePositionTracker = new LinePositionTracker();
            this.lastLineNumber = -1;
            this.labelsToLocalMarkers = new HashMap();
            this.methodName = name;
        }

        public void visitEnd() {
            this.implicitConstructor = false;
            this.argumentcount = 0;
            ReferenceExtractor.this.exitMember();
            this.linePositionTracker.computeLineNumbers();
            this.labelsToLocalMarkers = null;
        }

        public void visitVarInsn(int opcode, int var) {
            this.stringLiteral = null;
            if (opcode == 58 && this.lastLineNumber != -1) {
                this.localVariableMarker = new LocalLineNumberMarker(this.lastLineNumber, var);
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            Reference reference;
            int refType;
            switch (opcode) {
                case 179: {
                    int n = 4096;
                    break;
                }
                case 181: {
                    int n = 16384;
                    break;
                }
                case 178: {
                    int n = 2048;
                    break;
                }
                case 180: {
                    int n = 8192;
                    break;
                }
                default: {
                    int n = refType = -1;
                }
            }
            if (refType != -1 && (reference = ReferenceExtractor.this.addFieldReference(Type.getObjectType((String)owner), name, refType)) != null) {
                this.linePositionTracker.addLocation(reference);
                if (refType == 8192 || refType == 16384) {
                    ReferenceExtractor.this.fieldtracker.addField(reference);
                }
            }
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            Type ctype;
            Reference reference;
            if (type != null && (reference = ReferenceExtractor.this.addTypeReference(ctype = Type.getObjectType((String)type), 131072)) != null) {
                this.linePositionTracker.addCatchLabelInfos(reference, handler);
                this.linePositionTracker.addLocation(reference);
            }
        }

        public void visitLabel(Label label) {
            this.linePositionTracker.addLabel(label);
            if (this.localVariableMarker != null) {
                List<LocalLineNumberMarker> list = this.labelsToLocalMarkers.get(label);
                if (list != null) {
                    list.add(this.localVariableMarker);
                } else {
                    list = new ArrayList<LocalLineNumberMarker>();
                    list.add(this.localVariableMarker);
                    this.labelsToLocalMarkers.put(label, list);
                }
                this.localVariableMarker = null;
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean inf) {
            Reference reference;
            Type declaringType = Type.getObjectType((String)owner);
            int kind = -1;
            int flags = 0;
            switch (opcode) {
                case 183: {
                    int n = kind = "<init>".equals(name) ? 64 : 0x100000;
                    if (kind != 64) break;
                    if (!this.implicitConstructor && this.methodName.equals("<init>") && !ReferenceExtractor.this.fSuperStack.isEmpty() && ReferenceExtractor.this.fSuperStack.peek().equals(declaringType.getClassName())) {
                        this.implicitConstructor = true;
                        kind = 0x20000000;
                        break;
                    }
                    reference = ReferenceExtractor.this.addTypeReference(declaringType, 0x8000000);
                    if (reference == null) break;
                    this.linePositionTracker.addLocation(reference);
                    break;
                }
                case 184: {
                    kind = 128;
                    if (!name.equals("forName") || !ReferenceExtractor.this.processName(owner).equals("java.lang.Class") || this.stringLiteral == null) break;
                    try {
                        Type classLiteral = Type.getObjectType((String)this.stringLiteral);
                        Reference reference2 = ReferenceExtractor.this.addTypeReference(classLiteral, 0x4000000);
                        if (reference2 == null) break;
                        this.linePositionTracker.addLocation(reference2);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 182: {
                    IApiMember member;
                    kind = 256;
                    if (ReferenceExtractor.this.fVersion < 52 || (member = ReferenceExtractor.this.getMember()) == null) break;
                    try {
                        IApiType type;
                        IApiComponent comp = ReferenceExtractor.this.fType.getApiComponent();
                        if (comp == null) break;
                        String owner_sig = ReferenceExtractor.this.processName(owner);
                        AbstractApiTypeRoot root = (AbstractApiTypeRoot)comp.findTypeRoot(owner_sig);
                        if (root == null) {
                            IApiComponent[] comps;
                            IApiBaseline baseline = comp.getBaseline();
                            IApiComponent[] iApiComponentArray = comps = baseline.resolvePackage(comp, Signatures.getPackageName(owner_sig));
                            int n = comps.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IApiComponent c = iApiComponentArray[n2];
                                root = (AbstractApiTypeRoot)c.findTypeRoot(owner_sig);
                                if (root != null) break;
                                ++n2;
                            }
                        }
                        if (root == null || (type = root.getStructure()) == null || "<init>".equals(name) || ReferenceExtractor.getDefaultDefined(type, name, desc, false) == null) break;
                        flags = 2;
                    }
                    catch (CoreException coreException) {}
                    break;
                }
                case 185: {
                    kind = 512;
                    break;
                }
            }
            if (kind != -1 && (reference = ReferenceExtractor.this.addMethodReference(declaringType, name, desc, kind, flags)) != null) {
                this.linePositionTracker.addLocation(reference);
                if (kind == 128) {
                    ReferenceExtractor.this.fieldtracker.addAccessor(reference);
                }
            }
            this.stringLiteral = null;
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            Object[] objectArray = bsmArgs;
            int n = bsmArgs.length;
            int n2 = 0;
            while (n2 < n) {
                Handle handle;
                Type declaringType;
                Reference reference;
                Object arg = objectArray[n2];
                if (arg instanceof Handle && (reference = ReferenceExtractor.this.addMethodReference(declaringType = Type.getObjectType((String)(handle = (Handle)arg).getOwner()), handle.getName(), handle.getDesc(), 256, 0)) != null) {
                    this.linePositionTracker.addLocation(reference);
                }
                ++n2;
            }
        }

        public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return null;
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            Type type = this.getTypeFromDescription(desc);
            Reference reference = ReferenceExtractor.this.addTypeReference(type, 32768);
            if (reference != null) {
                this.linePositionTracker.addLocation(reference);
            }
        }

        public void visitLineNumber(int line, Label start) {
            this.lastLineNumber = line;
            this.linePositionTracker.addLineInfo(line, start);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Method visitor for: ");
            buffer.append(this.methodName);
            buffer.append("\nCurrent line number: ");
            buffer.append(this.lastLineNumber);
            return buffer.toString();
        }

        private Type getTypeFromDescription(String desc) {
            String ldesc = desc;
            while (ldesc.charAt(0) == '[') {
                ldesc = ldesc.substring(1);
            }
            Type type = null;
            type = ldesc.endsWith(";") ? Type.getType((String)ldesc) : Type.getObjectType((String)ldesc);
            return type;
        }

        public void visitTypeInsn(int opcode, String desc) {
            Reference reference;
            Type type = this.getTypeFromDescription(desc);
            int kind = -1;
            switch (opcode) {
                case 189: {
                    kind = 32768;
                    break;
                }
                case 192: {
                    kind = 262144;
                    break;
                }
                case 193: {
                    kind = 524288;
                    break;
                }
                case 187: {
                    List<Reference> refs = ReferenceExtractor.this.fAnonymousTypes.get(ReferenceExtractor.this.processName(type.getInternalName()));
                    if (refs == null) break;
                    for (Reference reference2 : refs) {
                        this.linePositionTracker.addLocation(reference2);
                    }
                    break;
                }
            }
            if (kind != -1 && (reference = ReferenceExtractor.this.addTypeReference(type, kind)) != null) {
                this.linePositionTracker.addLocation(reference);
            }
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (desc.length() == 1) {
                return;
            }
            if (index > this.argumentcount) {
                List<LocalLineNumberMarker> list = this.labelsToLocalMarkers.get(start);
                int lineNumber = -1;
                if (list != null) {
                    LocalLineNumberMarker removeMarker = null;
                    for (LocalLineNumberMarker marker : list) {
                        if (marker.varIndex != index) continue;
                        lineNumber = marker.lineNumber;
                        removeMarker = marker;
                        break;
                    }
                    if (removeMarker != null) {
                        list.remove(removeMarker);
                        if (list.isEmpty()) {
                            this.labelsToLocalMarkers.remove(start);
                        }
                    }
                }
                if (lineNumber == -1) {
                    return;
                }
                if (signature != null) {
                    List<Reference> references = ReferenceExtractor.this.processSignature(name, signature, 0x1000000, METHOD);
                    for (Reference reference : references) {
                        reference.setLineNumber(lineNumber);
                    }
                } else {
                    Reference reference;
                    Type type = Type.getType((String)desc);
                    if (type.getSort() == 10 && (reference = ReferenceExtractor.this.addTypeReference(type, 0x2000000)) != null) {
                        reference.setLineNumber(lineNumber);
                    }
                }
            }
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                Type type = (Type)cst;
                Reference reference = ReferenceExtractor.this.addTypeReference(type, 0x4000000);
                if (reference != null) {
                    this.linePositionTracker.addLocation(reference);
                }
            } else if (cst instanceof String) {
                String str = (String)cst;
                this.stringLiteral = "".equals(str) ? null : str;
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            Type ctype = this.getTypeFromDescription(desc);
            Reference reference = ReferenceExtractor.this.addTypeReference(ctype, 0x40000000);
            if (reference != null) {
                this.linePositionTracker.addLocation(reference);
            }
            return null;
        }
    }

    class ClassFileSignatureVisitor
    extends SignatureVisitor {
        protected int kind;
        protected int originalkind;
        protected int argumentcount;
        protected int type;
        protected String signature;
        protected String name;
        protected List<Reference> references;

        public ClassFileSignatureVisitor() {
            super(589824);
            this.kind = -1;
            this.originalkind = -1;
            this.argumentcount = 0;
            this.type = 0;
            this.signature = null;
            this.name = null;
            this.references = new ArrayList<Reference>();
        }

        protected void reset() {
            this.kind = -1;
            this.originalkind = -1;
            this.name = null;
            this.signature = null;
            this.type = 0;
            this.references.clear();
        }

        protected void processType(String name) {
            Type type = ReferenceExtractor.this.resolveType(Type.getObjectType((String)name).getDescriptor());
            if (type != null) {
                String tname = type.getClassName();
                if (tname.equals("E") || tname.equals("T")) {
                    type = Type.getObjectType((String)"java.lang.Object");
                    tname = type.getClassName();
                }
                if (ReferenceExtractor.this.consider(tname) && this.kind != -1 && this.name != null && this.signature != null) {
                    this.references.add(Reference.typeReference(ReferenceExtractor.this.getMember(), tname, this.signature, this.kind));
                }
            }
            this.kind = this.originalkind;
        }

        public void visitClassType(String name) {
            this.processType(name);
        }

        public void visitFormalTypeParameter(String name) {
            if (this.type != TYPE) {
                this.processType(name);
            }
        }

        public void visitTypeVariable(String name) {
        }

        public void visitInnerClassType(String name) {
            this.processType(name);
        }

        public SignatureVisitor visitParameterType() {
            ++this.argumentcount;
            this.kind = 16;
            return this;
        }

        public SignatureVisitor visitInterface() {
            this.kind = 2;
            return this;
        }

        public SignatureVisitor visitExceptionType() {
            this.kind = 32;
            return this;
        }

        public SignatureVisitor visitArrayType() {
            return this;
        }

        public SignatureVisitor visitReturnType() {
            this.kind = 8;
            return this;
        }

        public SignatureVisitor visitClassBound() {
            this.kind = 0x200000;
            return this;
        }

        public SignatureVisitor visitInterfaceBound() {
            this.kind = 0x200000;
            return this;
        }

        public SignatureVisitor visitSuperclass() {
            this.kind = 1;
            return this;
        }

        public SignatureVisitor visitTypeArgument(char wildcard) {
            return this;
        }

        public void visitEnd() {
        }

        public void visitBaseType(char descriptor) {
            ++this.argumentcount;
            if (descriptor == 'J' || descriptor == 'D') {
                ++this.argumentcount;
            }
        }

        public void visitTypeArgument() {
        }
    }

    static class FieldTracker {
        HashMap<String, List<Reference>> accessors = new HashMap();
        ArrayList<Reference> fields = new ArrayList();
        ReferenceExtractor extractor = null;

        public FieldTracker(ReferenceExtractor extractor) {
            this.extractor = extractor;
        }

        public void addField(Reference ref) {
            if (ref != null) {
                this.fields.add(ref);
            }
        }

        public void addAccessor(Reference ref) {
            if (ref != null) {
                String key = ref.getReferencedMemberName();
                List<Reference> refs = this.accessors.get(key);
                if (refs == null) {
                    refs = new ArrayList<Reference>();
                    this.accessors.put(key, refs);
                }
                refs.add(ref);
            }
        }

        public void resolveSyntheticFields() {
            for (Reference field : this.fields) {
                List<Reference> refs = this.accessors.get(field.getMember().getName());
                if (refs == null) continue;
                for (Reference accessor : refs) {
                    Reference refer = Reference.fieldReference(accessor.getMember(), field.getReferencedTypeName(), field.getReferencedMemberName(), field.getReferenceKind());
                    refer.setLineNumber(accessor.getLineNumber());
                    this.extractor.collector.add(refer);
                }
                this.extractor.collector.remove(field);
            }
        }
    }

    static class LabelInfo {
        public Reference location;
        public Label label;

        public LabelInfo(Reference location, Label label) {
            this.location = location;
            this.label = label;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('(').append(this.label).append(',').append(this.location).append(')');
            return String.valueOf(buffer);
        }
    }

    static class LineInfo
    implements Comparable<Object> {
        int line;
        Label label;

        LineInfo(int line, Label label) {
            this.line = line;
            this.label = label;
        }

        @Override
        public int compareTo(Object o) {
            return this.line - ((LineInfo)o).line;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LineInfo) {
                LineInfo lineInfo2 = (LineInfo)obj;
                return this.line == lineInfo2.line && this.label.equals(lineInfo2.label);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.line + (this.label != null ? this.label.hashCode() : 0);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('(').append(this.line).append(',').append(this.label).append(')');
            return String.valueOf(buffer);
        }
    }

    static class LinePositionTracker {
        List<Object> labelsAndLocations = new ArrayList<Object>();
        SortedSet<LineInfo> lineInfos = new TreeSet<LineInfo>();
        List<LabelInfo> catchLabelInfos = new ArrayList<LabelInfo>();
        HashMap<Label, Integer> lineMap = new HashMap();

        void addLocation(Reference location) {
            this.labelsAndLocations.add(location);
        }

        void addLineInfo(int line, Label label) {
            this.lineInfos.add(new LineInfo(line, label));
            this.lineMap.put(label, line);
        }

        void addCatchLabelInfos(Reference location, Label label) {
            this.catchLabelInfos.add(new LabelInfo(location, label));
        }

        void addLabel(Label label) {
            this.labelsAndLocations.add(label);
        }

        public void computeLineNumbers() {
            if (this.lineInfos.size() < 1 || this.labelsAndLocations.size() < 1) {
                return;
            }
            Iterator lineInfosIterator = this.lineInfos.iterator();
            LineInfo firstLineInfo = (LineInfo)lineInfosIterator.next();
            int currentLineNumber = firstLineInfo.line;
            ArrayList<LabelInfo> remainingCatchLabelInfos = new ArrayList<LabelInfo>();
            for (LabelInfo catchLabelInfo : this.catchLabelInfos) {
                Integer n = this.lineMap.get(catchLabelInfo.label);
                if (n != null) {
                    catchLabelInfo.location.setLineNumber(n);
                    continue;
                }
                remainingCatchLabelInfos.add(catchLabelInfo);
            }
            ArrayList<Object> computedEntries = new ArrayList<Object>();
            for (Object object : this.labelsAndLocations) {
                if (object instanceof Label) {
                    Integer lineValue = this.lineMap.get(object);
                    if (lineValue != null) {
                        computedEntries.add(new LineInfo(lineValue, (Label)object));
                        continue;
                    }
                    computedEntries.add(object);
                    continue;
                }
                computedEntries.add(object);
            }
            for (Object e : computedEntries) {
                if (e instanceof Label) {
                    if (remainingCatchLabelInfos == null) continue;
                    ArrayList<LabelInfo> arrayList = new ArrayList<LabelInfo>();
                    for (LabelInfo catchLabelInfo : remainingCatchLabelInfos) {
                        if (!e.equals(catchLabelInfo.label)) {
                            arrayList.add(catchLabelInfo);
                            continue;
                        }
                        catchLabelInfo.location.setLineNumber(currentLineNumber);
                    }
                    if (arrayList.isEmpty()) {
                        remainingCatchLabelInfos = null;
                        continue;
                    }
                    remainingCatchLabelInfos = arrayList;
                    continue;
                }
                if (e instanceof Reference) {
                    Reference ref = (Reference)e;
                    if (ref.getLineNumber() == -1) {
                        ref.setLineNumber(currentLineNumber);
                        continue;
                    }
                    currentLineNumber = ref.getLineNumber();
                    continue;
                }
                if (!(e instanceof LineInfo)) continue;
                LineInfo lineInfo = (LineInfo)e;
                currentLineNumber = lineInfo.line;
            }
        }
    }

    static class LocalLineNumberMarker {
        int lineNumber;
        int varIndex;

        public LocalLineNumberMarker(int line, int varIndex) {
            this.lineNumber = line;
            this.varIndex = varIndex;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LocalLineNumberMarker) {
                LocalLineNumberMarker marker = (LocalLineNumberMarker)obj;
                return this.lineNumber == marker.lineNumber && this.varIndex == marker.varIndex;
            }
            return false;
        }

        public int hashCode() {
            return this.varIndex;
        }
    }
}

