/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.viewersearch.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.services.viewersearch.Activator;
import org.eclipse.papyrus.infra.services.viewersearch.IExtendedViewerSearcher;
import org.eclipse.papyrus.infra.services.viewersearch.IViewerSearcher;
import org.eclipse.papyrus.infra.services.viewersearch.Messages;
import org.eclipse.papyrus.infra.services.viewersearch.impl.AbstractViewerSearcher;

public class ViewerSearchService
extends AbstractViewerSearcher
implements IService {
    public static final String EXTENSION_ID = "org.eclipse.papyrus.infra.services.viewersearch.viewerSearcher";
    public static final String VIEWER_SEARCHER_ID = "id";
    public static final String VIEWER_SEARCHER_CLASS = "class";
    private final Map<String, IViewerSearcher> viewerSearchers = new HashMap<String, IViewerSearcher>();

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
    }

    public void startService() throws ServiceException {
        IConfigurationElement[] configurations = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        this.readViewerSearchers(configurations);
    }

    private void readViewerSearchers(IConfigurationElement[] configurations) {
        this.viewerSearchers.clear();
        IConfigurationElement[] iConfigurationElementArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            try {
                if ("viewerSearcher".equals(config.getName())) {
                    String viewerSearcherId = config.getAttribute(VIEWER_SEARCHER_ID);
                    if (viewerSearcherId == null) {
                        Activator.log.warn(String.valueOf(Messages.ViewerSearcherService_2) + config.getContributor() + Messages.ViewerSearcherService_3 + EXTENSION_ID + Messages.ViewerSearcherService_4 + VIEWER_SEARCHER_ID + Messages.ViewerSearcherService_5);
                    } else {
                        IViewerSearcher viewerSearcherClass = (IViewerSearcher)config.createExecutableExtension(VIEWER_SEARCHER_CLASS);
                        if (viewerSearcherClass == null) {
                            Activator.log.warn(String.valueOf(Messages.ViewerSearcherService_6) + config.getContributor() + Messages.ViewerSearcherService_7 + EXTENSION_ID + Messages.ViewerSearcherService_8 + VIEWER_SEARCHER_CLASS + Messages.ViewerSearcherService_9);
                        } else if (this.viewerSearchers.containsKey(viewerSearcherId)) {
                            Activator.log.warn(String.valueOf(Messages.ViewerSearcherService_10) + viewerSearcherId + Messages.ViewerSearcherService_11);
                        } else {
                            this.viewerSearchers.put(viewerSearcherId, viewerSearcherClass);
                        }
                    }
                }
            }
            catch (Exception ex) {
                Activator.log.error("The plugin " + config.getContributor() + " contributed an invalid extension for " + EXTENSION_ID, (Throwable)ex);
            }
            ++n2;
        }
    }

    public void disposeService() throws ServiceException {
        this.viewerSearchers.clear();
    }

    @Override
    public Map<Object, Map<Object, Object>> getViewers(Collection<Object> modelElements, Collection<ModelSet> models) {
        HashMap<Object, Map<Object, Object>> results = new HashMap<Object, Map<Object, Object>>();
        for (String key : this.viewerSearchers.keySet()) {
            IViewerSearcher viewerSearcher = this.viewerSearchers.get(key);
            Map<Object, Map<Object, Object>> subResults = viewerSearcher.getViewers(modelElements, models);
            if (subResults == null) continue;
            for (Object viewer : subResults.keySet()) {
                if (results.containsKey(viewer)) {
                    Map<Object, Object> viewMappings = subResults.get(viewer);
                    Map resultViewMappings = (Map)results.get(viewer);
                    resultViewMappings.putAll(viewMappings);
                    continue;
                }
                results.put(viewer, subResults.get(viewer));
            }
        }
        return results;
    }

    @Override
    public List<Object> getViewersInCurrentModel(EObject element, EObject container, boolean pagesOnly, boolean openPagesOnly) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (String key : this.viewerSearchers.keySet()) {
            List<Object> subResults;
            IViewerSearcher viewerSearcher = this.viewerSearchers.get(key);
            if (!(viewerSearcher instanceof IExtendedViewerSearcher) || (subResults = ((IExtendedViewerSearcher)viewerSearcher).getViewersInCurrentModel(element, container, pagesOnly, openPagesOnly)) == null) continue;
            for (Object object : subResults) {
                if (results.contains(object)) continue;
                results.add(object);
            }
        }
        return results;
    }
}

