/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.service.palette;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.IPaletteProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.messages.Messages;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.ExtendedPluginPaletteProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.IPaletteDescription;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.Activator;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.PaletteconfigurationPackage;

public class WorkspaceExtendedPaletteProvider
extends ExtendedPluginPaletteProvider
implements IPaletteProvider {
    protected boolean loadResourceExceptionLogged = false;

    public void setContributions(IPaletteDescription description) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Object paletteContributions = description.getContributions();
        this.contributions = Collections.emptyList();
        if (!(paletteContributions instanceof String)) {
            return;
        }
        Resource resource = this.loadResourceFromWorkspace((String)paletteContributions, (ResourceSet)resourceSet);
        if (resource != null) {
            try {
                resource.load(Collections.emptyMap());
                if (resource.getContents().size() > 0) {
                    this.contributions = new ArrayList(EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)PaletteconfigurationPackage.eINSTANCE.getPaletteConfiguration()));
                }
            }
            catch (IOException e) {
                if (!this.loadResourceExceptionLogged) {
                    Activator.log.debug(String.valueOf(Messages.WorkspaceExtendedPaletteProvider_ImpossibleToReadResourcePalette) + description);
                    this.loadResourceExceptionLogged = true;
                }
                this.contributions = Collections.emptyList();
            }
        }
    }
}

