/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.helper;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconcilersReader;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramVersioningUtils;

public class ReconcileHelper {
    private final TransactionalEditingDomain domain;
    private static final String ALL_DIAGRAMS = "AllDiagrams";

    public ReconcileHelper(TransactionalEditingDomain domain) {
        this.domain = domain;
    }

    public void reconcileDiagram(Diagram diagram) throws CoreException {
        CompositeCommand migration = this.buildReconcileCommand(diagram);
        if (migration == null) {
            return;
        }
        migration.add((IUndoableOperation)DiagramVersioningUtils.createStampCurrentVersionCommand(diagram));
        try {
            GMFUnsafe.write((TransactionalEditingDomain)this.domain, (ICommand)migration);
        }
        catch (ExecutionException e) {
            this.handleReconcileException(diagram, (Exception)((Object)e));
        }
        catch (InterruptedException e) {
            this.handleReconcileException(diagram, e);
        }
        catch (RollbackException e) {
            this.handleReconcileException(diagram, (Exception)((Object)e));
        }
    }

    protected CompositeCommand buildReconcileCommand(Diagram diagram) {
        CompositeCommand reconcileCommand = new CompositeCommand("Reconciling");
        if (!DiagramVersioningUtils.isOfCurrentPapyrusVersion(diagram)) {
            String sourceVersion = DiagramVersioningUtils.getCompatibilityVersion((View)diagram);
            Map<String, Collection<DiagramReconciler>> diagramReconcilers = DiagramReconcilersReader.getInstance().load();
            String diagramType = diagram.getType();
            LinkedList<DiagramReconciler> reconcilers = new LinkedList<DiagramReconciler>();
            if (diagramReconcilers.containsKey(diagramType)) {
                reconcilers.addAll(diagramReconcilers.get(diagramType));
            }
            if (diagramReconcilers.containsKey(ALL_DIAGRAMS)) {
                reconcilers.addAll(diagramReconcilers.get(ALL_DIAGRAMS));
            }
            boolean someFailed = false;
            Iterator reconciler = reconcilers.iterator();
            while (reconciler.hasNext() && !someFailed) {
                ICommand nextCommand;
                DiagramReconciler next = (DiagramReconciler)reconciler.next();
                if (!next.canReconcileFrom(diagram, sourceVersion) || (nextCommand = next.getReconcileCommand(diagram)) == null) continue;
                if (nextCommand.canExecute()) {
                    reconcileCommand.add((IUndoableOperation)nextCommand);
                    continue;
                }
                Activator.log.error("Diagram reconciler " + next + " failed to reconcile diagram : " + diagram, null);
                someFailed = true;
            }
            if (someFailed) {
                reconcileCommand = null;
            }
        }
        return reconcileCommand;
    }

    protected void handleReconcileException(Diagram diagram, Exception e) throws CoreException {
        Activator.getInstance().logError("Reconciling the diagram: " + diagram, e);
    }
}

