/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.utils;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.papyrus.infra.core.utils.IFilter;

public class FilteredCollectionView<T>
extends AbstractCollection<T>
implements Collection<T> {
    private Collection<T> list;
    private IFilter filter;
    private int size = -1;

    public FilteredCollectionView(Collection<T> list, IFilter filter) {
        this.list = list;
        this.filter = filter;
    }

    public void setBackupCollection(Collection<T> aList) {
        this.list = aList;
    }

    public void setFilter(IFilter aFilter) {
        this.filter = aFilter;
    }

    public IFilter getFilter() {
        return this.filter;
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.size = 0;
            Iterator<T> i = this.iterator();
            while (i.hasNext()) {
                ++this.size;
                i.next();
            }
        }
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    protected T returnedValue(T ele) {
        return ele;
    }

    @Override
    public Iterator<T> iterator() {
        return new FilteredIterator();
    }

    private class FilteredIterator
    implements Iterator<T> {
        T next;
        Iterator<T> listIterator;

        public FilteredIterator() {
            this.listIterator = FilteredCollectionView.this.list.iterator();
            this.next = this.nextFilteredObject();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected T nextFilteredObject() {
            while (this.listIterator.hasNext()) {
                Object ele = this.listIterator.next();
                if (!FilteredCollectionView.this.filter.isAllowed(ele)) continue;
                return FilteredCollectionView.this.returnedValue(ele);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object ele = this.next;
            this.next = this.nextFilteredObject();
            return ele;
        }
    }
}

