/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.oclstdlib.scoping;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.xtext.base.scoping.AbstractJavaClassScope;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.oclstdlibcs.JavaClassCS;
import org.eclipse.ocl.xtext.oclstdlibcs.JavaImplementationCS;
import org.eclipse.ocl.xtext.oclstdlibcs.OCLstdlibCSFactory;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public class JavaClassScope
extends AbstractJavaClassScope {
    public static boolean SUPPRESS_WORK_THREAD = false;
    private final @NonNull List<@NonNull ClassLoader> classLoaders = new ArrayList<ClassLoader>();
    private final @Nullable IProject project;
    private final @NonNull Map<@NonNull String, @NonNull JavaClassCS> name2class = new HashMap<String, JavaClassCS>();
    private boolean doneFullScan = false;

    public static @NonNull JavaClassScope getAdapter(@NonNull BaseCSResource csResource, @NonNull ClassLoader classLoader) {
        AbstractJavaClassScope adapter = (AbstractJavaClassScope)ClassUtil.getAdapter(AbstractJavaClassScope.class, (Notifier)csResource);
        if (adapter == null) {
            adapter = new JavaClassScope(classLoader);
            csResource.eAdapters().add((Object)adapter);
        }
        return (JavaClassScope)adapter;
    }

    public static @NonNull JavaClassScope getAdapter(@NonNull BaseCSResource csResource, @NonNull List<@NonNull ClassLoader> classLoaders) {
        AbstractJavaClassScope adapter = (AbstractJavaClassScope)ClassUtil.getAdapter(AbstractJavaClassScope.class, (Notifier)csResource);
        if (adapter == null) {
            adapter = new JavaClassScope(classLoaders);
            csResource.eAdapters().add((Object)adapter);
        }
        return (JavaClassScope)adapter;
    }

    public static @NonNull JavaClassScope getAdapter(@NonNull BaseCSResource csResource, @NonNull IProject project) {
        AbstractJavaClassScope adapter = (AbstractJavaClassScope)ClassUtil.getAdapter(AbstractJavaClassScope.class, (Notifier)csResource);
        if (adapter == null) {
            adapter = new JavaClassScope(project);
            csResource.eAdapters().add((Object)adapter);
        }
        return (JavaClassScope)adapter;
    }

    @Deprecated
    public JavaClassScope(@NonNull ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
        this.project = null;
    }

    public JavaClassScope(@NonNull Iterable<@NonNull ClassLoader> classLoaders) {
        this.project = null;
        this.addClassLoaders(classLoaders);
    }

    public JavaClassScope(@NonNull IProject project) {
        this.project = project;
    }

    public void addClassLoaders(@NonNull Iterable<@NonNull ClassLoader> classLoaders) {
        for (ClassLoader classLoader : classLoaders) {
            if (this.classLoaders.contains(classLoader)) continue;
            this.classLoaders.add(classLoader);
        }
    }

    private void doFullScan() {
        HashSet<@NonNull String> classNames = new HashSet<String>(65536);
        for (ClassLoader classLoader : this.classLoaders) {
            if (!(classLoader instanceof BundleReference)) continue;
            Bundle bundle = ((BundleReference)classLoader).getBundle();
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(bundle.getSymbolicName());
            IJavaProject javaProject = JavaCore.create((IProject)iProject);
            try {
                IPackageFragmentRoot[] packageFragmentRoots = javaProject.getAllPackageFragmentRoots();
                this.scanJavaElements((IJavaElement[])packageFragmentRoots, classNames);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        if (this.project != null) {
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            try {
                IPackageFragmentRoot[] packageFragmentRoots = javaProject.getAllPackageFragmentRoots();
                this.scanJavaElements((IJavaElement[])packageFragmentRoots, classNames);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        for (String className : classNames) {
            this.getEObjectDescription(className);
        }
    }

    public void getAdapter(@NonNull BaseCSResource importedResource) {
        if (this.classLoaders.size() > 0) {
            JavaClassScope.getAdapter(importedResource, this.classLoaders);
        } else if (this.project != null) {
            JavaClassScope.getAdapter(importedResource, this.project);
        }
    }

    protected Iterable<IEObjectDescription> getAllLocalElements() {
        ArrayList<IEObjectDescription> results = new ArrayList<IEObjectDescription>();
        if (SUPPRESS_WORK_THREAD && !this.doneFullScan) {
            this.doneFullScan = true;
            this.doFullScan();
        }
        if (!this.doneFullScan) {
            this.doneFullScan = true;
            Thread thread = new Thread("OCLstdlib ClassPath Scan"){

                @Override
                public void run() {
                    JavaClassScope.this.doFullScan();
                }
            };
            thread.start();
            String name = "Try again once worker thread class path scan has completed.";
            JavaClassCS csJavaClass = OCLstdlibCSFactory.eINSTANCE.createJavaClassCS();
            csJavaClass.setName(name);
            results.add(EObjectDescription.create((String)name, (EObject)csJavaClass));
        } else {
            ArrayList<@NonNull String> sortedNames = new ArrayList<String>(this.name2class.keySet());
            Collections.sort(sortedNames);
            for (String className : sortedNames) {
                results.add(this.getEObjectDescription(className));
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IEObjectDescription getEObjectDescription(@NonNull String name) {
        JavaClassCS csJavaClass;
        Map<String, JavaClassCS> map = this.name2class;
        synchronized (map) {
            csJavaClass = this.name2class.get(name);
            if (csJavaClass == null) {
                csJavaClass = OCLstdlibCSFactory.eINSTANCE.createJavaClassCS();
                csJavaClass.setName(name);
                this.name2class.put(name, csJavaClass);
            }
        }
        return EObjectDescription.create((String)name, (EObject)csJavaClass);
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        IEObjectDescription result = this.getSingleElement(name);
        if (result != null) {
            return Collections.singleton(result);
        }
        return Collections.emptySet();
    }

    protected Iterable<IEObjectDescription> getLocalElementsByEObject(EObject object, URI uri) {
        QualifiedName qualifiedName = QualifiedName.create((String)((JavaClassCS)object).getName());
        return Collections.singletonList(EObjectDescription.create((QualifiedName)qualifiedName, (EObject)object));
    }

    protected Iterable<IEObjectDescription> getLocalElementsByName(final QualifiedName name) {
        Iterable<IEObjectDescription> localElements = this.getAllLocalElements();
        Iterable result = Iterables.filter(localElements, (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                if (JavaClassScope.this.isIgnoreCase()) {
                    QualifiedName lowerCase = name.toLowerCase();
                    QualifiedName inputLowerCase = input.getName().toLowerCase();
                    return lowerCase.equals((Object)inputLowerCase);
                }
                return name.equals((Object)input.getName());
            }
        });
        return result;
    }

    public IEObjectDescription getSingleElement(QualifiedName qualifiedName) {
        String name = qualifiedName.toString();
        if (name == null) {
            return null;
        }
        JavaClassCS csJavaClass = this.name2class.get(name);
        if (csJavaClass == null) {
            Class<?> loadClass = null;
            IType type = null;
            for (ClassLoader classLoader : this.classLoaders) {
                try {
                    loadClass = classLoader.loadClass(name);
                    if (loadClass == null) continue;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            IProject project2 = this.project;
            if (project2 != null) {
                IJavaProject javaProject = JavaCore.create((IProject)project2);
                try {
                    type = javaProject.findType(name);
                }
                catch (JavaModelException e) {
                    return null;
                }
            }
            if (loadClass == null && type == null) {
                return null;
            }
        }
        return this.getEObjectDescription(name);
    }

    public void installContents(@NonNull BaseCSResource csResource) {
        EObject eObject;
        HashSet<JavaClassCS> javaClasses = new HashSet<JavaClassCS>();
        EList contents = csResource.getContents();
        int i = contents.size();
        while (--i >= 0) {
            eObject = (EObject)contents.get(i);
            if (!(eObject instanceof JavaClassCS)) continue;
            contents.remove(i);
        }
        TreeIterator tit = csResource.getAllContents();
        while (tit.hasNext()) {
            JavaClassCS implementation;
            eObject = (EObject)tit.next();
            if (!(eObject instanceof JavaImplementationCS) || (implementation = ((JavaImplementationCS)eObject).getImplementation()) == null) continue;
            javaClasses.add(implementation);
        }
        contents.addAll(javaClasses);
    }

    protected @Nullable String resolveClassName(@NonNull String name) {
        if (!name.endsWith(".class")) {
            return null;
        }
        String className = name.substring(0, name.length() - 6);
        int dollarIndex = className.lastIndexOf(36);
        if (dollarIndex <= 0 || className.length() <= dollarIndex + 1 || !Character.isDigit(className.charAt(dollarIndex + 1))) {
            return className.replace("/", ".");
        }
        return null;
    }

    private void scanJavaElements(IJavaElement[] elements, Set<String> classNames) {
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            if (element instanceof IType) {
                IType iType = (IType)element;
                classNames.add(iType.getFullyQualifiedName());
                try {
                    if (iType.hasChildren()) {
                        this.scanJavaElements(iType.getChildren(), classNames);
                    }
                }
                catch (JavaModelException javaModelException) {}
            } else if (element instanceof IParent && !(element instanceof IMember)) {
                try {
                    IParent iParent = (IParent)element;
                    if (iParent.hasChildren()) {
                        this.scanJavaElements(iParent.getChildren(), classNames);
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }
}

