/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.compatibility.EMF_2_9;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.utilities.URIUtil;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectMap
extends StandaloneProjectMap
implements IResourceChangeListener,
IResourceDeltaVisitor {
    public static final @NonNull TracingOption PROJECT_MAP_RESOURCE_CHANGE = new TracingOption("org.eclipse.ocl.pivot", "projectMap/resourceChange");
    private IResourceDeltaVisitor visitor = null;
    private @Nullable List<@NonNull IResourceDelta> pluginXMLdeltas = null;

    public static @Nullable StandaloneProjectMap findAdapter(@NonNull ResourceSet resourceSet) {
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            return StandaloneProjectMap.findAdapter(resourceSet);
        }
        return (StandaloneProjectMap)EcoreUtil.getAdapter((List)resourceSet.eAdapters(), ProjectMap.class);
    }

    public static synchronized @NonNull StandaloneProjectMap getAdapter(@NonNull ResourceSet resourceSet) {
        if (!EcorePlugin.IS_ECLIPSE_RUNNING) {
            return StandaloneProjectMap.getAdapter(resourceSet);
        }
        StandaloneProjectMap adapter = ProjectMap.findAdapter(resourceSet);
        if (adapter == null) {
            adapter = new ProjectMap(false);
            adapter.initializeResourceSet(resourceSet);
        }
        return adapter;
    }

    public ProjectMap(boolean isGlobal) {
        super(isGlobal);
    }

    @Override
    protected  @NonNull ProjectManager.IProjectDescriptor createProjectDescriptor(@NonNull String projectName, @NonNull URI locationURI) {
        return new ProjectDescriptor(this, projectName, locationURI);
    }

    public void dispose() {
        if (this.visitor != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this.visitor = null;
        }
    }

    @Override
    public @Nullable URI getLocation(@NonNull String projectName) {
        URI uri = super.getLocation(projectName);
        if (uri == null && EMFPlugin.IS_ECLIPSE_RUNNING) {
            uri = URI.createPlatformPluginURI((String)("/" + projectName + "/"), (boolean)true);
        }
        return uri;
    }

    @Override
    public synchronized void initializePlatformResourceMap(boolean force) {
        if (force || !this.initializedPlatformResourceMap && !EMFPlugin.IS_ECLIPSE_RUNNING) {
            super.initializePlatformResourceMap(force);
        }
    }

    @Override
    public void initializeResourceSet(@Nullable ResourceSet resourceSet) {
        assert (resourceSet != null || !EMFPlugin.IS_ECLIPSE_RUNNING);
        super.initializeResourceSet(resourceSet);
    }

    @Override
    public synchronized void initializeURIMap(@Nullable ResourceSet resourceSet) {
        super.initializeURIMap(resourceSet);
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            Map<URI, URI> uriMap = ProjectMap.getURIMap(resourceSet);
            URI resourceURI = URI.createPlatformResourceURI((String)"/", (boolean)true);
            URI pluginURI = URI.createPlatformPluginURI((String)"/", (boolean)true);
            uriMap.put(resourceURI, pluginURI);
        }
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return type instanceof Class && ((Class)type).isAssignableFrom(ProjectMap.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        try {
            ProjectMap projectMap = this;
            synchronized (projectMap) {
                assert (this.pluginXMLdeltas == null);
                try {
                    event.getDelta().accept(this.visitor);
                    if (this.pluginXMLdeltas != null) {
                        for (IResourceDelta delta : this.pluginXMLdeltas) {
                            int n = delta.getKind();
                        }
                    }
                }
                finally {
                    this.pluginXMLdeltas = null;
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    @Override
    protected void scanClassPath(@NonNull Map<@NonNull String,  @NonNull ProjectManager.IProjectDescriptor> projectDescriptors, @NonNull SAXParser saxParser) {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            super.scanClassPath(projectDescriptors, saxParser);
        } else {
            this.scanProjects(projectDescriptors);
            this.scanGenModels(saxParser);
        }
    }

    protected void scanGenModels(@NonNull SAXParser saxParser) {
        HashMap<URI, String> nsURI2className;
        ExtensibleURIConverterImpl uriConverter = new ExtensibleURIConverterImpl();
        Map<String, URI> ePackageNsURIToGenModelLocationMap = EMF_2_9.EcorePlugin.getEPackageNsURIToGenModelLocationMap(true);
        HashMap<@NonNull URI, @NonNull HashMap<@NonNull URI, @Nullable String>> genModel2nsURI2className = new HashMap<URI, HashMap<URI, String>>();
        for (String ePackageNsURI : ePackageNsURIToGenModelLocationMap.keySet()) {
            URI genModelURI = ePackageNsURIToGenModelLocationMap.get(ePackageNsURI);
            if (genModelURI == null) continue;
            if (genModelURI.isPlatformResource()) {
                String platformResourcePath = genModelURI.toPlatformString(true);
                genModelURI = URI.createPlatformPluginURI((String)platformResourcePath, (boolean)true);
            }
            if ((nsURI2className = (HashMap<URI, String>)genModel2nsURI2className.get(genModelURI)) == null) {
                nsURI2className = new HashMap<URI, String>();
                genModel2nsURI2className.put(genModelURI, nsURI2className);
            }
            nsURI2className.put(URI.createURI((String)ePackageNsURI), null);
        }
        for (URI genModelURI : genModel2nsURI2className.keySet()) {
            if (!genModelURI.isPlatformPlugin()) continue;
            ProjectManager.IProjectDescriptor projectDescriptor = this.getProjectDescriptorInternal(genModelURI);
            nsURI2className = (Map)genModel2nsURI2className.get(genModelURI);
            assert (nsURI2className != null);
            @NonNull URI deresolvedGenModelURI = URIUtil.deresolve(genModelURI, projectDescriptor.getLocationURI(), true, true, true);
            @NonNull String genModelString = String.valueOf(deresolvedGenModelURI);
            ProjectManager.IResourceDescriptor resourceDescriptor = projectDescriptor.createResourceDescriptor(genModelString, nsURI2className);
            StandaloneProjectMap.GenModelReader genModelReader = new StandaloneProjectMap.GenModelReader(resourceDescriptor);
            InputStream inputStream = null;
            try {
                try {
                    inputStream = uriConverter.createInputStream(genModelURI);
                    saxParser.parse(inputStream, (DefaultHandler)genModelReader);
                }
                catch (Exception e) {
                    this.logException("Failed to parse '" + genModelURI + "'", e);
                    try {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (inputStream == null) continue;
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void refreshProject(@NonNull Map<String, ProjectManager.IProjectDescriptor> projectDescriptors, @NonNull IProject project) {
        @NonNull String projectName = project.getName();
        boolean wasOpen = projectDescriptors.containsKey(projectName);
        boolean isOpen = project.isOpen();
        if (wasOpen) {
            if (!isOpen) {
                ProjectManager.IProjectDescriptor projectDescriptor = projectDescriptors.remove(projectName);
                if (PROJECT_MAP_RESOURCE_CHANGE.isActive()) {
                    PROJECT_MAP_RESOURCE_CHANGE.println("Closing " + projectName);
                }
            }
        } else if (isOpen) {
            if (PROJECT_MAP_RESOURCE_CHANGE.isActive()) {
                PROJECT_MAP_RESOURCE_CHANGE.println("Opening " + projectName);
            }
            String projectKey = "/" + projectName + "/";
            @NonNull URI platformResourceURI = URI.createPlatformResourceURI((String)projectKey, (boolean)true);
            ProjectManager.IProjectDescriptor projectDescriptor = this.createProjectDescriptor(projectName, platformResourceURI);
            projectDescriptors.put(projectName, projectDescriptor);
        }
    }

    protected void scanProjects(@NonNull Map<String, ProjectManager.IProjectDescriptor> projectDescriptors) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (this.isGlobal && this.visitor == null) {
            this.visitor = this;
            workspace.addResourceChangeListener((IResourceChangeListener)this, 1);
        }
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project != null) {
                this.refreshProject(projectDescriptors, project);
            }
            ++n2;
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IFile file;
        String fileName;
        IResource resource = delta.getResource();
        if (resource instanceof IWorkspaceRoot) {
            return true;
        }
        if (resource instanceof IProject) {
            Map<@NonNull String,  @NonNull ProjectManager.IProjectDescriptor> projectDescriptors2 = this.getProjectDescriptors();
            assert (projectDescriptors2 != null);
            this.refreshProject(projectDescriptors2, (IProject)resource);
            return true;
        }
        if (resource instanceof IFile && "plugin.xml".equals(fileName = (file = (IFile)resource).getName())) {
            List<@NonNull IResourceDelta> pluginXMLdeltas2 = this.pluginXMLdeltas;
            if (pluginXMLdeltas2 == null) {
                this.pluginXMLdeltas = pluginXMLdeltas2 = new ArrayList<IResourceDelta>();
            }
            pluginXMLdeltas2.add(delta);
        }
        return false;
    }

    public static class ProjectDescriptor
    extends StandaloneProjectMap.ProjectDescriptor {
        public ProjectDescriptor(@NonNull ProjectMap projectMap, @NonNull String name, @NonNull URI locationURI) {
            super(projectMap, name, locationURI);
        }

        @Override
        protected @NonNull URI getResolvedGenModelURI( @NonNull ProjectManager.IResourceDescriptor resourceDescriptor) {
            URI genModelURI = resourceDescriptor.getGenModelURI();
            return genModelURI.resolve(this.getLocationURI());
        }

        @Override
        public void initializeURIMap(@NonNull Map<URI, URI> uriMap) {
            if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
                super.initializeURIMap(uriMap);
            } else if (this.locationURI.isPlatformResource()) {
                URI resourceURI = this.locationURI;
                URI pluginURI = this.getPlatformPluginURI();
                uriMap.put(resourceURI, resourceURI);
                uriMap.put(pluginURI, resourceURI);
                if (PROJECT_MAP_ADD_URI_MAP.isActive()) {
                    PROJECT_MAP_ADD_URI_MAP.println(resourceURI + " => " + resourceURI);
                    PROJECT_MAP_ADD_URI_MAP.println(pluginURI + " => " + resourceURI);
                }
            }
        }
    }
}

