/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.ecore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.library.ecore.EcoreIdResolver;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorManager;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorStandardLibrary;
import org.eclipse.ocl.pivot.internal.library.executor.LazyEcoreModelManager;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.utilities.AbstractTables;
import org.eclipse.ocl.pivot.utilities.PivotObject;

public class EcoreExecutorManager
extends ExecutorManager {
    private final @Nullable Object contextObject;
    private ModelManager modelManager = null;
    private IdResolver idResolver = null;

    public EcoreExecutorManager(@Nullable Object contextObject, @NonNull ExecutorStandardLibrary standardLibrary) {
        super(standardLibrary);
        this.contextObject = contextObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @NonNull IdResolver createIdResolver() {
        ResourceSet resourceSet;
        if (!(this.contextObject instanceof EObject)) {
            @NonNull List<T> emptyList = Collections.emptyList();
            return new EcoreIdResolver(emptyList, this.getStandardLibrary());
        }
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)((EObject)this.contextObject));
        Resource resource = rootContainer.eResource();
        Object notifier = resource != null ? ((resourceSet = resource.getResourceSet()) != null ? resourceSet : resource) : rootContainer;
        EObject eObject = notifier;
        synchronized (eObject) {
            Package root;
            EList eAdapters = notifier.eAdapters();
            for (Adapter adapter : eAdapters) {
                if (!(adapter instanceof EcoreIdResolver)) continue;
                return (EcoreIdResolver)adapter;
            }
            Object roots = null;
            if (resource != null) {
                ResourceSet resourceSet2 = resource.getResourceSet();
                if (resourceSet2 != null) {
                    roots = new ArrayList();
                    for (Resource r : resourceSet2.getResources()) {
                        roots.addAll(r.getContents());
                    }
                } else {
                    roots = resource.getContents();
                }
            }
            if ((root = this.standardLibrary.getPackage()) instanceof PivotObject) {
                if (roots == null) {
                    roots = new ArrayList();
                }
                roots.add(root);
            }
            if (roots == null) {
                roots = Collections.singletonList(rootContainer);
            }
            assert (roots != null);
            EcoreIdResolver adapter = new EcoreIdResolver((Iterable<? extends EObject>)roots, this.getStandardLibrary());
            eAdapters.add((Object)adapter);
            return adapter;
        }
    }

    @Override
    public @NonNull Type getDynamicTypeOf(@Nullable Object value) {
        IdResolver idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            this.idResolver = idResolver2 = this.createIdResolver();
        }
        return idResolver2.getDynamicTypeOf(value);
    }

    @Override
    public @NonNull IdResolver getIdResolver() {
        IdResolver idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            this.idResolver = idResolver2 = this.createIdResolver();
        }
        return idResolver2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull ModelManager getModelManager() {
        ModelManager modelManager2 = this.modelManager;
        if (modelManager2 == null) {
            EcoreExecutorManager ecoreExecutorManager = this;
            synchronized (ecoreExecutorManager) {
                modelManager2 = this.modelManager;
                if (modelManager2 == null) {
                    if (this.contextObject instanceof EObject) {
                        List<@NonNull EObject> allRootContents = LazyEcoreModelManager.computeRoots((EObject)this.contextObject);
                        ArrayList<EClass> allInstancesClassesList = null;
                        ArrayList<EClass> implicitOppositesList = null;
                        for (String nsURI : this.standardLibrary.getNsURIs()) {
                            int n;
                            int n2;
                            EClass[] eClassArray;
                            AbstractTables tables = AbstractTables.basicGet(nsURI);
                            if (tables == null) continue;
                            @NonNull EClass[] allInstancesClasses = tables.basicGetAllInstancesClasses();
                            @NonNull EReference[] implicitOpposites = tables.basicGetImplicitOpposites();
                            if (allInstancesClasses != null) {
                                if (allInstancesClassesList == null) {
                                    allInstancesClassesList = new ArrayList<EClass>();
                                }
                                eClassArray = allInstancesClasses;
                                n2 = allInstancesClasses.length;
                                n = 0;
                                while (n < n2) {
                                    EClass allInstancesClass = eClassArray[n];
                                    allInstancesClassesList.add(allInstancesClass);
                                    ++n;
                                }
                            }
                            if (implicitOpposites == null) continue;
                            if (implicitOppositesList == null) {
                                implicitOppositesList = new ArrayList<EClass>();
                            }
                            eClassArray = implicitOpposites;
                            n2 = implicitOpposites.length;
                            n = 0;
                            while (n < n2) {
                                EClass implicitOpposite = eClassArray[n];
                                implicitOppositesList.add(implicitOpposite);
                                ++n;
                            }
                        }
                        modelManager2 = new LazyEcoreModelManager(allRootContents, allInstancesClassesList, implicitOppositesList);
                    } else {
                        modelManager2 = ModelManager.NULL;
                    }
                    this.modelManager = modelManager2;
                }
            }
        }
        return modelManager2;
    }

    @Override
    public int getSeverity(@Nullable Object validationKey) {
        StatusCodes.Severity severity = this.getStandardLibrary().getSeverity(validationKey);
        return severity != null ? severity.getStatusCode() : 2;
    }

    @Override
    public @NonNull ExecutorStandardLibrary getStandardLibrary() {
        return (ExecutorStandardLibrary)this.standardLibrary;
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value) {
        IdResolver idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            this.idResolver = idResolver2 = this.createIdResolver();
        }
        return idResolver2.getStaticTypeOfValue(null, value);
    }

    @Override
    @Deprecated
    public @NonNull Class getStaticTypeOf(@Nullable Object value, Object ... values) {
        IdResolver idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            this.idResolver = idResolver2 = this.createIdResolver();
        }
        return idResolver2.getStaticTypeOf(value, values);
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values) {
        IdResolver idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            this.idResolver = idResolver2 = this.createIdResolver();
        }
        return idResolver2.getStaticTypeOf(value, values);
    }

    @Override
    public @NonNull Class getStaticTypeOfValue(@Nullable Type staticType, @Nullable Object value) {
        IdResolver idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            this.idResolver = idResolver2 = this.createIdResolver();
        }
        return idResolver2.getStaticTypeOfValue(staticType, value);
    }
}

