/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractProperty;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class ImplicitNonCompositionProperty
extends AbstractProperty {
    protected @NonNull Property property;

    public ImplicitNonCompositionProperty(@NonNull Property property) {
        this.property = property;
    }

    @Override
    public @Nullable Object evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        EObject esObject;
        if (sourceValue == null) {
            return null;
        }
        IdResolver idResolver = executor.getIdResolver();
        Property oppositeProperty = this.property.getOpposite();
        Iterable<Object> results = null;
        ModelManager modelManager = executor.getModelManager();
        if (modelManager instanceof ModelManager.EcoreModelManager && (esObject = oppositeProperty.getESObject()) instanceof EReference) {
            ArrayList<Object> resultList = new ArrayList<Object>();
            if (sourceValue instanceof EObject) {
                EReference oppositeEReference = (EReference)esObject;
                results = new ArrayList();
                Iterable<@NonNull EObject> opposites = ((ModelManager.EcoreModelManager)modelManager).getOpposites(oppositeEReference, (EObject)sourceValue);
                if (opposites != null) {
                    for (EObject opposite : opposites) {
                        resultList.add(idResolver.boxedValueOf(opposite));
                    }
                }
            }
            results = resultList;
        }
        if (results == null) {
            results = new ArrayList();
            ModelManager.ModelManagerExtension2 modelManager2 = (ModelManager.ModelManagerExtension2)modelManager;
            results = modelManager2.getOpposite(oppositeProperty, sourceValue);
        }
        if (returnTypeId instanceof CollectionTypeId) {
            return idResolver.createCollectionOfAll(false, false, returnTypeId, results);
        }
        int size = Iterables.size(results);
        if (size <= 1) {
            return size == 1 ? results.iterator().next() : null;
        }
        throw new InvalidValueException("Multiple opposites for '" + oppositeProperty + "'", new Object[0]);
    }
}

