/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.AbstractSingletonScope;
import org.eclipse.ocl.pivot.ids.IdHash;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.NsURIPackageId;
import org.eclipse.ocl.pivot.ids.SingletonScope;
import org.eclipse.ocl.pivot.internal.ids.AbstractPackageIdImpl;

public class NsURIPackageIdImpl
extends AbstractPackageIdImpl
implements NsURIPackageId {
    protected final @NonNull String nsURI;
    protected final @Nullable String nsPrefix;
    private @Nullable EPackage ePackage = null;

    private static int computeHashCode(@NonNull String name) {
        return IdHash.createGlobalHash(NsURIPackageId.class, name);
    }

    public NsURIPackageIdImpl(@NonNull IdManager idManager, @NonNull String nsURI, @Nullable String nsPrefix, @Nullable EPackage ePackage) {
        super(NsURIPackageIdImpl.computeHashCode(nsURI));
        this.nsURI = nsURI;
        this.nsPrefix = nsPrefix;
        if (ePackage != null) {
            this.setEPackage(ePackage);
        }
    }

    @Override
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitNsURIPackageId(this);
    }

    @Override
    public @NonNull String getDisplayName() {
        return this.nsURI;
    }

    @Override
    public @Nullable EPackage getEPackage() {
        if (this.ePackage != null && this.ePackage.eIsProxy()) {
            throw new IllegalStateException("'" + this.nsURI + "' is a proxy because it has been unloaded.");
        }
        return this.ePackage;
    }

    @Override
    public @Nullable String getNsPrefix() {
        return this.nsPrefix;
    }

    @Override
    public @NonNull String getNsURI() {
        return this.nsURI;
    }

    @Override
    public void setEPackage(@NonNull EPackage ePackage) {
        Resource eResource;
        assert (!ePackage.eIsProxy());
        if (ePackage.getClass() != EPackageImpl.class && ((eResource = ePackage.eResource()) == null || eResource.getResourceSet() == null)) {
            this.ePackage = ePackage;
        }
    }

    @Override
    public String toString() {
        return "'" + this.nsURI + "'";
    }

    public static class NsURIPackageIdSingletonScope
    extends AbstractSingletonScope<NsURIPackageId, NsURIPackageIdValue> {
        public @NonNull NsURIPackageId getSingleton(@NonNull IdManager idManager, @NonNull String nsURI, @Nullable String nsPrefix, @Nullable EPackage ePackage) {
            return this.getSingletonFor(new NsURIPackageIdValue(idManager, nsURI, nsPrefix, ePackage));
        }
    }

    private static class NsURIPackageIdValue
    extends SingletonScope.AbstractKeyAndValue<NsURIPackageId> {
        private final @NonNull IdManager idManager;
        private @NonNull String nsURI;
        private @Nullable String nsPrefix;
        private @Nullable EPackage ePackage;

        private NsURIPackageIdValue(@NonNull IdManager idManager, @NonNull String nsURI, @Nullable String nsPrefix, @Nullable EPackage ePackage) {
            super(NsURIPackageIdImpl.computeHashCode(nsURI));
            this.idManager = idManager;
            this.nsURI = nsURI;
            this.nsPrefix = nsPrefix;
            this.ePackage = ePackage;
        }

        @Override
        public @NonNull NsURIPackageId createSingleton() {
            return new NsURIPackageIdImpl(this.idManager, this.nsURI, this.nsPrefix, this.ePackage);
        }

        @Override
        public boolean equals(@Nullable Object that) {
            if (that instanceof NsURIPackageIdImpl) {
                NsURIPackageIdImpl singleton = (NsURIPackageIdImpl)that;
                return this.nsURI.equals(singleton.getNsURI());
            }
            return false;
        }
    }
}

