/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.util;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ISelectionProvider;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.report.IOutputter;
import org.eclipse.mat.report.RendererRegistry;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public abstract class Copy {
    protected Control control;
    protected Item[] selection;

    public static void copyToClipboard(Control control) {
        TableItem[] selection = control instanceof Table ? ((Table)control).getSelection() : ((Tree)control).getSelection();
        new CopyToClipboard(control, (Item[])selection).doCopy();
    }

    public static void copyToClipboard(String text, Display display) {
        Clipboard clipboard = new Clipboard(display);
        clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }

    private Copy(Control control, Item[] selection) {
        this.control = control;
        this.selection = selection != null && selection.length > 0 ? selection : null;
    }

    protected IResultTable convert(final Table ct) {
        IResultTable t = new IResultTable(){

            public Column[] getColumns() {
                TableColumn[] tcs = ct.getColumns();
                int[] order = ct.getColumnOrder();
                Column[] c = new Column[order.length];
                int i = 0;
                while (i < order.length) {
                    int col = order[i];
                    TableColumn tc = tcs[col];
                    c[i] = new Column(tc.getText());
                    switch (tc.getAlignment()) {
                        case 131072: {
                            c[i].aligning(Column.Alignment.RIGHT);
                            break;
                        }
                        case 0x1000000: {
                            c[i].aligning(Column.Alignment.CENTER);
                            break;
                        }
                        default: {
                            c[i].aligning(Column.Alignment.LEFT);
                        }
                    }
                    ++i;
                }
                return c;
            }

            public Object getColumnValue(Object row, int columnIndex) {
                return ((TableItem)row).getText(ct.getColumnOrder()[columnIndex]);
            }

            public IContextObject getContext(Object row) {
                return null;
            }

            public ResultMetaData getResultMetaData() {
                return null;
            }

            public int getRowCount() {
                if (Copy.this.selection != null) {
                    return Copy.this.selection.length;
                }
                return ct.getItemCount();
            }

            public Object getRow(int rowId) {
                if (Copy.this.selection != null) {
                    return Copy.this.selection[rowId];
                }
                return ct.getItems()[rowId];
            }
        };
        return t;
    }

    protected IResultTree convert(final Tree ct) {
        final HashSet<Item> selset = this.selection != null ? new HashSet<Item>(Arrays.asList(this.selection)) : Collections.emptySet();
        IRTS t = new IRTS(){

            public Column[] getColumns() {
                TreeColumn[] tcs = ct.getColumns();
                int[] order = ct.getColumnOrder();
                Column[] c = new Column[tcs.length];
                int i = 0;
                while (i < order.length) {
                    int col = order[i];
                    TreeColumn tc = tcs[col];
                    c[i] = new Column(tc.getText());
                    switch (tc.getAlignment()) {
                        case 131072: {
                            c[i].aligning(Column.Alignment.RIGHT);
                            break;
                        }
                        case 0x1000000: {
                            c[i].aligning(Column.Alignment.CENTER);
                            break;
                        }
                        default: {
                            c[i].aligning(Column.Alignment.LEFT);
                        }
                    }
                    ++i;
                }
                return c;
            }

            public Object getColumnValue(Object row, int columnIndex) {
                TreeItem treeitem = (TreeItem)row;
                int[] order = ct.getColumnOrder();
                if (order.length == 0 || columnIndex == -1) {
                    return treeitem.getText();
                }
                return treeitem.getText(order[columnIndex]);
            }

            public IContextObject getContext(Object row) {
                return null;
            }

            public ResultMetaData getResultMetaData() {
                return null;
            }

            public List<?> getElements() {
                if (Copy.this.selection == null) {
                    return Arrays.asList(ct.getItems());
                }
                ArrayList<TreeItem> ret = new ArrayList<TreeItem>();
                Item[] itemArray = Copy.this.selection;
                int n = Copy.this.selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem ti;
                    TreeItem pi;
                    Item i = itemArray[n2];
                    if (i instanceof TreeItem && !selset.contains(pi = (ti = (TreeItem)i).getParentItem())) {
                        ret.add(ti);
                    }
                    ++n2;
                }
                return ret;
            }

            public boolean hasChildren(Object element) {
                int ret = ((TreeItem)element).getItemCount();
                return ret > 0;
            }

            public List<?> getChildren(Object parent) {
                if (Copy.this.selection == null) {
                    return Arrays.asList(((TreeItem)parent).getItems());
                }
                ArrayList<TreeItem> ret = new ArrayList<TreeItem>();
                TreeItem[] treeItemArray = ((TreeItem)parent).getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem ti = treeItemArray[n2];
                    if (selset.contains(ti)) {
                        ret.add(ti);
                    }
                    ++n2;
                }
                return ret;
            }

            public boolean isSelected(Object row) {
                return selset.contains(row);
            }

            public boolean isExpanded(Object row) {
                return ((TreeItem)row).getExpanded();
            }
        };
        return t;
    }

    /* synthetic */ Copy(Control control, Item[] itemArray, Copy copy) {
        this(control, itemArray);
    }

    private static class ContextImpl
    implements IOutputter.Context {
        private File outputDir;
        private IQueryContext context;

        public ContextImpl(IQueryContext context, File outputDir) {
            this.context = context;
            this.outputDir = outputDir;
        }

        public String getId() {
            return "X";
        }

        public int getLimit() {
            return 0;
        }

        public File getOutputDirectory() {
            return this.outputDir;
        }

        public String getPathToRoot() {
            return "";
        }

        public IQueryContext getQueryContext() {
            return this.context;
        }

        public String addIcon(URL icon) {
            return null;
        }

        public String addContextResult(String name, IResult result) {
            return null;
        }

        public boolean hasLimit() {
            return false;
        }

        public boolean isColumnVisible(int columnIndex) {
            return true;
        }

        public String param(String key, String defaultValue) {
            return defaultValue;
        }

        public String param(String key) {
            return null;
        }

        public boolean isTotalsRowVisible() {
            return true;
        }
    }

    private static class CopyToClipboard
    extends Copy {
        private CopyToClipboard(Control control, Item[] selection) {
            super(control, selection, null);
        }

        private void doCopy() {
            IResultTable t = this.control instanceof Table ? this.convert((Table)this.control) : this.convert((Tree)this.control);
            StringWriter writer = null;
            try {
                IOutputter outputter = RendererRegistry.instance().match("txt", t.getClass());
                if (outputter == null) {
                    throw new UnsupportedOperationException(Messages.ExportActions_ExportTXT);
                }
                writer = new StringWriter();
                outputter.process((IOutputter.Context)new ContextImpl(null, null), (IResult)t, (Writer)writer);
                writer.flush();
                writer.close();
                CopyToClipboard.copyToClipboard(writer.toString(), this.control.getDisplay());
            }
            catch (IOException | UnsupportedOperationException e) {
                MemoryAnalyserPlugin.log(e);
                return;
            }
        }
    }

    static interface IRTS
    extends IResultTree,
    ISelectionProvider {
    }
}

