/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.viewer;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextDerivedData;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.refined.RefinedStructuredResult;
import org.eclipse.mat.query.refined.RefinedTree;
import org.eclipse.mat.query.refined.TotalsRow;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.accessibility.AccessibleCompositeAdapter;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.AbstractPaneJob;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.internal.viewer.DerivedDataJob;
import org.eclipse.mat.ui.internal.viewer.RefinedResultViewer;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class RefinedTreeViewer
extends RefinedResultViewer {
    Tree tree;
    TreeEditor treeEditor;

    public RefinedTreeViewer(IQueryContext context, QueryResult result, RefinedTree tree) {
        super(context, result, (RefinedStructuredResult)tree);
    }

    @Override
    public void init(Composite parent, MultiPaneEditor editor, AbstractEditorPane pane) {
        super.init(new TreeAdapter(), parent, editor, pane);
        this.tree.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                TreeItem parentItem = (TreeItem)event.item;
                RefinedTreeViewer.this.doExpand(parentItem);
            }
        });
        this.tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 16777263) {
                    TreeItem[] treeItemArray = RefinedTreeViewer.this.tree.getSelection();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        this.collapse(item);
                        ++n2;
                    }
                    event.doit = false;
                } else if (event.keyCode == 16777259 && (event.stateMask & SWT.MOD2) != 0) {
                    TreeItem[] treeItemArray = RefinedTreeViewer.this.tree.getSelection();
                    int n = treeItemArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TreeItem item = treeItemArray[n3];
                        if (item.getItemCount() > 0) {
                            item.setExpanded(true);
                            Object ctrl = item.getData("$control");
                            if (ctrl == null) {
                                RefinedTreeViewer.this.doExpand(item);
                            }
                        }
                        ++n3;
                    }
                    event.doit = false;
                }
            }

            private void collapse(TreeItem parentItem) {
                if (parentItem != null && parentItem.getExpanded()) {
                    parentItem.setExpanded(false);
                    TreeItem[] treeItemArray = parentItem.getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem sub = treeItemArray[n2];
                        this.collapse(sub);
                        ++n2;
                    }
                }
            }
        });
        this.tree.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                TreeItem widget = (TreeItem)event.item;
                if (widget == null) {
                    return;
                }
                if (widget.isDisposed()) {
                    return;
                }
                Object data = widget.getData();
                if (data == null) {
                    return;
                }
                if (widget.getExpanded()) {
                    widget.setExpanded(false);
                } else if (widget.getItemCount() > 0) {
                    widget.setExpanded(true);
                    Object ctrl = widget.getData("$control");
                    if (ctrl == null) {
                        RefinedTreeViewer.this.doExpand(widget);
                    }
                }
            }
        });
        Listener focusBoxListener = new Listener(){

            public void handleEvent(Event event) {
                if ((event.detail & 4) != 0) {
                    int w = 0;
                    int i = 0;
                    while (i < RefinedTreeViewer.this.tree.getColumnCount()) {
                        w += RefinedTreeViewer.this.tree.getColumn(i).getWidth();
                        ++i;
                    }
                    event.gc.drawFocus(0, event.y, w - 1, event.height);
                }
            }
        };
        this.tree.addListener(40, focusBoxListener);
        this.tree.addListener(42, focusBoxListener);
    }

    @Override
    protected void configureColumns() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExpand(TreeItem parentItem) {
        RefinedResultViewer.ControlItem parentCtrl = (RefinedResultViewer.ControlItem)parentItem.getData("$control");
        if (parentCtrl == null) {
            int level = 1;
            TreeItem grandfather = parentItem.getParentItem();
            if (grandfather != null) {
                RefinedResultViewer.ControlItem pc = (RefinedResultViewer.ControlItem)grandfather.getData("$control");
                level = pc.level + 1;
            }
            parentCtrl = new RefinedResultViewer.ControlItem(false, level);
            parentItem.setData("$control", (Object)parentCtrl);
        }
        RefinedResultViewer.ControlItem controlItem = parentCtrl;
        synchronized (controlItem) {
            if (parentCtrl.children == null) {
                ReadDataThread t = new ReadDataThread(this, parentCtrl, parentItem, parentItem.getData(), false);
                t.start();
                try {
                    parentCtrl.wait(100L);
                    if (parentCtrl.children == null || parentCtrl.children.isEmpty()) {
                        TreeItem[] items = parentItem.getItems();
                        int ii = 0;
                        while (ii < items.length) {
                            items[ii].dispose();
                            ++ii;
                        }
                        this.applyUpdating((Item)new TreeItem(parentItem, 0, 0));
                        return;
                    }
                    parentCtrl.hasBeenPainted = true;
                    this.doUpdateChildren((Item)parentItem, parentCtrl);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    protected void widgetRevealChildren(Item parent, TotalsRow totalsData) {
        if (parent == null) {
            RefinedResultViewer.ControlItem ctrl = (RefinedResultViewer.ControlItem)this.tree.getData("$control");
            int nrItems = this.tree.getItemCount();
            this.tree.getItem(nrItems - 1).dispose();
            int currentlyVisible = nrItems - 2;
            int visible = ctrl.totals.getVisibleItems();
            int ii = currentlyVisible;
            while (ii < visible) {
                TreeItem item = new TreeItem(this.tree, 0, ii + 1);
                this.doUpdateChild(item, ctrl, ctrl.children.get(ii));
                ++ii;
            }
            boolean isTotalsRowVisible = ctrl.totals.isVisible();
            if (isTotalsRowVisible) {
                this.applyTotals((Item)new TreeItem(this.tree, 0, visible + 1), ctrl.totals);
            }
        } else {
            RefinedResultViewer.ControlItem ctrl = (RefinedResultViewer.ControlItem)parent.getData("$control");
            TreeItem parentItem = (TreeItem)parent;
            int nrItems = parentItem.getItemCount();
            parentItem.getItem(nrItems - 1).dispose();
            int currentlyVisible = nrItems - 1;
            int visible = ctrl.totals.getVisibleItems();
            int ii = currentlyVisible;
            while (ii < visible) {
                TreeItem item = new TreeItem(parentItem, 0, ii);
                this.doUpdateChild(item, ctrl, ctrl.children.get(ii));
                ++ii;
            }
            boolean isTotalsRowVisible = ctrl.totals.isVisible();
            if (isTotalsRowVisible) {
                this.applyTotals((Item)new TreeItem(parentItem, 0, visible), ctrl.totals);
            }
        }
    }

    @Override
    protected List<?> getElements(Object parent) {
        return parent == null ? ((IResultTree)this.result).getElements() : ((IResultTree)this.result).getChildren(parent);
    }

    @Override
    protected void doCalculateDerivedValuesForAll(ContextProvider provider, ContextDerivedData.DerivedOperation operation) {
        super.doCalculateDerivedValuesForAll(provider, operation);
        LinkedList<TreeItem> children = new LinkedList<TreeItem>();
        int count = this.tree.getItemCount();
        int index = 1;
        while (index < count) {
            TreeItem item = this.tree.getItem(index);
            RefinedResultViewer.ControlItem ctrl = (RefinedResultViewer.ControlItem)item.getData("$control");
            if (ctrl != null && ctrl.children != null) {
                DerivedDataJob.OnFullList onFullListJob = new DerivedDataJob.OnFullList(this, provider, operation, ctrl.children, (Item)item, ctrl);
                onFullListJob.setPriority(50);
                onFullListJob.schedule();
                children.add(item);
            }
            ++index;
        }
        while (!children.isEmpty()) {
            TreeItem child = (TreeItem)children.removeFirst();
            count = child.getItemCount();
            int index2 = 0;
            while (index2 < count) {
                TreeItem item = child.getItem(index2);
                RefinedResultViewer.ControlItem ctrl = (RefinedResultViewer.ControlItem)item.getData("$control");
                if (ctrl != null && ctrl.children != null) {
                    DerivedDataJob.OnFullList onFullListJob = new DerivedDataJob.OnFullList(this, provider, operation, ctrl.children, (Item)item, ctrl);
                    onFullListJob.setPriority(50);
                    onFullListJob.schedule();
                    children.add(item);
                }
                ++index2;
            }
        }
    }

    @Override
    protected void refresh(boolean expandAndSelect) {
        RefinedResultViewer.ControlItem ctrl = new RefinedResultViewer.ControlItem(expandAndSelect, 0);
        this.tree.setData("$control", (Object)ctrl);
        TreeItem[] items = this.tree.getItems();
        int ii = 1;
        while (ii < items.length) {
            items[ii].dispose();
            ++ii;
        }
        if (this.tree.getItemCount() == 0) {
            this.applyFilterData((Item)new TreeItem(this.tree, 0, 0));
        }
        this.applyUpdating((Item)new TreeItem(this.tree, 0, 1));
        RefinedResultViewer.RetrieveChildrenJob retrieveChildrenJob = new RefinedResultViewer.RetrieveChildrenJob(this, ctrl, null, null);
        retrieveChildrenJob.setUser(true);
        retrieveChildrenJob.setPriority(20);
        retrieveChildrenJob.schedule();
    }

    @Override
    protected void doUpdateChildren(Item parentItem, RefinedResultViewer.ControlItem ctrl) {
        if (parentItem == null) {
            this.tree.setData("$control", (Object)ctrl);
            TreeItem[] items = this.tree.getItems();
            int ii = 1;
            while (ii < items.length) {
                items[ii].dispose();
                ++ii;
            }
            if (this.tree.getItemCount() == 0) {
                this.applyFilterData((Item)new TreeItem(this.tree, 0, 0));
            }
            int visible = ctrl.totals.getVisibleItems();
            int ii2 = 0;
            while (ii2 < visible) {
                TreeItem item = new TreeItem(this.tree, 0, ii2 + 1);
                this.doUpdateChild(item, ctrl, ctrl.children.get(ii2));
                ++ii2;
            }
            boolean isTotalsRowVisible = ctrl.totals.isVisible();
            if (isTotalsRowVisible) {
                this.applyTotals((Item)new TreeItem(this.tree, 0, visible + 1), ctrl.totals);
            }
            if (this.needsPacking) {
                this.needsPacking = false;
                this.pack();
            }
        } else {
            TreeItem parent = (TreeItem)parentItem;
            boolean expanded = parent.getExpanded();
            parent.setData("$control", (Object)ctrl);
            TreeItem[] items = parent.getItems();
            int ii = 0;
            while (ii < items.length) {
                items[ii].dispose();
                ++ii;
            }
            int visible = ctrl.totals.getVisibleItems();
            int ii3 = 0;
            while (ii3 < visible) {
                TreeItem item = new TreeItem(parent, 0, ii3);
                this.doUpdateChild(item, ctrl, ctrl.children.get(ii3));
                ++ii3;
            }
            parent.setExpanded(expanded);
            boolean isTotalsRowVisible = ctrl.totals.isVisible();
            if (isTotalsRowVisible) {
                this.applyTotals((Item)new TreeItem(parent, 0, visible), ctrl.totals);
            }
        }
    }

    private void doUpdateChild(TreeItem item, RefinedResultViewer.ControlItem ctrl, Object element) {
        this.applyTextAndImage((Item)item, element);
        if (((RefinedTree)this.result).hasChildren(element)) {
            if (ctrl.expandAndSelect && this.result.isExpanded(element) && ctrl.level < 25) {
                item.setData("$control", (Object)new RefinedResultViewer.ControlItem(true, ctrl.level + 1));
                this.doExpand(item);
                item.setExpanded(true);
            } else {
                new TreeItem(item, 0);
            }
        }
        if (ctrl.expandAndSelect && this.result.isSelected(element)) {
            this.tree.select(item);
        }
    }

    public void refresh(List<?> elementPath) {
        if (elementPath == null || elementPath.isEmpty()) {
            return;
        }
        LinkedList list = new LinkedList();
        list.addAll(elementPath);
        Object root = list.removeFirst();
        int count = this.tree.getItemCount();
        int ii = 0;
        while (ii < count) {
            TreeItem item = this.tree.getItem(ii);
            if (item.getData() == root) {
                this.doClear(list, item);
                return;
            }
            ++ii;
        }
        this.refresh(false);
    }

    private void doClear(LinkedList<?> path, TreeItem item) {
        block0: while (!path.isEmpty()) {
            Object current = path.removeFirst();
            int count = item.getItemCount();
            int index = 0;
            while (index < count) {
                TreeItem child = item.getItem(index);
                if (child.getData() == current) {
                    if (path.isEmpty()) {
                        child.setData("$control", null);
                        this.doExpand(child);
                        return;
                    }
                    item = child;
                    continue block0;
                }
                ++index;
            }
            break block0;
        }
    }

    private void pack() {
        this.tree.getParent().setRedraw(false);
        try {
            Item[] itemArray = this.columns;
            int n = this.columns.length;
            int n2 = 0;
            while (n2 < n) {
                Item item = itemArray[n2];
                TreeColumn column = (TreeColumn)item;
                column.pack();
                if (column.getWidth() > 500) {
                    column.setWidth(500);
                }
                if (column.getWidth() < 90) {
                    column.setWidth(90);
                }
                ++n2;
            }
        }
        finally {
            this.tree.getParent().setRedraw(true);
        }
    }

    static class ReadDataThread
    extends Thread {
        RefinedResultViewer viewer;
        RefinedResultViewer.ControlItem ctrl;
        TreeItem item;
        Object data;
        boolean initial;

        public ReadDataThread(RefinedResultViewer viewer, RefinedResultViewer.ControlItem ctrl, TreeItem item, Object data, boolean initial) {
            this.viewer = viewer;
            this.ctrl = ctrl;
            this.item = item;
            this.data = data;
            this.initial = initial;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List<?> elements = this.viewer.getElements(this.data);
            TotalsRow totals = this.viewer.result.buildTotalsRow(elements);
            totals.setVisibleItems(Math.min(this.viewer.limit, totals.getNumberOfItems()));
            RefinedResultViewer.ControlItem controlItem = this.ctrl;
            synchronized (controlItem) {
                this.ctrl.children = elements;
                this.ctrl.totals = totals;
                this.ctrl.hasBeenPainted = false;
                this.ctrl.notifyAll();
            }
            if (!this.viewer.control.isDisposed()) {
                this.viewer.control.getDisplay().asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (viewer.control.isDisposed()) {
                            return;
                        }
                        RefinedResultViewer.ControlItem controlItem = ctrl;
                        synchronized (controlItem) {
                            if (!ctrl.hasBeenPainted) {
                                ctrl.hasBeenPainted = true;
                                viewer.control.getParent().setRedraw(false);
                                try {
                                    viewer.doUpdateChildren((Item)item, ctrl);
                                }
                                finally {
                                    viewer.control.getParent().setRedraw(true);
                                }
                            }
                        }
                    }
                });
            }
            if (!elements.isEmpty()) {
                this.calculateTotals(elements);
            }
        }

        private void calculateTotals(final List<?> elements) {
            new AbstractPaneJob(Messages.RefinedTreeViewer_CalculateTotals, this.viewer.pane){

                @Override
                protected IStatus doRun(IProgressMonitor monitor) {
                    ProgressMonitorWrapper listener = new ProgressMonitorWrapper(monitor);
                    viewer.result.calculateTotals(elements, ctrl.totals, (IProgressListener)listener);
                    if (!viewer.control.isDisposed()) {
                        viewer.control.getDisplay().asyncExec(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (viewer.control.isDisposed()) {
                                    return;
                                }
                                RefinedResultViewer.ControlItem controlItem = ctrl;
                                synchronized (controlItem) {
                                    viewer.control.getParent().setRedraw(false);
                                    try {
                                        if (item.isDisposed()) {
                                            return;
                                        }
                                        Item i = viewer.adapter.getItem((Item)item, ctrl.totals.getVisibleItems());
                                        viewer.applyTotals(i, ctrl.totals);
                                    }
                                    finally {
                                        viewer.control.getParent().setRedraw(true);
                                    }
                                }
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            };
        }
    }

    public class TreeAdapter
    implements RefinedResultViewer.WidgetAdapter {
        @Override
        public Composite createControl(Composite parent) {
            RefinedTreeViewer.this.tree = new Tree(parent, 65538);
            RefinedTreeViewer.this.tree.setHeaderVisible(true);
            RefinedTreeViewer.this.tree.setLinesVisible(true);
            AccessibleCompositeAdapter.access(RefinedTreeViewer.this.tree);
            return RefinedTreeViewer.this.tree;
        }

        @Override
        public ControlEditor createEditor() {
            RefinedTreeViewer.this.treeEditor = new TreeEditor(RefinedTreeViewer.this.tree);
            return RefinedTreeViewer.this.treeEditor;
        }

        @Override
        public Item getItem(Item item, int index) {
            if (item == null) {
                return RefinedTreeViewer.this.tree.getItem(index);
            }
            return ((TreeItem)item).getItem(index);
        }

        @Override
        public void setExpanded(Item item, boolean expanded) {
            ((TreeItem)item).setExpanded(expanded);
        }

        @Override
        public void setItemCount(Item item, int count) {
            if (item == null) {
                RefinedTreeViewer.this.tree.setItemCount(count);
            } else {
                ((TreeItem)item).setItemCount(count);
            }
        }

        @Override
        public Item getItem(Point pt) {
            return RefinedTreeViewer.this.tree.getItem(pt);
        }

        @Override
        public void setEditor(Composite composite, Item item, int columnIndex) {
            RefinedTreeViewer.this.tree.showItem((TreeItem)item);
            RefinedTreeViewer.this.treeEditor.setEditor((Control)composite, (TreeItem)item, columnIndex);
        }

        @Override
        public Item getParentItem(Item item) {
            return ((TreeItem)item).getParentItem();
        }

        @Override
        public Item[] getSelection() {
            return RefinedTreeViewer.this.tree.getSelection();
        }

        @Override
        public Item createColumn(Column queryColumn, int index, SelectionListener listener) {
            TreeColumn column = new TreeColumn(RefinedTreeViewer.this.tree, queryColumn.getAlign().getSwtCode(), index);
            column.setData((Object)queryColumn);
            column.setText(queryColumn.getLabel());
            column.setMoveable(true);
            column.setWidth(90);
            column.addSelectionListener(listener);
            return column;
        }

        @Override
        public Font getFont() {
            return RefinedTreeViewer.this.tree.getFont();
        }

        @Override
        public Item getSortColumn() {
            return RefinedTreeViewer.this.tree.getSortColumn();
        }

        @Override
        public int getSortDirection() {
            return RefinedTreeViewer.this.tree.getSortDirection();
        }

        @Override
        public void setSortColumn(Item column) {
            RefinedTreeViewer.this.tree.setSortColumn((TreeColumn)column);
        }

        @Override
        public void setSortDirection(int direction) {
            RefinedTreeViewer.this.tree.setSortDirection(direction);
        }

        @Override
        public int getItemCount(Item item) {
            if (item == null) {
                return RefinedTreeViewer.this.tree.getItemCount();
            }
            return ((TreeItem)item).getItemCount();
        }

        @Override
        public int indexOf(Item item) {
            TreeItem treeItem = (TreeItem)item;
            TreeItem parent = treeItem.getParentItem();
            if (parent == null) {
                return RefinedTreeViewer.this.tree.indexOf(treeItem);
            }
            return parent.indexOf(treeItem);
        }

        @Override
        public Rectangle getBounds(Item item, int index) {
            return ((TreeItem)item).getBounds(index);
        }

        @Override
        public Rectangle getTextBounds(Widget item, int index) {
            return ((TreeItem)item).getBounds(index);
        }

        @Override
        public Rectangle getImageBounds(Item item, int index) {
            return ((TreeItem)item).getImageBounds(index);
        }

        @Override
        public void apply(Item item, int index, String label, Color color, Font font) {
            TreeItem treeItem = (TreeItem)item;
            treeItem.setFont(index, font);
            treeItem.setText(index, label);
            treeItem.setForeground(index, color);
        }

        @Override
        public void apply(Item item, Font font) {
            ((TreeItem)item).setFont(font);
        }

        @Override
        public void apply(Item item, int index, String label) {
            ((TreeItem)item).setText(index, label);
        }

        @Override
        public int getLineHeightEstimation() {
            if ("linux".equals(Platform.getOS())) {
                return 26;
            }
            if ("macosx".equals(Platform.getOS())) {
                return 20;
            }
            if (System.getProperty("os.name").indexOf("Vista") >= 0) {
                return 19;
            }
            return 18;
        }

        @Override
        public int[] getColumnOrder() {
            return RefinedTreeViewer.this.tree.getColumnOrder();
        }

        @Override
        public void setColumnOrder(int[] order) {
            RefinedTreeViewer.this.tree.setColumnOrder(order);
        }

        @Override
        public int getColumnWidth(int col) {
            TreeColumn column = (TreeColumn)RefinedTreeViewer.this.columns[col];
            return column.getWidth();
        }

        @Override
        public void setColumnWidth(int col, int width) {
            width = Math.min(500, Math.max(90, width));
            TreeColumn column = (TreeColumn)RefinedTreeViewer.this.columns[col];
            column.setWidth(width);
        }
    }
}

